﻿<%@ WebService Language="C#" Class="GiveAuthority_Service" %>

using System;
using System.Web;
using System.Web.Services;
using System.Web.Services.Protocols;
using SysCore.Model;
using SysCore.DAL;

[WebService(Namespace = "http://tempuri.org/")]
[WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1)]
// 若要允许使用 ASP.NET AJAX 从脚本中调用此 Web 服务，请取消注释以下行。 
[System.Web.Script.Services.ScriptService]
public class GiveAuthority_Service : System.Web.Services.WebService
{
    /// <summary>
    /// 保存
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string Save(string type,string module,int id,string val)
    {
        
        AuthDAL dal = new AuthDAL();
        try
        {
            if (type.Equals("Member"))
            {
                dal.DeleteMemberAuthByModule(id, module);
            }
            else 
            {
                dal.DeleteRoleAuthByModule(id, module);
            }
        }
        catch (Exception e)
        {
            return e.Message;
        }
        if (!val.Equals(""))
        {
            foreach (string auth in val.Split(','))
            {
                try
                {
                    if (type.Equals("Member"))
                    {
                        dal.AddMemberAuth(id, auth);
                    }
                    else
                    {
                        dal.AddRoleAuth(id, auth);
                    }
                }
                catch (Exception e)
                {
                    return e.Message;
                }
            }
        }
        return "success";
    }
}