﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Data.SqlClient;
using SysCore;
using SysCore.Model;
using SysCore.DAL;
using SysCore.Control;

public partial class System_Config_Config : System.Web.UI.Page
{
    public string html = "",li="";
    public string msg = "";
    public AuthUI auth = new AuthUI();
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!Page.IsPostBack)
        {
            new LoginState().CheckLogin();
            //检查模块查看权限
            auth.AuthCheckAndResponse("System_Config");
            if (Request["action"] != null)
            {
                if (Request["action"].Equals("Save"))
                {
                    SaveConfig();
                }
            }
            Init_Page();
        }
    }
    void SaveConfig()
    {
        ConfigDAL dal = new ConfigDAL();
        SqlUtil su = new SqlUtil();
        for (int i = 0; i < Request.Form.Count; i++)
        {
            string sql = "update System_Config set cf_value=@cf_value where cf_code=@cf_code";
            SqlParameter[] par ={
                new SqlParameter("@cf_value",Request.Form[i].ToString()),
                new SqlParameter("@cf_code",Request.Form.Keys[i])
            };
            su.ExecuteNonQuery(sql, par);
        }
    }
    void Init_Page()
    {
        ConfigDAL dal = new ConfigDAL();

        DataTable dt_m = dal.GetModuleList();
        string li_class = "",div_class="";
        int li_iter = 1;
        foreach (DataRow dr_li in dt_m.Rows)
        {
            li_class = "";
            div_class = "";
            if (li_iter == 1)
            {
                li_class = " class='on'";
                div_class = " show";
            }
            li_iter++;
            li += "<li" + li_class + ">" + dr_li["module_name"] + "</li>\n";

            string module_code = dr_li["module_code"].ToString();
            DataTable dt = dal.GetList(" and isnull(hidden,0)!=1 and isnull(category,'')='" + module_code + "' ");

            html += "<div class='product" + div_class + "'>\n<table>";
            
            foreach (DataRow dr in dt.Rows)
            {
                string cf_code = dr["cf_code"].ToString();
                string cf_name = dr["cf_name"].ToString();
                string cf_value = dr["cf_value"].ToString();
                string cf_type = dr["cf_type"].ToString();
                string value_list = dr["value_list"].ToString();
                string cf_intro = dr["cf_intro"].ToString();
                string input = "";
                if (cf_type.Equals("number"))
                {

                }
                if (cf_type.Equals("text") || cf_type.Equals("number"))
                {
                    input = "<input class='edit_text_box' type='text' id='" + cf_code + "' name='" + cf_code + "' value='" + cf_value + "'/>";
                }
                else if (cf_type.Equals("radio"))
                {
                    string[] arr = value_list.Split(';');
                    for (int i = 0; i < arr.Length; i++)
                    {
                        string[] arr2 = arr[i].Split(',');
                        string is_checked = "";
                        if (arr2[0].Equals(cf_value))
                        {
                            is_checked = "checked";
                        }
                        input += "<input type='radio' id='" + cf_code + "' name='" + cf_code + "' value='" + arr2[0] + "' " + is_checked + "/>" + arr2[1];
                    }
                }
                string str = "<tr><td class='caption'>" + cf_name + "</td><td class='config_option'>" + input + "</td><td class='intro'>" + cf_intro + "</td></tr>";
                html += str;
            }
            html += "</table></div>\n";
        }
        if (Request["action"] != null && Request["action"].Equals("Save"))
        {
            msg = "保存成功!";
            //string js = "alert('保存成功!');";
            //XTools.ExcuteJavaScript(js);
            //ClientScript.RegisterStartupScript(ClientScript.GetType(), "myscript", "<script>" + js + "</script>");
        }
    }
}