﻿<%@ WebService Language="C#" Class="Stock_Report_OnHand_Service" %>

using System;
using System.Web;
using System.Web.Services;
using System.Web.Services.Protocols;
using System.Transactions;
using System.Data;
using System.Data.SqlClient;
using SysCore;

[WebService(Namespace = "http://tempuri.org/")]
[WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1)]
// 若要允许使用 ASP.NET AJAX 从脚本中调用此 Web 服务，请取消注释以下行。 
[System.Web.Script.Services.ScriptService]
public class Stock_Report_OnHand_Service : System.Web.Services.WebService
{
    
    /// <summary>
    /// 月结
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string CloseMonth()
    {
        LoginInfo li = new LoginInfo();
        CloseMonthDAL dal = new CloseMonthDAL();
        CloseMonth cm = dal.GetCurrentMonth();
        int next_year = cm.cm_year;
        int next_month = cm.cm_month + 1;
        if (next_year == 0)
        {
            next_year = DateTime.Parse(li.login_date).Year;
            next_month = 1;
        }
        if (next_month == 13)
        {
            next_month = 1;
            next_year++;
        }
        string sql = @"
            insert System_CloseMonth(cm_year,cm_month)
            select @next_year,@next_month;";
        SqlParameter[] par ={
            new SqlParameter("@next_year", next_year),
            new SqlParameter("@next_month", next_month)
        };
        try
        {
            new SqlUtil().ExecuteNonQuery(sql, par);
        }
        catch (Exception err)
        {
            return err.Message;
        }
        return "success";
    }

    /// <summary>
    /// 取消月结
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string CloseMonth_UnDo()
    {
        LoginInfo li = new LoginInfo();
        CloseMonthDAL dal = new CloseMonthDAL();
        CloseMonth cm = dal.GetCurrentMonth();
        int cur_year = cm.cm_year;
        int cur_month = cm.cm_month;
        if (cur_year == 0)
        {
            return "未找到已结账月份进行取消!";
        }

        string sql = @"
            delete System_CloseMonth
            where cm_year=@cur_year and cm_month=@cur_month";
        SqlParameter[] par ={
            new SqlParameter("@cur_year", cur_year),
            new SqlParameter("@cur_month", cur_month)
        };
        try
        {
            new SqlUtil().ExecuteNonQuery(sql, par);
        }
        catch (Exception err)
        {
            return err.Message;
        }
        return "success";
    }
    
}