﻿<%@ WebService Language="C#" Class="Transfer_Service" %>

using System;
using System.Web;
using System.Web.Services;
using System.Web.Services.Protocols;
using System.Collections;
using System.Transactions;
using System.Data;
using System.Data.SqlClient;
using SysCore;
using SysCore.DAL;

[WebService(Namespace = "http://tempuri.org/")]
[WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1)]
// 若要允许使用 ASP.NET AJAX 从脚本中调用此 Web 服务，请取消注释以下行。 
[System.Web.Script.Services.ScriptService]
public class Transfer_Service  : System.Web.Services.WebService {

    /// <summary>
    /// 保存单据
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string Save(string action, string ts_id, string order_number,
        string new_date, string remark,
        string wh_id_out, string wh_name_out, string wh_id_in, string wh_name_in,
        string iot_id_out, string iot_name_out, string iot_id_in, string iot_name_in,
        string dep_id_out, string dep_name_out, string dep_id_in, string dep_name_in,
        string sdefine1, string sdefine2, string sdefine3, string sdefine4, string sdefine5,
        string ndefine1, string ndefine2, string ndefine3, string ndefine4, string ndefine5)
    {
        if (dep_id_out.Equals("0") || dep_name_out.Equals(""))
        {
            dep_id_out = "";
        }
        if (dep_id_in.Equals("0") || dep_name_in.Equals(""))
        {
            dep_id_in = "";
        }
        if (iot_id_out.Equals("0") || iot_name_out.Equals(""))
        {
            iot_id_out = "";
        }
        if (iot_id_in.Equals("0") || iot_name_in.Equals(""))
        {
            iot_id_in = "";
        }
        if (string.IsNullOrWhiteSpace(new_date))
        {
            return "制单日期不可为空!";
        }
        if (wh_id_out.Equals("0") || wh_name_out.Equals(""))
        {
            return "转出仓库不可为空!";
        }
        if (wh_id_in.Equals("0") || wh_name_in.Equals(""))
        {
            return "转入仓库不可为空!";
        }
        if (wh_id_in.Equals(wh_id_out))
        {
            return "转入仓不可以和转出库一样!";
        }
        if (!dep_id_in.Equals("") && dep_id_in.Equals(dep_id_out))
        {
            return "转入部门不可以和转出部门一样!";
        }
        //仓库进出时收发类型是否必须填写 1,必填;0,可选
        string stock_input_iotype = new ConfigReader().GetConfig("stock_input_iotype");
        if (stock_input_iotype.Equals("1"))
        {
            if (string.IsNullOrWhiteSpace(iot_id_in))
            {
                return "入库类型不可为空！";
            }
            if (string.IsNullOrWhiteSpace(iot_id_out))
            {
                return "出库类型不可为空！";
            }
        }
        try
        {
            if (new CloseMonthDAL().CheckIsCloseMonth(Convert.ToDateTime(new_date)))
            {
                return "操作月份已业务结账,不允许修改!";
            }
            TransferDAL dal = new TransferDAL();
            Transfer m = new Transfer();
            if (action.Equals("Update"))
            {
                m = dal.Get(Convert.ToInt32(ts_id));
                if (string.IsNullOrWhiteSpace(order_number))
                {
                    return "单据号不可为空！";
                }
                if (!m.order_number.Equals(order_number))
                {
                    if (dal.CheckExist(order_number))
                    {
                        return "您修改了单号，然而单号：" + order_number + "已存在，请尝试别的号码！";
                    }
                }
            }
            LoginInfo li = new LoginInfo();
            try
            {
                m.new_date = Convert.ToDateTime(new_date);
                m.order_number = order_number;
                m.wh_id_out = Convert.ToInt32(wh_id_out);
                m.wh_id_in = Convert.ToInt32(wh_id_in);
                m.iot_id_out = XTools.ObjectNullToInt(iot_id_out);
                m.iot_id_in = XTools.ObjectNullToInt(iot_id_in);
                m.dep_id_out = XTools.ObjectNullToInt(dep_id_out); 
                m.dep_id_in = XTools.ObjectNullToInt(dep_id_in);
                m.remark = remark.ToString();
                m.sdefine1 = sdefine1.ToString();
                m.sdefine2 = sdefine2.ToString();
                m.sdefine3 = sdefine3.ToString();
                m.sdefine4 = sdefine4.ToString();
                m.sdefine5 = sdefine5.ToString();
                m.ndefine1 = XTools.ObjectNullToDecimal(ndefine1);
                m.ndefine2 = XTools.ObjectNullToDecimal(ndefine2);
                m.ndefine3 = XTools.ObjectNullToDecimal(ndefine3);
                m.ndefine4 = XTools.ObjectNullToDecimal(ndefine4);
                m.ndefine5 = XTools.ObjectNullToDecimal(ndefine5);
            }
            catch (Exception err)
            {
                return err.Message;
            }
            if (action.Equals("Update"))
            {
                if (m.verify_uid != null)
                {
                    return "已审核不允许改单";
                }
                m.update_date = DateTime.Now;
                m.update_uid = li.uid;
                m.update_user = li.nickname;
                try{
                    //更新表头
                    dal.Update(m);
                    new UserLogDAL().AddUserLog("调拨单", "修改表头", m.ts_id, m.order_number);
                }
                catch (Exception err)
                {
                    return err.Message;
                }
            }
            else
            {
                //如果新增时单据号不为空说明是手工输入单号
                if (!order_number.Equals(""))
                {
                    if (dal.CheckExist(order_number))
                    {
                        return "单据号：" + order_number + "已存在！";
                    }
                }
                m.new_uid = li.uid;
                m.new_user = li.nickname;
                //启用事务
                using (TransactionScope scope = new TransactionScope())
                {
                    try
                    {
                        //新增表头
                        dal.Add(m);
                    }
                    catch (Exception err)
                    {
                        return err.Message;
                    }
                    //得到新增保存后的最大ID号
                    int MaxID = dal.GetMaxID();
                    ts_id = MaxID.ToString();
                    m = dal.Get(MaxID);
                    //如果流水号为空代表是系统自动流水
                    if (order_number.Equals(""))
                    {
                        //更新实体
                        try
                        {
                            //根据规则生成流水号
                            Hashtable ht_num = new Hashtable();
                            /*
                            if (m.io_type != null)
                            {
                                ht_num.Add("[iot_code]", m.io_type.iot_code);
                            }*/
                            string running_number = new RunningNumberRuleDAL().GetModuleRunningNumber("Stock_Transfer", ht_num);
                            m.order_number = running_number;
                            //return m.ts_id.ToString();
                            dal.Update(m);
                        }
                        catch
                        {
                            return "自动生成流水号出错,请检查必填项目!";
                        }
                    }
                    new UserLogDAL().AddUserLog("调拨单", "新增单据", m.ts_id, m.order_number);
                    //提交事务
                    scope.Complete();
                }
            }
        }
        catch (Exception err)
        {
            return err.Message;
        }
        return "success|" + ts_id;
    }
    /// <summary>
    /// 删单
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string Delete(string ids)
    {
        string prev_id = "";
        foreach (string fid in ids.Split(','))
        {
            int id = Convert.ToInt32(fid);
            TransferDAL dal = new TransferDAL();
            Transfer io = dal.Get(id);
            if (io.verify_uid != null)
            {
                return "单据:" + io.order_number + "已审核不允许删单!";
            }
            if (new CloseMonthDAL().CheckIsCloseMonth(Convert.ToDateTime(io.new_date)))
            {
                return "操作月份已业务结账,不允许修改!";
            }
            TransfersDAL sdal = new TransfersDAL();
            prev_id = GetPrevNextID(id, "1");//得到上一张单据ID
            string msg = "";
            //启用事务
            using (TransactionScope scope = new TransactionScope())
            {
                new UserLogDAL().AddUserLog("调拨单", "删除单据", io.ts_id, io.order_number);
                msg = dal.Delete(id);
                if (!msg.Equals("success"))
                {
                    return msg;
                }
                //提交事务
                scope.Complete();
            }
        }
        return "success|" + prev_id;
    }
    /// <summary>
    /// 检查
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string Check(int id)
    {
        TransferDAL dal = new TransferDAL();
        Transfer m = dal.Get(id);
        
        //检查必填项
        string result = dal.CheckMustInput(id);
        if (!result.Equals("success"))
        {
            return result;
        }
        //检查是否超现存量
        result = dal.CheckOverStock(id);
        if (!result.Equals("success"))
        {
            return result;
        }
        return "success";
    }
    /// <summary>
    /// 审核或弃审
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string Verify(string ids, int action_type)
    {
        int id = Convert.ToInt32(ids);
        TransferDAL dal = new TransferDAL();
        Transfer m = dal.Get(id);
        LoginInfo li = new LoginInfo();
        try
        {
            if (new CloseMonthDAL().CheckIsCloseMonth(Convert.ToDateTime(m.new_date)))
            {
                return "操作月份已业务结账,不允许修改!";
            }
            if (action_type == 1)
            {
                if (m.verify_uid != null)
                {
                    return "不允许重复审核";
                }
                if (new TransfersDAL().GetOneOrder_TotalNumbers(id) == 0)
                {
                    return "表体为空不允许审核!";
                }
                m.verify_uid = li.uid;
                m.verify_user = li.nickname;
                //审核前检查
                string result = Check(id);
                if (!result.Equals("success"))
                {
                    return result;
                }
            }
            else
            {
                if (m.verify_uid == null)
                {
                    return "不允许重复弃审";
                }
                m.verify_uid = null;
                m.verify_user = null;
            }
            }
        catch (Exception e)
        {
            return e.Message;
        }
        //启用事务
        using (TransactionScope scope = new TransactionScope())
        {
            try
            {
                if (action_type == 1)
                {
                    new UserLogDAL().AddUserLog("调拨单", "审核单据", m.ts_id, m.order_number);
                }
                else
                {
                    new UserLogDAL().AddUserLog("调拨单", "弃审单据", m.ts_id, m.order_number);
                }
                //更新实体
                dal.Update(m);
                if (action_type == 1)
                {
                    //生成其它出库单
                    CreateInOut(m, 0, -action_type);
                    //生成其它入库单
                    CreateInOut(m, 1, action_type);
                }
                else
                {
                    //删除出库单
                    DeleteInOut(m, action_type);
                }
                scope.Complete();
            }
            catch (Exception err)
            {
                return err.Message;
            }
        }
        return "success";

    }
    /// <summary>
    /// 删除出入库单
    /// </summary>
    /// <param name="ts">调拨单主表实体</param>
    /// <param name="io_flag">1代表入库,0代表出库</param>
    /// <returns></returns>
    string DeleteInOut(Transfer ts, int action_type)
    {
        InOutDAL io_dal = new InOutDAL();
        string sql = "select * from Stock_InOut where from_id=@from_id and from_type='调拨单'";
        SqlParameter []par={
            new SqlParameter("@from_id", ts.ts_id)
        };
        DataTable dt = new SqlUtil().GetDataTable(sql, par);
        foreach(DataRow dr in dt.Rows)
        {
                int io_id = Convert.ToInt32(dr["io_id"]);
                int io_flag = Convert.ToInt32(dr["io_flag"]);
                /// 单据类型
                int order_type = 1;//其它入库单
                int this_action_type = action_type;
                if (io_flag == 0)
                {
                    order_type = 2;//其它出库单
                    this_action_type = -action_type;
                }
                
                //更新现存量
                io_dal.UpdateOhHandByOrder(io_id, this_action_type);
                io_dal.Delete(io_id, order_type);
        }
        return "success";
    }
    /// <summary>
    /// 生成出入库单
    /// </summary>
    /// <param name="ts">调拨单主表实体</param>
    /// <param name="io_flag">1代表入库,0代表出库</param>
    /// <returns></returns>
    string CreateInOut(Transfer ts, int io_flag, int action_type)
    {
        InOut m = new InOut();
        m.io_flag = io_flag;
        m.new_date = ts.new_date;
        if (io_flag == 1)
        {
            m.order_type = 1;//其它入库单
            m.bus_type = "调拨入库";
            m.order_number = ts.order_number + "_RK";
            m.wh_id = ts.wh_id_in;
            m.dep_id = ts.dep_id_in;
            m.iot_id = ts.iot_id_in;
        }
        else
        {
            m.order_type = 2;//其它出库单
            m.bus_type = "调拨出库";
            m.order_number = ts.order_number + "_CK";
            m.wh_id = ts.wh_id_out;
            m.dep_id = ts.dep_id_out;
            m.iot_id = ts.iot_id_out;
        }
        m.new_uid = ts.new_uid;
        m.new_user = ts.new_user;
        m.verify_uid = ts.verify_uid;
        m.verify_user = ts.verify_user;
        m.remark = ts.remark;
        m.from_id = ts.ts_id;//来源单据ID
        m.from_type = "调拨单";//单据来源
        m.sdefine1 = ts.sdefine1;
        m.sdefine2 = ts.sdefine2;
        m.sdefine3 = ts.sdefine3;
        m.sdefine4 = ts.sdefine4;
        m.sdefine5 = ts.sdefine5;
        m.ndefine1 = ts.ndefine1;
        m.ndefine2 = ts.ndefine2;
        m.ndefine3 = ts.ndefine3;
        m.ndefine4 = ts.ndefine4;
        m.ndefine5 = ts.ndefine5;
        InOutDAL io_dal = new InOutDAL();
        InOutsDAL ios_dal = new InOutsDAL();
        io_dal.Add(m);
        int io_id = io_dal.GetMaxID();
        TransfersDAL tss_dal = new TransfersDAL();
        DataTable dt = tss_dal.GetDetails(ts.ts_id);
        foreach(DataRow dr in dt.Rows)
        {
            int tss_id = Convert.ToInt32(dr["tss_id"]);
            Transfers tss = tss_dal.Get(tss_id);
            InOuts os = new InOuts();
            os.io_id = io_id;
            os.d_wh_id = m.wh_id;
            os.d_dep_id = m.dep_id;
            os.i_id = tss.i_id;
            os.free1 = tss.free1;
            os.free2 = tss.free2;
            os.batch = tss.batch;
            os.quantity = tss.quantity;
            os.num = tss.num;
            os.convert_rate = tss.convert_rate;
            os.unit_price = tss.unit_price;
            os.total_price = tss.total_price;
            os.d_sdefine1 = tss.d_sdefine1;
            os.d_sdefine2 = tss.d_sdefine2;
            os.d_sdefine3 = tss.d_sdefine3;
            os.d_sdefine4 = tss.d_sdefine4;
            os.d_sdefine5 = tss.d_sdefine5;
            os.d_ndefine1 = tss.d_ndefine1;
            os.d_ndefine2 = tss.d_ndefine2;
            os.d_ndefine3 = tss.d_ndefine3;
            os.d_ndefine4 = tss.d_ndefine4;
            os.d_ndefine5 = tss.d_ndefine5;
            os.tss_id = tss.tss_id;//存储子表ID
            ios_dal.Add(os);
        }
        //更新现存量
        io_dal.UpdateOhHandByOrder(io_id, action_type);
        return "success";
    }

    /// <summary>
    /// 上张或下张
    /// </summary>
    /// <param name="id">主表id</param>
    /// <param name="type">操作类型</param>
    /// <returns></returns>
    [WebMethod(EnableSession = true)]
    public string GetPrevNextID(int id, string type)
    {
        TransferDAL dal = new TransferDAL();
        return dal.GetPrevNextID(id, type).ToString();
    }
    /// <summary>
    /// 批量设置表体仓库
    /// </summary>
    /// <param name="id">主表id</param>
    /// <param name="wh_id">仓库id</param>
    /// <returns></returns>
    [WebMethod(EnableSession = true)]
    public string BatchSetWarehouse(int id, int wh_id)
    {
        TransferDAL dal = new TransferDAL();
        if (dal.Get(id).verify_uid != null)
        {
            return "已审核不允许改单";
        }
        try
        {
            dal.BatchSetWarehouse(id, wh_id);
        }
        catch (Exception err)
        {
            return err.Message;
        }
        return "success";
    }
    /// <summary>
    /// 批量设置表体部门
    /// </summary>
    /// <param name="id">主表id</param>
    /// <param name="dep_id">部门id</param>
    /// <returns></returns>
    [WebMethod(EnableSession = true)]
    public string BatchSetDepartment(int id, int dep_id)
    {
        TransferDAL dal = new TransferDAL();
        if (dal.Get(id).verify_uid != null)
        {
            return "已审核不允许改单";
        }
        try
        {
            dal.BatchSetDepartment(id, dep_id);
        }
        catch (Exception err)
        {
            return err.Message;
        }
        return "success";
    }
    
}