﻿//查询转出仓库
function FastSearch_Warehouse_Out() {
    $("#wh_name_out").fast_search({
        url: '../../Component/FastSearch/FastSearch_Warehouse.aspx',
        replaceNull: true,
        searchButton: true,
        colModel: [{ 'columnName': 'wh_id', 'hidden': true, 'width': '80', 'label': 'id' },
                    { 'columnName': 'wh_code', 'width': '80', 'label': '仓库编码' },
                    { 'columnName': 'wh_name', 'width': '100', 'label': '仓库名称'}],
        select: function (event, ui) {
            SearchService_Warehouse_Out(ui.item.wh_id);
            return false;
        }
    });
}
//查询转入仓库
function FastSearch_Warehouse_In() {
    $("#wh_name_in").fast_search({
        url: '../../Component/FastSearch/FastSearch_Warehouse.aspx',
        replaceNull: true,
        searchButton: true,
        colModel: [{ 'columnName': 'wh_id', 'hidden': true, 'width': '80', 'label': 'id' },
                    { 'columnName': 'wh_code', 'width': '80', 'label': '仓库编码' },
                    { 'columnName': 'wh_name', 'width': '100', 'label': '仓库名称'}],
        select: function (event, ui) {
            SearchService_Warehouse_In(ui.item.wh_id);
            return false;
        }
    });
}
//通过主键_获取转出仓库
function SearchService_Warehouse_Out(wh_id) {
    $.ajax({
        type: "POST",
        contentType: "application/json",
        url: '../../Base/Warehouse/Warehouse_Service.asmx/Get',
        data: "{wh_id:'" + wh_id + "'}",
        dataType: 'json',
        success: function (result) {
            $("#wh_id_out").val(result.d.wh_id);
            $("#wh_name_out").val(result.d.wh_name);
        }
    });
}

//通过主键_获取转入仓库
function SearchService_Warehouse_In(wh_id) {
    $.ajax({
        type: "POST",
        contentType: "application/json",
        url: '../../Base/Warehouse/Warehouse_Service.asmx/Get',
        data: "{wh_id:'" + wh_id + "'}",
        dataType: 'json',
        success: function (result) {
            $("#wh_id_in").val(result.d.wh_id);
            $("#wh_name_in").val(result.d.wh_name);
        }
    });
}


//查询转出部门
function FastSearch_Department_Out() {
    $("#dep_name_out").fast_search({
        url: '../../Component/FastSearch/FastSearch_Department.aspx',
        replaceNull: true,
        searchButton: true,
        colModel: [{ 'columnName': 'dep_id', 'hidden': true, 'width': '80', 'label': 'id' },
            { 'columnName': 'dep_code', 'width': '80', 'label': '部门编码' },
            { 'columnName': 'dep_name', 'width': '100', 'label': '部门名称'}],
        select: function (event, ui) {
            SearchService_Department_Out(ui.item.dep_id);
            return false;
        }
    });
}
//通过主键_获取转出部门
function SearchService_Department_Out(dep_id) {
    $.ajax({
        type: "POST",
        contentType: "application/json",
        url: '../../Base/Department/Department_Service.asmx/Get',
        data: "{dep_id:'" + dep_id + "'}",
        dataType: 'json',
        success: function (result) {
            $("#dep_id_out").val(result.d.dep_id);
            $("#dep_name_out").val(result.d.dep_name);
        }
    });
}

//查询转入部门
function FastSearch_Department_In() {
    $("#dep_name_in").fast_search({
        url: '../../Component/FastSearch/FastSearch_Department.aspx',
        replaceNull: true,
        searchButton: true,
        colModel: [{ 'columnName': 'dep_id', 'hidden': true, 'width': '80', 'label': 'id' },
            { 'columnName': 'dep_code', 'width': '80', 'label': '部门编码' },
            { 'columnName': 'dep_name', 'width': '100', 'label': '部门名称'}],
        select: function (event, ui) {
            SearchService_Department_In(ui.item.dep_id);
            return false;
        }
    });
}
//通过主键_获取转入部门
function SearchService_Department_In(dep_id) {
    $.ajax({
        type: "POST",
        contentType: "application/json",
        url: '../../Base/Department/Department_Service.asmx/Get',
        data: "{dep_id:'" + dep_id + "'}",
        dataType: 'json',
        success: function (result) {
            $("#dep_id_in").val(result.d.dep_id);
            $("#dep_name_in").val(result.d.dep_name);
        }
    });
}

//通过主键_获取出库类型
function SearchService_IOType_Out(iot_id) {
    $.ajax({
        type: "POST",
        contentType: "application/json",
        url: '../../Base/IOType/IOType_Service.asmx/Get',
        data: "{iot_id:'" + iot_id + "'}",
        dataType: 'json',
        success: function (result) {
            $("#iot_id_out").val(result.d.iot_id);
            $("#iot_name_out").val(result.d.iot_name);
        }
    });
}

//查询出库类型
function FastSearch_IOType_Out() {
    $("#iot_name_out").fast_search({
        url: '../../Component/FastSearch/FastSearch_IOType.aspx?iot_flag=0',
        replaceNull: true,
        searchButton: true,
        colModel: [{ 'columnName': 'iot_id', 'hidden': true, 'width': '80', 'label': 'id' },
            { 'columnName': 'iot_code', 'width': '80', 'label': '编码' },
            { 'columnName': 'iot_name', 'width': '100', 'label': '名称'}],
        select: function (event, ui) {
            SearchService_IOType_Out(ui.item.iot_id);
            return false;
        }
    });
}


//通过主键_获取入库类型
function SearchService_IOType_In(iot_id) {
    $.ajax({
        type: "POST",
        contentType: "application/json",
        url: '../../Base/IOType/IOType_Service.asmx/Get',
        data: "{iot_id:'" + iot_id + "'}",
        dataType: 'json',
        success: function (result) {
            $("#iot_id_in").val(result.d.iot_id);
            $("#iot_name_in").val(result.d.iot_name);
        }
    });
}

//查询入库类型
function FastSearch_IOType_In() {
    $("#iot_name_in").fast_search({
        url: '../../Component/FastSearch/FastSearch_IOType.aspx?iot_flag=1',
        replaceNull: true,
        searchButton: true,
        colModel: [{ 'columnName': 'iot_id', 'hidden': true, 'width': '80', 'label': 'id' },
            { 'columnName': 'iot_code', 'width': '80', 'label': '编码' },
            { 'columnName': 'iot_name', 'width': '100', 'label': '名称'}],
        select: function (event, ui) {
            SearchService_IOType_In(ui.item.iot_id);
            return false;
        }
    });
}


