﻿<%@ WebService Language="C#" Class="StockCounsc_Service" %>

using System;
using System.Web;
using System.Web.Services;
using System.Web.Services.Protocols;
using System.Transactions;
using System.Data;
using SysCore;

[WebService(Namespace = "http://tempuri.org/")]
[WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1)]
// 若要允许使用 ASP.NET AJAX 从脚本中调用此 Web 服务，请取消注释以下行。 
[System.Web.Script.Services.ScriptService]
public class StockCounsc_Service  : System.Web.Services.WebService {
    /// <summary>
    /// 删除
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string Delete(string ids)
    {
        StockCountsDAL dal = new StockCountsDAL();
        StockCountDAL t_dal = new StockCountDAL();
        StockCount t = new StockCount();
        OnHandDAL oh_dal = new OnHandDAL();
        bool bfirst = true;
        int sc_id;
        foreach (string id in ids.Split(','))
        {
            if (bfirst)
            {
                sc_id = dal.Get(Convert.ToInt32(id)).sc_id;
                t = t_dal.Get(sc_id);
                if (t.verify_uid != null)
                {
                    return "已审核不允许删行";
                }
                if (new CloseMonthDAL().CheckIsCloseMonth(Convert.ToDateTime(t.new_date)))
                {
                    return "操作月份已业务结账,不允许修改!";
                }
                bfirst = false;
            }
            try
            {
                StockCounts m = dal.Get(Convert.ToInt32(id));
                dal.Delete(Convert.ToInt32(id));
            }
            catch (Exception e)
            {
                return e.Message;
            }
        }
        return "success";
    }

    /// <summary>
    /// 修改
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string Save(string action, string sc_id, string scs_id,
        string i_id, string free1, string free2, string batch, string i_code, string i_name,
        string standard,string munit,string aunit,
        string quantity_zm, string num_zm, string quantity, string num,
        string convert_rate,string d_remark, 
        string d_sdefine1, string d_sdefine2, string d_sdefine3, string d_sdefine4, string d_sdefine5,
        string d_ndefine1, string d_ndefine2, string d_ndefine3, string d_ndefine4, string d_ndefine5)
    {

        if (string.IsNullOrWhiteSpace(i_id) || i_id.Equals("0"))
        {
            return "请输入存货！";
        }
        if (string.IsNullOrWhiteSpace(quantity))
        {
            quantity = "0";
        }
        StockCountsDAL dal = new StockCountsDAL();
        StockCounts m = new StockCounts();
        StockCounts m_old = new StockCounts();
        StockCount sc = new StockCountDAL().Get(Convert.ToInt32(sc_id));
        OnHandDAL oh_dal = new OnHandDAL();
        try
        {
            if (sc.verify_uid != null)
            {
                return "已审核不允许改单";
            }
            if (new CloseMonthDAL().CheckIsCloseMonth(Convert.ToDateTime(sc.new_date)))
            {
                return "操作月份已业务结账,不允许修改!";
            }
            if (action.Equals("Update"))
            {
                m = dal.Get(Convert.ToInt32(scs_id));
                m_old = dal.Get(Convert.ToInt32(scs_id));
            }
            try
            {
                m.sc_id = Convert.ToInt32(sc_id);
                m.i_id = Convert.ToInt32(i_id);
                free1 = free1.Trim();
                free2 = free2.Trim();
                batch = batch.Trim();
                Inventory inv = new InventoryDAL().Get(Convert.ToInt32(i_id));
                if (!free1.Equals("") && inv.on_free1 == 0)
                    return "存货不允许输入自由项1！";
                if (!free2.Equals("") && inv.on_free2 == 0)
                    return "存货不允许输入自由项2！";
                if (free1.Equals("") && inv.on_free1 == 1)
                    return "存货必须输入自由项1！";
                if (free2.Equals("") && inv.on_free2 == 1)
                    return "存货必须输入自由项2！";
                m.free1 = free1;
                m.free2 = free2;
                if (!batch.Equals("") && inv.on_batch == 0)
                    return "存货不允许输入批次！";
                if (batch.Equals("") && inv.on_batch == 1)
                    return "存货必须输入批次！";
                if (inv.aunit.Equals("") && !num.Equals(""))
                    return "未启用辅计量单位，启不要输入件数！";
                if (!inv.aunit.Equals(""))
                {
                    if (num.Equals(""))
                    {
                        return "存货启用了辅计量单位，必须输入件数！";
                    }
                    if (convert_rate.Equals("") || convert_rate.Equals("0"))
                    {
                        return "存货启用了辅计量单位，必须输入换算率！";
                    }
                }
                m.batch = batch;
                //m.unit_price = XTools.ObjectNullToDecimal(unit_price);
                //m.tax_unit_price = XTools.ObjectNullToDecimal(tax_unit_price);
                m.quantity = XTools.ObjectNullToDecimal(quantity);
                m.quantity_zm = XTools.ObjectNullToDecimal(quantity_zm);
                m.num = XTools.ObjectNullToDecimal(num);
                m.num_zm = XTools.ObjectNullToDecimal(num_zm);
                m.convert_rate = XTools.ObjectNullToDecimal(convert_rate);
                //m.total_price = XTools.ObjectNullToDecimal(total_price);
                //m.tax_total_price = XTools.ObjectNullToDecimal(tax_total_price);
                //m.tax = XTools.ObjectNullToDecimal(tax);
                //m.d_tax_rate = XTools.ObjectNullToDecimal(d_tax_rate);
                m.d_remark = XTools.ObjectNullToString(d_remark);
                //自定义项
                m.d_sdefine1 = d_sdefine1;
                m.d_sdefine2 = d_sdefine2;
                m.d_sdefine3 = d_sdefine3;
                m.d_sdefine4 = d_sdefine4;
                m.d_sdefine5 = d_sdefine5;
                m.d_ndefine1 = XTools.ObjectNullToDecimal(d_ndefine1);
                m.d_ndefine2 = XTools.ObjectNullToDecimal(d_ndefine2);
                m.d_ndefine3 = XTools.ObjectNullToDecimal(d_ndefine3);
                m.d_ndefine4 = XTools.ObjectNullToDecimal(d_ndefine4);
                m.d_ndefine5 = XTools.ObjectNullToDecimal(d_ndefine5);
            }
            catch (Exception err)
            {
                return err.Message;
            }
            //启用事务
            using (TransactionScope scope = new TransactionScope())
            {
                if (action.Equals("Update"))
                {
                    //更新明细
                    dal.Update(m);
                }
                else
                {
                    //新增明细
                    dal.Add(m);
                }
                //提交事务
                scope.Complete();
            }
        }
        catch (Exception e)
        {
            return e.Message;
        }
        return "success";
    }


    /// <summary>
    /// 获取存货账面数
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string GetZhangMian(int sc_id, int i_id)
    {
         
        StockCountDAL dal = new StockCountDAL();
        StockCount m = dal.Get(sc_id);
        int wh_id = m.wh_id;
        DateTime? pd_date = m.new_date;
        DataTable dt = new DataTable();
        try
        {
            dt = new StockCountsDAL().GetZhangMian(wh_id, i_id, m.new_date);
            string quantity_zm = dt.Rows[0]["quantity_zm"].ToString();
            string num_zm = dt.Rows[0]["num_zm"].ToString();
            return quantity_zm + "||" + num_zm;
        }
        catch(Exception err)
        {
            return "出错:" + err.Message;
        }
        
    }
    
 
}