﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using SysCore;
using SysCore.Model;
using SysCore.DAL;
using SysCore.Control;

public partial class Stock_StockCount_StockCount_Document : System.Web.UI.Page
{
    public Hashtable xview = new Hashtable();
    public AuthUI auth = new AuthUI();
    AWGridFun aw = new AWGridFun();
    public StockCount m;
    public int id;
    public string action;
    public Currency currency;
    public IOType io_type_in, io_type_out;
    protected void Page_Load(object sender, EventArgs e)
    {
        new LoginState().CheckLogin();
        //模块权限编号,同时作为模块号
        string auth_code = "Stock_StockCount";
        //检查模块查看权限
        auth.AuthCheckAndResponse(auth_code);
        xview.Add("auth_code", auth_code);
        //创建grid控件的iframe
        xview.Add("grid_frame", aw.CreateGridFrameForDoc(""));
        StockCountDAL dal = new StockCountDAL();
        if(Request["action"] != null)
        {
            action = Request.QueryString["action"];
        }else{
            action = "Add";
        }
        if (action.Equals("Add"))
        {
            //默认收发类型
            io_type_in = new IOTypeDAL().GetByName("盘盈入库");
            io_type_out = new IOTypeDAL().GetByName("盘亏出库");
        }
        if (Request["id"] != null)
        {
            id = Convert.ToInt32(Request["id"]);
            m = dal.Get(id);
            //把sql放入session中供打印用
            string sql_print_main_session_id = "sql_print_main_StockCount";
            Session[sql_print_main_session_id] = dal.sql_print;
            xview.Add("sql_print_main_session_id", sql_print_main_session_id);

            xview.Add("order_total_numbers", new StockCountsDAL().GetOneOrder_TotalNumbers(id));
        }
        ModuleFormatDesigner mfd = new ModuleFormatDesigner();
        InputUI ui = new InputUI();
        string sql_select_field = "";//SQL所需选择列
        string module = "Stock_StockCount_Header";//打印格式模块编号
        xview.Add("module", module);
        mfd.CreateInput(module, ref ui, ref sql_select_field, m);
        xview.Add("input_ui", ui.CreateUI());
        Hashtable ht_js = mfd.MakeJavaScript_GetInput(module);
        xview.Add("Script_GetInput", ht_js["Script_GetInput"].ToString());
        xview.Add("Script_SaveJSON", ht_js["Script_SaveJSON"].ToString());
        LoginInfo li = new LoginInfo();
        xview.Add("login_date", li.login_date);
        ReadModuleScript();//读取模块脚本
    }
    /// <summary>
    /// 读取模块脚本
    /// </summary>
    void ReadModuleScript()
    {
        ModuleScriptDAL dal = new ModuleScriptDAL();
        xview.Add("StockCount_Main_JavaScript", dal.GetByCode("StockCount_Main_JavaScript").script);
    }
}