﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Data.SqlClient;
using SysCore;
using SysCore.Model;
using SysCore.DAL;
using SysCore.Control;
public partial class Stock_Report_OrderTypeSummary_Grid : System.Web.UI.Page
{
    public Hashtable xview = new Hashtable();
    AWGridFun aw = new AWGridFun();
    protected void Page_Load(object sender, EventArgs e)
    {
        if(!Page.IsPostBack)
        {
            CreateGrid();
        }
    }
    /// <summary>
    /// 绑定控件数据源
    /// </summary>
    public void CreateGrid()
    {
        //设置标题与样式
        ModuleFormatDesigner mfd = new ModuleFormatDesigner();
        string sql_select_field = "";//SQL所需选择列
        string module = "Stock_Report_OrderTypeSummary";//模块
        string fields_index = "";//列索引
        mfd.CreateTitlesAndStyles(module, ref aw, ref sql_select_field, ref fields_index);
        xview.Add("fields_index", fields_index);
        //把样式传递到页面
        xview.Add("aw_column_style",aw.GetStyles());
        int page = 1;//当前页
        if (Request.QueryString["page"] != null)
            page = Convert.ToInt32(Request.QueryString["page"]);
        int page_size = aw.GetDefaultPageSize();//每页显示条数
        if (Request.QueryString["page_size"] != null)
            page_size = Convert.ToInt32(Request.QueryString["page_size"]);
        
        Hashtable ht = new Hashtable();
        //排序
        string order_field = "order by wh_code,i_code asc";
        ht.Add("order_field", order_field);
        ht.Add("page", page);
        ht.Add("page_size", page_size);
        //查询条件
        string sql_end = "";
        if (!Request["keyword"].Equals(""))
        {
            //要搜索关键字
            string keyword = Request["keyword"].ToString();
            //要搜索的字段
            string search_fields = @"wh_code,wh_name,ic_name,
                                i_code,i_name,free1,free2,batch,standard,munit,aunit,
                                sdefine1,sdefine2,sdefine3,sdefine4,sdefine5";
            sql_end = FastSearh.MakeSearchSqlForWhere(keyword, search_fields);
        }

        if (!Request["begin_date"].Equals(""))
        {
            sql_list = sql_list.Replace("@begin_date", "'" + Request["begin_date"] + "'");
        }
        if (!Request["end_date"].Equals(""))
        {
            sql_list = sql_list.Replace("@end_date", "'" + Request["end_date"] + "'");
        }


        //查仓库
        if (!Request["wh_id"].Equals(""))
        {
            sql_end += " and wh_id=" + Request["wh_id"];
        }
        if (!Request["ic_code"].Equals(""))
        {
            sql_end += " and ic_code like '" + Request["ic_code"] + "'";
        }
        if (!Request["i_code"].Equals(""))
        {
            sql_end += " and i_code like '" + Request["i_code"] + "'";
        }
        if (!Request["i_name"].Equals(""))
        {
            sql_end += " and i_name like '%" + Request["i_name"] + "%'";
        }
        if (!Request["standard"].Equals(""))
        {
            sql_end += " and standard like '%" + Request["standard"] + "%'";
        }
        if (!Request["free1"].Equals(""))
        {
            sql_end += " and free1 like '%" + Request["free1"] + "%'";
        }
        if (!Request["free2"].Equals(""))
        {
            sql_end += " and free2 like '%" + Request["free2"] + "%'";
        }
        if (!Request["batch"].Equals(""))
        {
            sql_end += " and batch like '%" + Request["batch"] + "%'";
        }
        //当前用户是否管理员
        bool is_admin = new AuthUI().CheckLoginUserIsAdmin();
        if (!is_admin)
        {
            //值为1代表启用仓库权限控制
            string system_wh_auth = new ConfigReader().GetConfig("system_wh_auth");
            if (system_wh_auth.Equals("1"))
            {
                sql_end += " and wh_id in (" + new AuthEx().GetSqlForMyWarehouse() + ")";
            }
        }
        ht.Add("sql_end", sql_end);
        //查询后返回DataTable
        DataTable dt = GetList(ht, sql_select_field);
        //把sql放入session中供打印用
        string sql_print_detail_session_id = "sql_print_detail_" + module;
        Session[sql_print_detail_session_id] = sql_print;
        xview.Add("sql_print_detail_session_id", sql_print_detail_session_id);
        //供导出Excel用
        string field_for_export = mfd.field_for_export;
        Session[sql_print_detail_session_id + "_export_field"] = field_for_export;
        //得到总记录数为分页提供依据
        int rows_count = GetList_TotalNumbers(ht);
        //开启合计行功能
        aw.to_sum_row = true;
        //从模板读出哪些列需要合计
        aw.last_row_info = mfd.last_row_info;
        string aw_grid_info = aw.MakeGridObject(dt, rows_count, page_size, page);
        //把控件参数与数据源传递到页面
        xview.Add("aw_grid_info", aw_grid_info);
    }
    //打印用的sql
    public string sql_print = "";
    /*
        declare @begin_date datetime,@end_date datetime
        set @begin_date='2014-05-11'
        set @end_date='2014-07-31'
    */
    //列表查询用的sql
    string sql_list = @"
        select top 1000000000 wh.wh_id,wh.wh_code,wh.wh_name,
        ic.ic_id,ic.ic_code,ic.ic_name,t.i_id,i.i_code,i.i_name,
        i.standard,i.munit,i.aunit,
        t.free1,t.free2,t.batch,
        sum(t.采购入库数量) as cg_rk_sl,sum(t.其它入库数量) as qt_rk_sl,
        sum(t.成品入库数量) as cp_rk_sl,
        sum(t.材料出库数量) as cl_ck_sl,sum(t.其它出库数量) as qt_ck_sl,
        sum(t.销售出库数量) as xs_ck_sl,
        sum(t.期初数量) as qc_sl,
        sum(t.本期入库数量) as bq_rk_sl,sum(t.本期出库数量) as bq_ck_sl,
        isnull(sum(t.期初数量),0)+isnull(sum(t.本期入库数量),0)-isnull(sum(t.本期出库数量),0) as bq_jc_sl,
        sum(t.采购入库件数) as cg_rk_num,sum(t.其它入库件数) as qt_rk_num,
        sum(t.成品入库件数) as cp_rk_num,
        sum(t.材料出库件数) as cl_ck_num,sum(t.其它出库件数) as qt_ck_num,
        sum(t.销售出库件数) as xs_ck_num,
        sum(t.期初件数) as qc_num,
        sum(t.本期入库件数) as bq_rk_num,sum(t.本期出库件数) as bq_ck_num,
        isnull(sum(t.期初件数),0)+isnull(sum(t.本期入库件数),0)-isnull(sum(t.本期出库件数),0) as bq_jc_num,
        i.sdefine1,i.sdefine2,i.sdefine3,i.sdefine4,i.sdefine5,
        i.ndefine1,i.ndefine2,i.ndefine3,i.ndefine4,i.ndefine5
        from 
        (
	        select d.d_wh_id,d.i_id,isnull(d.free1,'') as free1,
	        isnull(d.free2,'') as free2,isnull(d.batch,'') as batch,
	        case when t.io_flag=1 then isnull(d.quantity,0) else isnull(-d.quantity,0) end as 期初数量,
	        0 as 采购入库数量,0 as 其它入库数量,0 as 成品入库数量,
	        0 as 材料出库数量,0 as 其它出库数量,0 as 销售出库数量,
	        0 as 本期入库数量,0 as 本期出库数量,
	        isnull(num,0) as 期初件数,
	        0 as 采购入库件数,0 as 其它入库件数,0 as 成品入库件数,
	        0 as 材料出库件数,0 as 其它出库件数,0 as 销售出库件数,
	        0 as 本期入库件数,0 as 本期出库件数
	        from Stock_InOuts d
	        left join Stock_InOut t on d.io_id=t.io_id
	        where isnull(t.verify_user,'')<>'' and t.new_date<@begin_date
	        union all
	        select d.d_wh_id,d.i_id,isnull(d.free1,'') as free1,
	        isnull(d.free2,'') as free2,isnull(d.batch,'') as batch,
	        0 as 期初数量,
	        case when t.order_type=3 then d.quantity end as 采购入库数量,
	        case when t.order_type=1 then d.quantity end as 其它入库数量,
	        case when t.order_type=5 then d.quantity end as 成品入库数量,
	        case when t.order_type=4 then d.quantity end as 材料出库数量,
	        case when t.order_type=2 then d.quantity end as 其它出库数量,
	        case when t.order_type=6 then d.quantity end as 销售出库数量,
	        case when t.io_flag=1 then d.quantity end as 本期入库数量,
	        case when t.io_flag=0 then d.quantity end as 本期出库数量,
	        0 as 期初件数,
	        case when t.order_type=3 then d.num end as 采购入库件数,
	        case when t.order_type=1 then d.num end as 其它入库件数,
	        case when t.order_type=5 then d.num end as 成品入库件数,
	        case when t.order_type=4 then d.num end as 材料出库件数,
	        case when t.order_type=2 then d.num end as 其它出库件数,
	        case when t.order_type=6 then d.num end as 销售出库件数,
	        case when t.io_flag=1 then d.num end as 本期入库件数,
	        case when t.io_flag=0 then d.num end as 本期出库件数

	        from Stock_InOuts d
	        left join Stock_InOut t on d.io_id=t.io_id
	        where isnull(t.verify_user,'')<>'' 
	        and t.new_date >= @begin_date and t.new_date <= @end_date
        )as t
        left join Base_Inventory i on t.i_id=i.i_id
        left join Base_InventoryClass ic on i.ic_id=ic.ic_id
        left join Base_Warehouse wh on t.d_wh_id=wh.wh_id
        group by wh.wh_id,wh.wh_code,wh.wh_name,ic.ic_id,ic.ic_code,ic.ic_name,
        t.i_id,i.i_code,i.i_name,t.free1,t.free2,t.batch,i.i_name,i.standard,
        i.munit,i.aunit,i.sdefine1,i.sdefine2,i.sdefine3,i.sdefine4,i.sdefine5,
        i.ndefine1,i.ndefine2,i.ndefine3,i.ndefine4,i.ndefine5
        ";
    /// <summary>
    /// 得到列表
    /// </summary>
    /// <param name="sql_select_field">格式定义指定显示列</param>
    /// <returns>DataTable</returns>
    public DataTable GetList(Hashtable pg, string sql_select_field)
    {
        string order_field = pg["order_field"].ToString();
        string sql = @"select ROW_NUMBER() OVER(@order_field) AS row_num,@sql_select_field 
                from(@sql_list)t where 1=1 ";
        sql = sql.Replace("@sql_list", sql_list)
                 .Replace("@order_field", order_field)
                 .Replace("@sql_select_field", sql_select_field);
        sql_print = "select top 1000000000 * from (" + sql_list + ") t where 1=1 " + pg["sql_end"] + " " + pg["order_field"].ToString();
        //分页处理与查询条件
        PageHelper ph = new PageHelper();
        sql = ph.GetPageSQL(sql, pg, true);//得到分页后的SQL
        DataTable dt = new SqlUtil().GetDataTable(sql, null);
        return dt;
    }
    /// <summary>
    /// 得到总记录数
    /// </summary>
    /// <returns>int</returns>
    public int GetList_TotalNumbers(Hashtable pg)
    {
        string sql = "select count(1) from (" + sql_list + ")t where 1=1 ";
        //分页处理与查询条件
        PageHelper ph = new PageHelper();
        sql = ph.GetPageSQL(sql, pg, false);//得到分页SQL
        int total_numbers = (int)new SqlUtil().ExecuteScalar(sql, null);
        return total_numbers;
    }
}
