﻿<%@ WebService Language="C#" Class="Stock_Report_OnHand_Service" %>

using System;
using System.Web;
using System.Web.Services;
using System.Web.Services.Protocols;
using System.Transactions;
using SysCore;

[WebService(Namespace = "http://tempuri.org/")]
[WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1)]
// 若要允许使用 ASP.NET AJAX 从脚本中调用此 Web 服务，请取消注释以下行。 
[System.Web.Script.Services.ScriptService]
public class Stock_Report_OnHand_Service : System.Web.Services.WebService
{
    
    /// <summary>
    /// 整理现存量
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string FixStock()
    {
        string sql = @"
        delete Stock_OnHand;
        insert into Stock_OnHand(wh_id,i_id,free1,free2,batch,quantity,num)
        select wh_id,i_id,
        isnull(free1,'') as free1,isnull(free2,'') as free2,isnull(batch,'') as batch,
        sum(quantity) as quantity,sum(num) as num
        from
        (
	        select d.d_wh_id as wh_id,d.i_id,d.free1,d.free2,d.batch,
	        case when io_flag=1 then d.quantity else -d.quantity end as quantity,
            case when io_flag=1 then d.num else -d.num end as num
	        from Stock_InOuts d
	        left join Stock_InOut t on t.io_id=d.io_id
            where isnull(t.verify_uid,0)!=0
        )t group by wh_id,i_id,
        isnull(free1,''),isnull(free2,''),isnull(batch,'');
        update Stock_OnHand set free1=null where free1='';
        update Stock_OnHand set free2=null where free2='';
        update Stock_OnHand set batch=null where batch='';";
        try
        {
            new SqlUtil().ExecuteNonQuery(sql, null);
        }
        catch (Exception err)
        {
            return err.Message;
        }
        return "success";
    }

}