﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Data.SqlClient;
using SysCore;
using SysCore.Model;
using SysCore.DAL;
using SysCore.Control;
public partial class Stock_Report_InOut_Details_Grid : System.Web.UI.Page
{
    public Hashtable xview = new Hashtable();
    AWGridFun aw = new AWGridFun();
    protected void Page_Load(object sender, EventArgs e)
    {
        if(!Page.IsPostBack)
        {
            CreateGrid();
        }
    }
    /// <summary>
    /// 绑定控件数据源
    /// </summary>
    public void CreateGrid()
    {
        //设置标题与样式
        ModuleFormatDesigner mfd = new ModuleFormatDesigner();
        string sql_select_field = "";//SQL所需选择列
        string module = "Stock_Report_InOut_Details";//模块
        string fields_index = "";//列索引
        mfd.CreateTitlesAndStyles(module, ref aw, ref sql_select_field, ref fields_index);
        xview.Add("fields_index", fields_index);
        //把样式传递到页面
        xview.Add("aw_column_style",aw.GetStyles());
        int page = 1;//当前页
        if (Request.QueryString["page"] != null)
            page = Convert.ToInt32(Request.QueryString["page"]);
        int page_size = aw.GetDefaultPageSize();//每页显示条数
        if (Request.QueryString["page_size"] != null)
            page_size = Convert.ToInt32(Request.QueryString["page_size"]);
        
        Hashtable ht = new Hashtable();
        //排序
        string order_field = "order by new_date desc,io_id desc,ios_id asc";
        ht.Add("order_field", order_field);
        ht.Add("page", page);
        ht.Add("page_size", page_size);
        //查询条件
        string sql_end = "";
        if (!Request["keyword"].Equals(""))
        {
            //要搜索关键字
            string keyword = Request["keyword"].ToString();
            //要搜索的字段
            string search_fields = @"order_number,ot_name,wh_code,wh_name,dep_name,ic_name,
                                i_code,i_name,free1,free2,batch,from_type,bus_type,
                                standard,munit,aunit,dep_name,iot_name,new_user,verify_user,
                                d_sdefine1,d_sdefine2,d_sdefine3,d_sdefine4,d_sdefine5,
                                sdefine1,sdefine2,sdefine3,sdefine4,sdefine5,
                                d_inv_sdefine1,d_inv_sdefine2,d_inv_sdefine3,d_inv_sdefine4,d_inv_sdefine5";
            sql_end = FastSearh.MakeSearchSqlForWhere(keyword, search_fields);
        }
        if (!Request["sc_id"].Equals(""))
        {
            sql_end += " and from_type='盘点单' and from_id='" + Request["sc_id"] + "'";
        }
        if (!Request["ts_id"].Equals(""))
        {
            sql_end += " and from_type='调拨单' and from_id='" + Request["ts_id"] + "'";
        }
        if (!Request["begin_date"].Equals(""))
        {
            sql_end += " and new_date>='" + Request["begin_date"] + "'";
        }
        if (!Request["end_date"].Equals(""))
        {
            sql_end += " and new_date<='" + Request["end_date"] + "'";
        }
        if (!Request["order_number"].Equals(""))
        {
            sql_end += " and order_number like '%" + Request["order_number"] + "%'";
        }
        if (Request["is_verify"].Equals("0"))
        {
            sql_end += " and isnull(verify_user,'')='' ";
        }
        if (Request["is_verify"].Equals("1"))
        {
            sql_end += " and isnull(verify_user,'')!='' ";
        }
        //查仓库
        if (!Request["wh_id"].Equals(""))
        {
            sql_end += " and wh_id=" + Request["wh_id"];
        }
        if (!Request["ic_code"].Equals(""))
        {
            sql_end += " and ic_code like '" + Request["ic_code"] + "'";
        }
        if (!Request["i_code"].Equals(""))
        {
            sql_end += " and i_code like '" + Request["i_code"] + "'";
        }
        if (!Request["i_name"].Equals(""))
        {
            sql_end += " and i_name like '%" + Request["i_name"] + "%'";
        }
        if (!Request["standard"].Equals(""))
        {
            sql_end += " and standard like '%" + Request["standard"] + "%'";
        }
        if (!Request["free1"].Equals(""))
        {
            sql_end += " and free1 like '%" + Request["free1"] + "%'";
        }
        if (!Request["free2"].Equals(""))
        {
            sql_end += " and free2 like '%" + Request["free2"] + "%'";
        }
        if (!Request["batch"].Equals(""))
        {
            sql_end += " and batch like '%" + Request["batch"] + "%'";
        }
        if (!Request["dep_name"].Equals(""))
        {
            sql_end += " and dep_name='" + Request["dep_name"] + "'";
        }
        if (!Request["iot_name"].Equals(""))
        {
            sql_end += " and iot_name='" + Request["iot_name"] + "'";
        }
        //当前用户是否管理员
        bool is_admin = new AuthUI().CheckLoginUserIsAdmin();
        if (!is_admin)
        {
            //值为1代表启用仓库权限控制
            string system_wh_auth = new ConfigReader().GetConfig("system_wh_auth");
            if (system_wh_auth.Equals("1"))
            {
                sql_end += " and wh_id in (" + new AuthEx().GetSqlForMyWarehouse() + ")";
            }
        }
        ht.Add("sql_end", sql_end);
        //查询后返回DataTable
        DataTable dt = GetList(ht, sql_select_field);
        //把sql放入session中供打印用
        string sql_print_detail_session_id = "sql_print_detail_" + module;
        Session[sql_print_detail_session_id] = sql_print;
        xview.Add("sql_print_detail_session_id", sql_print_detail_session_id);
        //供导出Excel用
        string field_for_export = mfd.field_for_export;
        Session[sql_print_detail_session_id + "_export_field"] = field_for_export;
        //得到总记录数为分页提供依据
        int rows_count = GetList_TotalNumbers(ht);
        //开启合计行功能
        aw.to_sum_row = true;
        //从模板读出哪些列需要合计
        aw.last_row_info = mfd.last_row_info;
        string aw_grid_info = aw.MakeGridObject(dt, rows_count, page_size, page);
        //把控件参数与数据源传递到页面
        xview.Add("aw_grid_info", aw_grid_info);
    }
    //打印用的sql
    public string sql_print = "";
    //列表查询用的sql
    string sql_list = @"
                    select top 1000000000 d.ios_id,t.io_id,t.from_id,t.from_type,
                    t.order_type,ot.ot_name,wh.wh_id,wh.wh_code,wh.wh_name,
                    ic.ic_code,ic.ic_name,d.i_id,d.free1,d.free2,d.batch,d.unit_price,
                    d.quantity,d.num,d.convert_rate,d.total_price,d.d_remark,t.bus_type,
                    d.d_sdefine1,d.d_sdefine2,d.d_sdefine3,d.d_sdefine4,d.d_sdefine5,
                    d.d_ndefine1,d.d_ndefine2,d.d_ndefine3,d.d_ndefine4,d.d_ndefine5,
                    i.sdefine1 as d_inv_sdefine1,i.sdefine2 as d_inv_sdefine2,i.sdefine3 as d_inv_sdefine3,
                    i.sdefine4 as d_inv_sdefine4,i.sdefine5 as d_inv_sdefine5,
                    i.ndefine1 as d_inv_ndefine1,i.ndefine2 as d_inv_ndefine2,i.ndefine3 as d_inv_ndefine3,
                    i.ndefine4 as d_inv_ndefine4,i.ndefine5 as d_inv_ndefine5,
                    t.order_number,convert(char(10),t.new_date,23) as new_date,
                    iot.iot_name,dep.dep_name,t.remark,
                    t.sdefine1,t.sdefine2,t.sdefine3,t.sdefine4,t.sdefine5,
                    t.ndefine1,t.ndefine2,t.ndefine3,t.ndefine4,t.ndefine5,
                    t.new_user,t.verify_user,i.i_code,i.i_name,i.standard,i.munit,i.aunit
                    from Stock_InOut t
                    left join Stock_InOuts d on t.io_id=d.io_id
                    left join Base_IOType iot on t.iot_id=iot.iot_id
                    left join Base_Department dep on d.d_dep_id=dep.dep_id
                    left join Base_Warehouse wh on d.d_wh_id=wh.wh_id
                    left join Base_Inventory i on d.i_id=i.i_id
                    left join Base_InventoryClass ic on i.ic_id=ic.ic_id
                    left join Base_OrderType ot on ot.ot_code=t.order_type
                    where 1=1 ";
    /// <summary>
    /// 得到列表
    /// </summary>
    /// <param name="sql_select_field">格式定义指定显示列</param>
    /// <returns>DataTable</returns>
    public DataTable GetList(Hashtable pg, string sql_select_field)
    {
        string order_field = pg["order_field"].ToString();
        string sql = @"select ROW_NUMBER() OVER(@order_field) AS row_num,@sql_select_field 
                from(@sql_list)t where 1=1 ";
        sql = sql.Replace("@sql_list", sql_list)
                 .Replace("@order_field", order_field)
                 .Replace("@sql_select_field", sql_select_field);
        sql_print = "select top 1000000000 * from (" + sql_list + ") t where 1=1 " + pg["sql_end"] + " " + pg["order_field"].ToString();
        //Response.Write(sql);
        //分页处理与查询条件
        PageHelper ph = new PageHelper();
        sql = ph.GetPageSQL(sql, pg, true);//得到分页后的SQL
        DataTable dt = new SqlUtil().GetDataTable(sql, null);
        return dt;
    }
    /// <summary>
    /// 得到总记录数
    /// </summary>
    /// <returns>int</returns>
    public int GetList_TotalNumbers(Hashtable pg)
    {
        string sql = "select count(1) from (" + sql_list + ")t where 1=1 ";
        //分页处理与查询条件
        PageHelper ph = new PageHelper();
        sql = ph.GetPageSQL(sql, pg, false);//得到分页SQL
        int total_numbers = (int)new SqlUtil().ExecuteScalar(sql, null);
        return total_numbers;
    }
}
