﻿<%@ WebService Language="C#" Class="MaterialOuts_Service" %>

using System;
using System.Web;
using System.Web.Services;
using System.Web.Services.Protocols;
using System.Transactions;
using SysCore;

[WebService(Namespace = "http://tempuri.org/")]
[WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1)]
// 若要允许使用 ASP.NET AJAX 从脚本中调用此 Web 服务，请取消注释以下行。 
[System.Web.Script.Services.ScriptService]
public class MaterialOuts_Service  : System.Web.Services.WebService {
    /// 单据类型(1,其它入库单 2,其它出库单 3,采购入库单 4,材料出库单 5,成品入库单 6,销售出库单)
    int order_type = 4;
    /// <summary>
    /// 删除
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string Delete(string ids)
    {
        InOutsDAL dal = new InOutsDAL();
        InOutDAL t_dal = new InOutDAL();
        InOut t = new InOut();
        OnHandDAL oh_dal = new OnHandDAL();
        bool bfirst = true;
        int io_id;
        foreach (string id in ids.Split(','))
        {
            if (bfirst)
            {
                io_id = dal.Get(Convert.ToInt32(id), order_type).io_id;
                t = t_dal.Get(io_id);
                if (t.verify_uid != null)
                {
                    return "已审核不允许删行";
                }
                if (new CloseMonthDAL().CheckIsCloseMonth(Convert.ToDateTime(t.new_date)))
                {
                    return "操作月份已业务结账,不允许修改!";
                }
                bfirst = false;
            }
            try
            {
                InOuts m = dal.Get(Convert.ToInt32(id), order_type);
                dal.Delete(Convert.ToInt32(id));
            }
            catch (Exception e)
            {
                return e.Message;
            }
        }
        return "success";
    }

    /// <summary>
    /// 修改
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string Save(string action, string io_id, string ios_id,
        string d_wh_id, string d_wh_name, string d_dep_id, string d_dep_name,
        string i_id, string free1, string free2, string batch, string i_code, string i_name,
        string standard, string munit, string aunit, string unit_price,/*string tax_unit_price,*/
        string quantity, string num, string convert_rate, string total_price,/*string tax_total_price,string tax,*/
        /*string d_tax_rate,*/ string d_remark, 
        string d_sdefine1, string d_sdefine2, string d_sdefine3, string d_sdefine4, string d_sdefine5,
        string d_ndefine1, string d_ndefine2, string d_ndefine3, string d_ndefine4, string d_ndefine5)
    {
        try
        {
            if (d_wh_id.Equals("0"))
            {
                d_wh_id = "";
            }
            if (d_dep_id.Equals("0"))
            {
                d_dep_id = "";
            }
            if (string.IsNullOrWhiteSpace(i_id) || i_id.Equals("0"))
            {
                return "请输入存货！";
            }
            if (string.IsNullOrWhiteSpace(quantity) || quantity.Equals("0"))
            {
                return "数量不可为空或零！";
            }
            InOutsDAL dal = new InOutsDAL();
            InOuts m = new InOuts();
            InOuts m_old = new InOuts();
            InOut io = new InOutDAL().Get(Convert.ToInt32(io_id));
            OnHandDAL oh_dal = new OnHandDAL();

            if (new CloseMonthDAL().CheckIsCloseMonth(Convert.ToDateTime(io.new_date)))
            {
                return "操作月份已业务结账,不允许修改!";
            }
            if (io.verify_uid != null)
            {
                return "已审核不允许改单";
            }
            if (action.Equals("Update"))
            {
                m = dal.Get(Convert.ToInt32(ios_id), order_type);
                m_old = dal.Get(Convert.ToInt32(ios_id), order_type);
            }
            try
            {
                if (d_wh_id.Equals("") || d_wh_id.Equals("0"))
                {
                    return "仓库不能为空！";
                }
                m.d_wh_id = XTools.ObjectNullToInt(d_wh_id);
                m.d_dep_id = XTools.ObjectNullToInt(d_dep_id);
                m.io_id = Convert.ToInt32(io_id);
                m.i_id = Convert.ToInt32(i_id);
                free1 = free1.Trim();
                free2 = free2.Trim();
                batch = batch.Trim();
                Inventory inv = new InventoryDAL().Get(Convert.ToInt32(i_id));
                if (!free1.Equals("") && inv.on_free1 == 0)
                    return "存货不允许输入自由项1！";
                if (!free2.Equals("") && inv.on_free2 == 0)
                    return "存货不允许输入自由项2！";
                if (free1.Equals("") && inv.on_free1 == 1)
                    return "存货必须输入自由项1！";
                if (free2.Equals("") && inv.on_free2 == 1)
                    return "存货必须输入自由项2！";
                m.free1 = free1;
                m.free2 = free2;
                if (!batch.Equals("") && inv.on_batch == 0)
                    return "存货不允许输入批次！";
                if (batch.Equals("") && inv.on_batch == 1)
                    return "存货必须输入批次！";
                if (inv.aunit.Equals("") && !num.Equals(""))
                    return "未启用辅计量单位，启不要输入件数！";
                if (!inv.aunit.Equals(""))
                {
                    if (num.Equals("") || num.Equals("0"))
                    {
                        return "存货启用了辅计量单位，必须输入件数！";
                    }
                    if (convert_rate.Equals("") || convert_rate.Equals("0"))
                    {
                        return "存货启用了辅计量单位，必须输入换算率！";
                    }
                }
                m.batch = batch;
                m.unit_price = XTools.ObjectNullToDecimal(unit_price);
                //m.tax_unit_price = XTools.ObjectNullToDecimal(tax_unit_price);
                m.quantity = XTools.ObjectNullToDecimal(quantity);
                m.num = XTools.ObjectNullToDecimal(num);
                m.convert_rate = XTools.ObjectNullToDecimal(convert_rate);
                m.total_price = XTools.ObjectNullToDecimal(total_price);
                //m.tax_total_price = XTools.ObjectNullToDecimal(tax_total_price);
                //m.tax = XTools.ObjectNullToDecimal(tax);
                //m.d_tax_rate = XTools.ObjectNullToDecimal(d_tax_rate);
                m.d_remark = XTools.ObjectNullToString(d_remark);
            }
            catch (Exception err)
            {
                return err.Message;
            }

            //启用事务
            using (TransactionScope scope = new TransactionScope())
            {
                if (action.Equals("Update"))
                {
                    //加现存量
                    //oh_dal.UpdateQuantity(io.wh_id, m_old.i_id, m_old.free1, m_old.free2, m_old.batch, m_old.quantity, m_old.num);
                    //更新明细
                    dal.Update(m);
                }
                else
                {
                    //新增明细
                    dal.Add(m);
                }
                //减现存量
                //oh_dal.UpdateQuantity(io.wh_id, m.i_id, m.free1, m.free2, m.batch, -m.quantity, -m.num);
                /*
                OnHand oh = oh_dal.Get(io.wh_id, m.i_id, m.free1, m.free2, m.batch);
                if (oh.quantity < 0)
                {
                    return "本次操作后现存量将出现负数，保存失败！";
                }*/
                //提交事务
                scope.Complete();
            }
        }
        catch (Exception e)
        {
            return e.Message;
        }
        return "success";
    }
 
}