﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using SysCore.Control;
using SysCore.Model;
using SysCore.DAL;

public partial class Stock_MaterialOut_MaterialOuts_Edit : System.Web.UI.Page
{
    public AuthUI auth = new AuthUI();
    public int id, did;
    public string action;
    public InOut tm;
    public InOuts m;
    public Hashtable xview = new Hashtable();
    /// 单据类型(1,其它入库单 2,其它出库单 3,采购入库单 4,材料出库单 5,成品入库单 6,销售出库单)
    int order_type = 4;

    protected void Page_Load(object sender, EventArgs e)
    {
        new LoginState().CheckLogin();
        action = Request["action"].ToString();
        xview.Add("action", action);
        BindData();
    }
    /// <summary>
    /// 绑定页面数据
    /// </summary>
    void BindData()
    {
        id = Convert.ToInt32(Request["id"]);
        did = Convert.ToInt32(Request["did"]);
        InOutsDAL dal = new InOutsDAL();
        m = dal.Get(did, order_type);
        ModuleFormatDesigner mfd = new ModuleFormatDesigner();
        InputUI ui = new InputUI();
        string sql_select_field = "";//SQL所需选择列
        string module = "Stock_MaterialOut_Input";//模块
        mfd.CreateInput(module, ref ui, ref sql_select_field, m);
        xview.Add("input_ui", ui.CreateUI());
        Hashtable ht_js = mfd.MakeJavaScript_GetInput(module);
        xview.Add("Script_GetInput", ht_js["Script_GetInput"].ToString());
        xview.Add("Script_SaveJSON", ht_js["Script_SaveJSON"].ToString());
        Config cf = new Config();
        ConfigDAL cf_dal = new ConfigDAL();
        xview.Add("digit_quantity", cf_dal.GetByCode("digit_quantity").cf_value);
        xview.Add("digit_number", cf_dal.GetByCode("digit_number").cf_value);
        xview.Add("digit_exch", cf_dal.GetByCode("digit_exch").cf_value);
        xview.Add("digit_unit_price", cf_dal.GetByCode("digit_unit_price").cf_value);
        tm = new InOutDAL().Get(id);
        InventoryPhoto ip = new InventoryPhoto();
        if (action.Equals("Update"))
        {
            ip = new InventoryPhotoDAL().GetByInventory(m.inventory.i_id);
        }
        if (ip.small_pic_url == null)
        {
            xview.Add("inventory_photo_view", ip.no_photo);
        }
        else
        {
            xview.Add("inventory_photo_view", ip.small_pic_url);
            xview.Add("inventory_photo_view_href", ip.pic_url);
        }
    }
}