﻿<%@ WebService Language="C#" Class="SalesOuts_Service" %>

using System;
using System.Web;
using System.Web.Services;
using System.Web.Services.Protocols;
using System.Transactions;
using SysCore;

[WebService(Namespace = "http://tempuri.org/")]
[WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1)]
// 若要允许使用 ASP.NET AJAX 从脚本中调用此 Web 服务，请取消注释以下行。 
[System.Web.Script.Services.ScriptService]
public class SalesOuts_Service  : System.Web.Services.WebService {

    /// 单据类型(1,其它入库单 2,其它出库单 3,采购入库单 4,材料出库单 5,成品入库单 6,销售出库单)
    int order_type = 6;
    /// <summary>
    /// 删除
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string Delete(string ids)
    {
        //值为1代表发货单审核自动生成出库单
        string sale_fahuo_verify_salesout = new ConfigReader().GetConfig("sale_fahuo_verify_salesout");
        if (sale_fahuo_verify_salesout.Equals("1"))
        {
            return "开启【发货单审核自动生成出库单】业务后,不允许增改销售出库单!";
        }
        InOutsDAL dal = new InOutsDAL();
        InOutDAL t_dal = new InOutDAL();
        InOut t = new InOut();
        bool bfirst = true;
        int io_id;
        foreach (string id in ids.Split(','))
        {
            if (bfirst)
            {
                io_id = dal.Get(Convert.ToInt32(id), order_type).io_id;
                t = t_dal.Get(io_id);
                if (t.verify_uid != null)
                {
                    return "已审核不允许删行";
                }
                if (new CloseMonthDAL().CheckIsCloseMonth(Convert.ToDateTime(t.new_date)))
                {
                    return "操作月份已业务结账,不允许修改!";
                }
                bfirst = false;
            }
            try
            {
                InOuts m = dal.Get(Convert.ToInt32(id), order_type);
                            //启用事务
                using (TransactionScope scope = new TransactionScope())
                {
                    dal.Delete(Convert.ToInt32(id));
                    //提交事务
                    scope.Complete();
                }
      
            }
            catch (Exception e)
            {
                return e.Message;
            }
        }
        return "success";
    }

    /// <summary>
    /// 修改
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string Save(string action, string io_id, string ios_id, string dos_id,
        string d_wh_id, string d_wh_name, string d_dep_id, string d_dep_name,
        string i_id, string free1, string free2, string batch, string i_code, string i_name,
        string standard,string munit,string aunit,string unit_price, string tax_unit_price,
        string quantity,string num,string convert_rate,string total_price, string tax_total_price,string tax,
        string d_tax_rate, string d_remark, 
        string d_sdefine1, string d_sdefine2, string d_sdefine3, string d_sdefine4, string d_sdefine5,
        string d_ndefine1, string d_ndefine2, string d_ndefine3, string d_ndefine4, string d_ndefine5)
    {
        //值为1代表发货单审核自动生成出库单
        string sale_fahuo_verify_salesout = new ConfigReader().GetConfig("sale_fahuo_verify_salesout");
        if (sale_fahuo_verify_salesout.Equals("1"))
        {
            return "开启【发货单审核自动生成出库单】业务后,不允许增改销售出库单!";
        }
        if (d_wh_id.Equals("0"))
        {
            d_wh_id = "";
        }
        if (d_dep_id.Equals("0"))
        {
            d_dep_id = "";
        }
        if (string.IsNullOrWhiteSpace(i_id) || i_id.Equals("0"))
        {
            return "请输入存货！";
        }
        if (string.IsNullOrWhiteSpace(quantity) || quantity.Equals("0"))
        {
            return "数量不可为空或零！";
        }
        InOutsDAL dal = new InOutsDAL();
        InOuts m = new InOuts();
        InOuts m_old = new InOuts();
        InOut io = new InOutDAL().Get(Convert.ToInt32(io_id));
        OnHandDAL oh_dal = new OnHandDAL();
        try
        {
            if (io.verify_uid != null)
            {
                return "已审核不允许改单";
            }
            if (new CloseMonthDAL().CheckIsCloseMonth(Convert.ToDateTime(io.new_date)))
            {
                return "操作月份已业务结账,不允许修改!";
            }
            if (action.Equals("Update"))
            {
                m = dal.Get(Convert.ToInt32(ios_id), order_type);
                m_old = dal.Get(Convert.ToInt32(ios_id), order_type);
            }
            try
            {
                if (d_wh_id.Equals("") || d_wh_id.Equals("0"))
                {
                    return "仓库不能为空！";
                }
                m.d_wh_id = XTools.ObjectNullToInt(d_wh_id);
                m.d_dep_id = XTools.ObjectNullToInt(d_dep_id);
                m.io_id = Convert.ToInt32(io_id);
                m.dos_id = XTools.ObjectNullToInt(dos_id);
                m.i_id = Convert.ToInt32(i_id);
                free1 = free1.Trim();
                free2 = free2.Trim();
                batch = batch.Trim();
                Inventory inv = new InventoryDAL().Get(Convert.ToInt32(i_id));
                if (!free1.Equals("") && inv.on_free1 == 0)
                    return "存货不允许输入自由项1！";
                if (!free2.Equals("") && inv.on_free2 == 0)
                    return "存货不允许输入自由项2！";
                if (free1.Equals("") && inv.on_free1 == 1)
                    return "存货必须输入自由项1！";
                if (free2.Equals("") && inv.on_free2 == 1)
                    return "存货必须输入自由项2！";
                m.free1 = free1;
                m.free2 = free2;
                if (!batch.Equals("") && inv.on_batch == 0)
                    return "存货不允许输入批次！";
                if (batch.Equals("") && inv.on_batch == 1)
                    return "存货必须输入批次！";
                if (inv.aunit.Equals("") && !num.Equals(""))
                    return "未启用辅计量单位，启不要输入件数！";
                if (!inv.aunit.Equals(""))
                {
                    if (num.Equals("") || num.Equals("0"))
                    {
                        return "存货启用了辅计量单位，必须输入件数！";
                    }
                    if (convert_rate.Equals("") || convert_rate.Equals("0"))
                    {
                        return "存货启用了辅计量单位，必须输入换算率！";
                    }
                }
                m.batch = batch;
                m.quantity = XTools.ObjectNullToDecimal(quantity);
                m.num = XTools.ObjectNullToDecimal(num);
                m.convert_rate = XTools.ObjectNullToDecimal(convert_rate);
                m.d_remark = XTools.ObjectNullToString(d_remark);
                m.unit_price = XTools.ObjectNullToDecimal(unit_price);
                m.tax_unit_price = XTools.ObjectNullToDecimal(tax_unit_price);
                m.total_price = XTools.ObjectNullToDecimal(total_price);
                m.tax_total_price = XTools.ObjectNullToDecimal(tax_total_price);
                m.tax = XTools.ObjectNullToDecimal(tax);
                m.d_tax_rate = XTools.ObjectNullToDecimal(d_tax_rate);
                m.d_sdefine1 = d_sdefine1;
                m.d_sdefine2 = d_sdefine2;
                m.d_sdefine3 = d_sdefine3;
                m.d_sdefine4 = d_sdefine4;
                m.d_sdefine5 = d_sdefine5;
                m.d_ndefine1 = XTools.ObjectNullToDecimal(d_ndefine1);
                m.d_ndefine2 = XTools.ObjectNullToDecimal(d_ndefine2);
                m.d_ndefine3 = XTools.ObjectNullToDecimal(d_ndefine3);
                m.d_ndefine4 = XTools.ObjectNullToDecimal(d_ndefine4);
                m.d_ndefine5 = XTools.ObjectNullToDecimal(d_ndefine5);
            }
            catch (Exception err)
            {
                return err.Message;
            }
            //启用事务
            using (TransactionScope scope = new TransactionScope())
            {
                if (action.Equals("Update"))
                {
                    //更新明细
                    dal.Update(m);
                }
                else
                {
                    //新增明细
                    dal.Add(m);
                }
                //提交事务
                scope.Complete();
            }
        }
        catch (Exception e)
        {
            return e.Message;
        }
        return "success";
    }
    /// <summary>
    /// 发货单多选
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string MultiSelect(string io_id, string ids)
    {
        try
        {
            
            InOutDAL tdal = new InOutDAL();
            InOut io = tdal.Get(Convert.ToInt32(io_id));
            string[] arr = ids.Split(',');
            DeliveryOrdersDAL sdal = new DeliveryOrdersDAL();
            InOutsDAL ios_dal = new InOutsDAL();
            int total_numbers = ios_dal.GetOneOrder_TotalNumbers(Convert.ToInt32(io_id));
            bool has_get_from = false;//是否有从发货单取数到表头
            for (int i = 0; i < arr.Length; i++)
            {
                int dos_id = Convert.ToInt32(arr[i]);
                DeliveryOrders dos = sdal.Get(dos_id);
                InOuts m = new InOuts();
                m.io_id = Convert.ToInt32(io_id);
                m.dos_id = dos.dos_id;
                m.d_wh_id = dos.d_wh_id;
                m.d_dep_id = io.dep_id;
                m.i_id = dos.i_id;
                m.free1 = dos.free1;
                m.free2 = dos.free2;
                m.batch = dos.batch;
                //m.unit_price = dos.nat_unit_price;
                //m.tax_unit_price = dos.nat_tax_unit_price;
                //m.d_tax_rate = dos.d_tax_rate;
                decimal? wait_in_quan = XTools.DecimalNullToZero(dos.quantity) - XTools.DecimalNullToZero(dos.acc_out_quantity);
                decimal? wait_in_num = XTools.DecimalNullToZero(dos.num) - XTools.DecimalNullToZero(dos.acc_out_num);
                if ((dos.quantity > 0 && wait_in_quan > 0) 
                  ||(dos.quantity < 0 && wait_in_quan < 0))
                {
                    m.quantity = wait_in_quan;
                    if (!dos.inventory.aunit.Equals(""))
                    {
                        m.num = wait_in_num;
                        m.convert_rate = dos.convert_rate;
                    }
                }
                //表体自定义项
                m.d_sdefine1 = dos.d_sdefine1;
                m.d_sdefine2 = dos.d_sdefine2;
                m.d_sdefine3 = dos.d_sdefine3;
                m.d_sdefine4 = dos.d_sdefine4;
                m.d_sdefine5 = dos.d_sdefine5;
                m.d_ndefine1 = dos.d_ndefine1;
                m.d_ndefine2 = dos.d_ndefine2;
                m.d_ndefine3 = dos.d_ndefine3;
                m.d_ndefine4 = dos.d_ndefine4;
                m.d_ndefine5 = dos.d_ndefine5;
                
                ios_dal.Add(m);
                //如果还没从订单取数到表头
                if (!has_get_from)
                {
                    //如果表体为零行，代表新增第一条记录，则默认从订单带出相关表头项
                    if (total_numbers == 0)
                    {
                        DeliveryOrderDAL dal = new DeliveryOrderDAL();
                        DeliveryOrder po = dal.Get(dos.do_id);
                        io.cus_id = po.cus_id;
                        io.dep_id = po.dep_id;
                        io.ele_id = po.ele_id;
                        //io.tax_rate = po.tax_rate;
                        //io.contact = po.contact;
                        //io.ship_address = po.ship_address;
                        //io.phone = po.phone;
                        io.remark = po.remark;
                        io.sdefine1 = po.sdefine1;
                        io.sdefine2 = po.sdefine2;
                        io.sdefine3 = po.sdefine3;
                        io.sdefine4 = po.sdefine4;
                        io.sdefine5 = po.sdefine5;
                        io.ndefine1 = po.ndefine1;
                        io.ndefine2 = po.ndefine2;
                        io.ndefine3 = po.ndefine3;
                        io.ndefine4 = po.ndefine4;
                        io.ndefine5 = po.ndefine5;
                        tdal.Update(io);
                    }
                    has_get_from = true;
                }
                
            }
        }
        catch (Exception err)
        {
            return err.Message;
        }
        return "success";
    }
    /// <summary>
    /// 获取
    /// </summary>
    [WebMethod(EnableSession = true)]
    public InOuts Get(string ios_id)
    {
        InOutsDAL dal = new InOutsDAL();
        return dal.Get(Convert.ToInt32(ios_id), order_type);
    }
}