﻿<%@ WebService Language="C#" Class="SalesOut_Service" %>

using System;
using System.Web;
using System.Web.Services;
using System.Web.Services.Protocols;
using System.Collections;
using System.Transactions;
using System.Data;
using System.Data.SqlClient;
using SysCore;
using SysCore.DAL;

[WebService(Namespace = "http://tempuri.org/")]
[WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1)]
// 若要允许使用 ASP.NET AJAX 从脚本中调用此 Web 服务，请取消注释以下行。 
[System.Web.Script.Services.ScriptService]
public class SalesOut_Service  : System.Web.Services.WebService {
    /// 单据类型(1,其它出库单 2,其它出库单 3,采购出库单 4,材料出库单 5,成品出库单 6,销售出库单)
    int order_type = 6;
    /// <summary>
    /// 保存单据
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string Save(string action, string io_id, string order_number,
        string new_date, string wh_id, string wh_name, string cus_id, string cus_name,
        string iot_id, string iot_name, string st_id, string st_name, string sw_id, string sw_name,
        string dep_id, string dep_name, string ele_id, string ele_name, string tax_rate, string remark,
        string sdefine1, string sdefine2, string sdefine3, string sdefine4, string sdefine5,
        string ndefine1, string ndefine2, string ndefine3, string ndefine4, string ndefine5)
    {
        //值为1代表发货单审核自动生成出库单
        string sale_fahuo_verify_salesout = new ConfigReader().GetConfig("sale_fahuo_verify_salesout");
        if (sale_fahuo_verify_salesout.Equals("1"))
        {
            return "开启【发货单审核自动生成出库单】业务后,不允许手工做销售出库单!";
        }
        if (cus_name.Equals("")) cus_id = "";
        if (ele_name.Equals("")) ele_id = "";
        if (dep_name.Equals("")) dep_id = "";
        if (st_name.Equals("")) st_id = "";
        if (sw_name.Equals("")) sw_id = "";
        if (wh_name.Equals("")) wh_id = "";
        
        if (dep_id.Equals("0") || dep_name.Equals(""))
        {
            dep_id = "";
        }
        if (ele_id.Equals("0") || ele_name.Equals(""))
        {
            ele_id = "";
        }
        if (iot_id.Equals("0") || iot_name.Equals(""))
        {
            iot_id = "";
        }
        
        //税率为空时让等于0
        if (tax_rate.Trim().Equals(""))
        {
            tax_rate = "0";
        }
        if (string.IsNullOrWhiteSpace(new_date))
        {
            return "制单日期不可为空！";
        }
        //值为1代表启用仓库权限控制
        string system_wh_auth = new ConfigReader().GetConfig("system_wh_auth");
        if (system_wh_auth.Equals("1"))
        {
            if (string.IsNullOrWhiteSpace(wh_id))
            {
                return "仓库不可为空！";
            }
        }
        if (cus_id.Equals("0") || cus_name.Equals(""))
        {
            return "客户不可为空";
        }
        if (string.IsNullOrWhiteSpace(st_id))
        {
            //return "销售类型不可为空！";
        }
        //仓库进出时收发类型是否必须填写 1,必填;0,可选
        string stock_input_iotype = new ConfigReader().GetConfig("stock_input_iotype");
        if (stock_input_iotype.Equals("1"))
        {
            if (string.IsNullOrWhiteSpace(iot_id))
            {
                return "收发类型不可为空！";
            }
        }
        try
        {
            if (new CloseMonthDAL().CheckIsCloseMonth(Convert.ToDateTime(new_date)))
            {
                return "操作月份已业务结账,不允许修改!";
            }
            InOutDAL dal = new InOutDAL();
            InOut m = new InOut();
            if (action.Equals("Update"))
            {
                m = dal.Get(Convert.ToInt32(io_id));
                if (string.IsNullOrWhiteSpace(order_number))
                {
                    return "单据号不可为空！";
                }
                if (!m.order_number.Equals(order_number))
                {
                    if (dal.CheckExist(order_number, order_type))
                    {
                        return "您修改了单号，然而单号：" + order_number + "已存在，请尝试别的号码！";
                    }
                }
            }
            LoginInfo li = new LoginInfo();
            try
            {
                m.io_flag = 0;//1出库,0出库
                m.order_type = order_type;
                m.new_date = Convert.ToDateTime(new_date);
                m.order_number = order_number;
                m.wh_id = XTools.ObjectNullToInt(wh_id);
                m.cus_id = XTools.ObjectNullToInt(cus_id);
                m.iot_id = XTools.ObjectNullToInt(iot_id);
                m.st_id = XTools.ObjectNullToInt(st_id);
                m.sw_id = XTools.ObjectNullToInt(sw_id);
                m.dep_id = XTools.ObjectNullToInt(dep_id);
                m.ele_id = XTools.ObjectNullToInt(ele_id);
                m.tax_rate = XTools.ObjectNullToDecimal(tax_rate);
                m.remark = remark.ToString();
                m.sdefine1 = sdefine1.ToString();
                m.sdefine2 = sdefine2.ToString();
                m.sdefine3 = sdefine3.ToString();
                m.sdefine4 = sdefine4.ToString();
                m.sdefine5 = sdefine5.ToString();
                m.ndefine1 = XTools.ObjectNullToDecimal(ndefine1);
                m.ndefine2 = XTools.ObjectNullToDecimal(ndefine2);
                m.ndefine3 = XTools.ObjectNullToDecimal(ndefine3);
                m.ndefine4 = XTools.ObjectNullToDecimal(ndefine4);
                m.ndefine5 = XTools.ObjectNullToDecimal(ndefine5);
                

            }
            catch (Exception err)
            {
                return err.Message;
            }
            if (action.Equals("Update"))
            {
                if (m.verify_uid != null)
                {
                    return "已审核不允许改单";
                }
                if (string.IsNullOrWhiteSpace(order_number))
                {
                    return "单据号不可为空！";
                }
                m.update_date = Convert.ToDateTime(li.login_date);
                m.update_uid = li.uid;
                m.update_user = li.nickname;
                try{
                    //启用事务
                    using (TransactionScope scope = new TransactionScope())
                    {
                        //更新表头
                        dal.Update(m);
                        new UserLogDAL().AddUserLog("销售出库单", "修改表头", m.io_id, m.order_number);
                        //提交事务
                        scope.Complete();
                    }
                }
                catch (Exception err)
                {
                    return err.Message;
                }
            }
            else
            {
                //如果新增时单据号不为空说明是手工输入单号
                if (!order_number.Equals(""))
                {
                    if (dal.CheckExist(order_number, order_type))
                    {
                        return "单据号：" + order_number + "已存在！";
                    }
                }
                m.new_uid = li.uid;
                m.new_user = li.nickname;
                //启用事务
                using (TransactionScope scope = new TransactionScope())
                {
                    try
                    {
                        //新增表头
                        dal.Add(m);
                    }
                    catch (Exception err)
                    {
                        return err.Message;
                    }
                    //得到新增保存后的最大ID号
                    int MaxID = dal.GetMaxID();
                    io_id = MaxID.ToString();
                    m = dal.Get(MaxID);
                    //如果流水号为空代表是系统自动流水
                    if (order_number.Equals(""))
                    {
                        //更新实体
                        try
                        {
                            //根据规则生成流水号
                            Hashtable ht_num = new Hashtable();
                            if (m.io_type != null)
                            {
                                ht_num.Add("[iot_code]", m.io_type.iot_code);
                            }
                            string running_number = new RunningNumberRuleDAL().GetModuleRunningNumber("Sale_SalesOut", ht_num);
                            m.order_number = running_number;
                            dal.Update(m);
                        }
                        catch
                        {
                            return "自动生成流水号出错,请检查必填项目!";
                        }
                    }
                    new UserLogDAL().AddUserLog("销售出库单", "新增单据", m.io_id, m.order_number);
                    //提交事务
                    scope.Complete();
                }
            }
        }
        catch (Exception err)
        {
            return err.Message;
        }
        return "success|" + io_id;
    }
    /// <summary>
    /// 删单
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string Delete(string ids)
    {
        string prev_id = "";
        try
        {
            InOutDAL dal = new InOutDAL();
            string sql = "select distinct io_id from Stock_InOut where io_id in (" + ids + ")";
            using(SqlDataReader reader = new SqlUtil().GetDataReader(sql, null))
            {
                while (reader.Read())
                {
                    int id = reader.GetInt32(0);
                    InOut io = dal.Get(id);
                    if (io.verify_uid != null)
                    {
                        return "单据:" + io.order_number + "已审核不允许删单!";
                    }
                    if (new CloseMonthDAL().CheckIsCloseMonth(Convert.ToDateTime(io.new_date)))
                    {
                        return "操作月份已业务结账,不允许修改!";
                    }
                    InOutsDAL sdal = new InOutsDAL();
                    prev_id = GetPrevNextID(id, "1");//得到上一张单据ID
                    string msg = "";
                    //启用事务
                    using (TransactionScope scope = new TransactionScope())
                    {
                        new UserLogDAL().AddUserLog("销售出库单", "删除单据", io.io_id, io.order_number);
                        msg = dal.Delete(id, order_type);
                        if (!msg.Equals("success"))
                        {
                            return msg;
                        }
                        //提交事务
                        scope.Complete();
                    }
                }//end of while
            }//end of using
        }//end of try
        catch (Exception err)
        {
            return err.InnerException.ToString();
        }
        return "success|" + prev_id;
    }
    /// <summary>
    /// 检查
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string Check(int id, int action_type)
    {
        try
        {
            InOutDAL dal = new InOutDAL();
            InOut m = dal.Get(id);
            if (m.cus_id == null)
            {
                return "请填写客户!";
            }
            //检查必填项
            string result = dal.CheckMustInput(id);
            if (!result.Equals("success"))
            {
                return result;
            }
            //检查是否超现存量
            result = dal.CheckOverStock(id, action_type);
            if (!result.Equals("success"))
            {
                return result;
            }
            if (action_type == 1)
            {
                //检查是否超订单数量
                result = dal.CheckSalesOutOverDeliveryOrder(id);
                if (!result.Equals("success"))
                {
                    return result;
                }
            }
            return "success";
        }
        catch (Exception err)
        {
            return err.Message;
        }
    }

    /// <summary>
    /// 审核或弃审
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string Verify(string ids, int action_type)
    {
        SqlUtil su = new SqlUtil();
        try
        {
            //值为1代表销售出库单审核自动生成对账单
            string sales_out_verify_check_account = new ConfigReader().GetConfig("sales_out_verify_check_account");
            InOutDAL dal = new InOutDAL();
            string sql = "select distinct io_id from Stock_InOut where io_id in (" + ids + ")";
            if (action_type == 1)
            {
                sql += " and isnull(verify_user,'')=''";
            }
            else
            {
                sql += " and isnull(verify_user,'')!=''";
            }
            using(SqlDataReader reader = new SqlUtil().GetDataReader(sql, null))
            {
                while (reader.Read())
                {
                    int id = reader.GetInt32(0);
                    InOut m = dal.Get(Convert.ToInt32(id));
                    if (new CloseMonthDAL().CheckIsCloseMonth(Convert.ToDateTime(m.new_date)))
                    {
                        return "操作月份已业务结账,不允许修改!";
                    }
                    //值为1代表发货单审核自动生成出库单
                    string sale_fahuo_verify_salesout = new ConfigReader().GetConfig("sale_fahuo_verify_salesout");
                    if (sale_fahuo_verify_salesout.Equals("1"))
                    {
                        return "开启【发货单审核自动生成出库单】业务后,不允许增改销售出库单!";
                    }
                    LoginInfo li = new LoginInfo();
                    if (action_type == 1)
                    {
                        if (m.verify_uid != null)
                        {
                            return "不允许重复审核";
                        }
                        if (new InOutsDAL().GetOneOrder_TotalNumbers(id) == 0)
                        {
                            return "表体为空不允许审核!";
                        }
                        m.verify_uid = li.uid;
                        m.verify_user = li.nickname;
                    }
                    else
                    {
                        if (m.verify_uid == null)
                        {
                            return "不允许重复弃审";
                        }
                        if (!m.from_type.Equals(""))
                        {
                            return "本单据来源于[" + m.from_type + "],不允许弃审!";
                        }
                        if (sales_out_verify_check_account.Equals("0"))
                        {
                            if (dal.CheckIsDuiZhang(m.io_id))
                            {
                                return "销售出库单已作对账，不允许弃审！";
                            }
                        }
                        m.verify_uid = null;
                        m.verify_user = null;
                    }
                    //审核与弃审前检查
                    string result = Check(Convert.ToInt32(id), action_type);
                    if (!result.Equals("success"))
                    {
                        return result;
                    }
                    //启用事务
                    using (TransactionScope scope = new TransactionScope())
                    {
                        if (action_type == 1)
                        {
                            new UserLogDAL().AddUserLog("销售出库单", "审核单据", m.io_id, m.order_number);
                        }
                        else
                        {
                            new UserLogDAL().AddUserLog("销售出库单", "弃审单据", m.io_id, m.order_number);
                        }
                        //更新实体
                        dal.Update(m);
                        if (sales_out_verify_check_account.Equals("1"))
                        {
                            if (action_type == 1)
                            {
                                //通过销售出库单生成对账单
                                string msg_ac = dal.InOutToCheckAccount(m.io_id, action_type);
                                if (!msg_ac.Equals("success"))
                                {
                                    return msg_ac;
                                }
                            }
                            else
                            {
                                //删除销售出库单自动生成的对账单
                                string msg_ac = dal.DeleteCheckAccountByInOut(m.io_id, action_type);
                                if (!msg_ac.Equals("success"))
                                {
                                    return msg_ac;
                                }
                            }
                        }
                        
                        //更新累计出库数
                        dal.UpdateSalesOutQuantityByOrder(m.io_id, action_type);
                        //更新现存量
                        dal.UpdateOhHandByOrder(m.io_id, -action_type);
                        ModuleScriptDAL ms_dal = new ModuleScriptDAL();
                        if (action_type == 1)
                        {
                            //销售出库单审核SQL脚本
                            string sql_verify = ms_dal.GetByCode("SalesOut_Verify").script;
                            sql_verify = sql_verify.Replace("@io_id", id.ToString());
                            su.ExecuteNonQuery(sql_verify, null);
                        }
                        else
                        {
                        }
                        //提交事务
                        scope.Complete();
                    }//end of trans
                }//end of while
            }//end of reader
            return "success";
        }catch(Exception e){
            return e.Message;
        }
    }
    
    
    /// <summary>
    /// 上张或下张
    /// </summary>
    /// <param name="id">主表id</param>
    /// <param name="type">操作类型</param>
    /// <returns></returns>
    [WebMethod(EnableSession = true)]
    public string GetPrevNextID(int id, string type)
    {
        InOutDAL dal = new InOutDAL();
        return dal.GetPrevNextID(id, type, order_type).ToString();
    }
    /// <summary>
    /// 批量设置表体仓库
    /// </summary>
    /// <param name="id">主表id</param>
    /// <param name="wh_id">仓库id</param>
    /// <returns></returns>
    [WebMethod(EnableSession = true)]
    public string BatchSetWarehouse(int id, int wh_id)
    {
        InOutDAL dal = new InOutDAL();
        try
        {
            if (dal.Get(id).verify_uid != null)
            {
                return "已审核不允许改单";
            }
            dal.BatchSetWarehouse(id, wh_id);
        }
        catch (Exception err)
        {
            return err.Message;
        }
        return "success";
    }
    /// <summary>
    /// 批量设置表体部门
    /// </summary>
    /// <param name="id">主表id</param>
    /// <param name="dep_id">部门id</param>
    /// <returns></returns>
    [WebMethod(EnableSession = true)]
    public string BatchSetDepartment(int id, int dep_id)
    {
        InOutDAL dal = new InOutDAL();
        try
        {
            if (dal.Get(id).verify_uid != null)
            {
                return "已审核不允许改单";
            }
            dal.BatchSetDepartment(id, dep_id);
        }
        catch (Exception err)
        {
            return err.Message;
        }
        return "success";
    }
    
    
}