﻿<%@ WebService Language="C#" Class="SalesOrder_Service" %>

using System;
using System.Web;
using System.Web.Services;
using System.Web.Services.Protocols;
using System.Collections;
using System.Transactions;
using System.Data;
using System.Data.SqlClient;
using SysCore;
using SysCore.DAL;
using SysCore.Model;

[WebService(Namespace = "http://tempuri.org/")]
[WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1)]
// 若要允许使用 ASP.NET AJAX 从脚本中调用此 Web 服务，请取消注释以下行。 
[System.Web.Script.Services.ScriptService]
public class SalesOrder_Service  : System.Web.Services.WebService {
    /// <summary>
    /// 保存单据
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string Save(string action, string so_id, string order_number, string new_date,
        string cus_id, string cus_name, string st_id, string st_name, string dep_id,string dep_name,
        string ele_id, string ele_name, string crc_id, string crc_name, string exchange_rate,
        string tax_rate, string sw_id, string sw_name, string ship_address, string contact, string phone, string remark,
        string sdefine1, string sdefine2, string sdefine3, string sdefine4, string sdefine5,
        string ndefine1, string ndefine2, string ndefine3, string ndefine4, string ndefine5)
    {
        if (cus_name.Equals("")) cus_id = "";
        if (ele_name.Equals("")) ele_id = "";
        if (dep_name.Equals("")) dep_id = "";
        if (st_name.Equals("")) st_id = "";
        if (crc_name.Equals("")) crc_id = "";
        if (sw_name.Equals("")) sw_id = "";
        
        if (string.IsNullOrWhiteSpace(new_date))
        {
            return "订单日期不可为空！";
        }
        if (string.IsNullOrWhiteSpace(cus_id))
        {
            return "客户不可为空！";
        }
        if (string.IsNullOrWhiteSpace(ele_id))
        {
            //return "业务员不可为空！";
        }
        if (string.IsNullOrWhiteSpace(st_id))
        {
            //return "销售类型不可为空！";
        }
        if (string.IsNullOrWhiteSpace(dep_id))
        {
            //return "销售部门不可为空！";
        }
        if (string.IsNullOrWhiteSpace(crc_id))
        {
            return "币种不可为空！";
        }
        //汇率为空或0时让等于1
        if (exchange_rate.Trim().Equals("") || exchange_rate.Trim().Equals("0"))
        {
            exchange_rate = "1";
        }
        //税率为空时让等于0
        if (tax_rate.Trim().Equals(""))
        {
            tax_rate = "0";
        }
        try
        {
            if (new CloseMonthDAL().CheckIsCloseMonth(Convert.ToDateTime(new_date)))
            {
                return "操作月份已业务结账,不允许修改!";
            }
            SalesOrderDAL dal = new SalesOrderDAL();
            SalesOrder m = new SalesOrder();
            LoginInfo li = new LoginInfo();
            if (action.Equals("Update"))
            {
                m = dal.Get(Convert.ToInt32(so_id));
                m.update_uid = li.uid;
                m.update_user = li.nickname;//修改人名称
                if (m.verify_uid != null)
                {
                    return "已审核不允许改单";
                }
                if (string.IsNullOrWhiteSpace(order_number))
                {
                    return "单据号不可为空！";
                }
                if (!m.order_number.Equals(order_number))
                {
                    if (dal.CheckExist(order_number))
                    {
                        return "您修改了单号，然而单号：" + order_number + "已存在，请尝试别的号码！";
                    }
                }
            }
            else
            {
                m.new_uid = li.uid;
                m.new_user = li.nickname;//新增人名称
            }
            try
            {
                m.new_date = Convert.ToDateTime(new_date);
                m.order_number = order_number;
                m.cus_id = XTools.ObjectNullToInt(cus_id);
                m.st_id = XTools.ObjectNullToInt(st_id);
                m.dep_id = XTools.ObjectNullToInt(dep_id);
                m.ele_id = XTools.ObjectNullToInt(ele_id);
                m.crc_id = XTools.ObjectNullToInt(crc_id);
                m.exchange_rate = XTools.ObjectNullToDecimal(exchange_rate);
                m.tax_rate = XTools.ObjectNullToDecimal(tax_rate);
                m.sw_id = XTools.ObjectNullToInt(sw_id);
                m.ship_address = ship_address.ToString();
                m.contact = contact.ToString();
                m.phone = phone.ToString();
                m.remark = remark.ToString();
                m.sdefine1 = sdefine1.ToString();
                m.sdefine2 = sdefine2.ToString();
                m.sdefine3 = sdefine3.ToString();
                m.sdefine4 = sdefine4.ToString();
                m.sdefine5 = sdefine5.ToString();
                m.ndefine1 = XTools.ObjectNullToDecimal(ndefine1);
                m.ndefine2 = XTools.ObjectNullToDecimal(ndefine2);
                m.ndefine3 = XTools.ObjectNullToDecimal(ndefine3);
                m.ndefine4 = XTools.ObjectNullToDecimal(ndefine4);
                m.ndefine5 = XTools.ObjectNullToDecimal(ndefine5);
            }
            catch (Exception err)
            {
                return err.Message;
            }
            //启用事务
            using (TransactionScope scope = new TransactionScope())
            {
                if (action.Equals("Update"))
                {
                    m.update_date = DateTime.Now;
                    m.update_uid = li.uid;
                    m.update_user = li.nickname;
                    //更新表头
                    dal.Update(m);
                    new UserLogDAL().AddUserLog("销售订单", "修改表头", m.so_id, m.order_number);
                }
                else
                {
                    //如果新增时单据号不为空说明是手工输入单号
                    if (!order_number.Equals(""))
                    {
                        if (dal.CheckExist(order_number))
                        {
                            return "单据号：" + order_number + "已存在！";
                        }
                    }

                    try
                    {
                        //新增表头
                        dal.Add(m);
                    }
                    catch (Exception err)
                    {
                        return err.Message;
                    }
                    //得到新增保存后的最大ID号
                    int MaxID = dal.GetMaxID();
                    so_id = MaxID.ToString();
                    m = dal.Get(MaxID);
                    //如果流水号为空代表是系统自动流水
                    if (order_number.Equals(""))
                    {
                        //根据规则生成流水号
                        Hashtable ht_num = new Hashtable();
                        if (m.customer != null)
                            ht_num.Add("[cus_code]", m.customer.cus_code);
                        if (m.department != null)
                            ht_num.Add("[dep_code]", m.department.dep_code);
                        if (m.saletype != null)
                            ht_num.Add("[st_code]", m.saletype.st_code);
                        if (m.employee != null)
                            ht_num.Add("[ele_code]", m.employee.ele_code);
                        string running_number = new RunningNumberRuleDAL().GetModuleRunningNumber("Sale_SalesOrder", ht_num);
                        m.order_number = running_number;
                        //更新实体
                        dal.Update(m);
                    }
                    new UserLogDAL().AddUserLog("销售订单", "新增单据", m.so_id, m.order_number);
                }
                //提交事务
                scope.Complete();
            }//end of trans
        }
        catch (Exception e)
        {
            return e.Message+e.InnerException;
        }
        return "success|" + so_id;
    }

    /// <summary>
    /// 删单
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string Delete(string ids)
    {
        string prev_id = "";
        SalesOrderDAL dal = new SalesOrderDAL();
        string sql = "select distinct so_id from Sale_SalesOrder where so_id in (" + ids + ")";
        using (SqlDataReader reader = new SqlUtil().GetDataReader(sql, null))
        {
            while (reader.Read())
            {
                int id = reader.GetInt32(0);
                SalesOrder so = dal.Get(id);
                if (so.verify_uid != null)
                {
                    return "单据:" + so.order_number + "已审核不允许删单!";
                }
                if (new CloseMonthDAL().CheckIsCloseMonth(Convert.ToDateTime(so.new_date)))
                {
                    return "操作月份已业务结账,不允许修改!";
                }
                prev_id = GetPrevNextID(id, "1");//得到上一张单据ID
                string msg = "";
                //启用事务
                using (TransactionScope scope = new TransactionScope())
                {
                    new UserLogDAL().AddUserLog("销售订单", "删除单据", so.so_id, so.order_number);
                    msg = dal.Delete(id);
                    if (!msg.Equals("success"))
                    {
                        return msg;
                    }
                    //提交事务
                    scope.Complete();
                }
            }
        }
        return "success|" + prev_id;
    }

    /// <summary>
    /// 检查
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string Check(int id, int action_type)
    {
        try
        {
            SalesOrderDAL dal = new SalesOrderDAL();
            SalesOrder m = dal.Get(id);
            if (action_type == 1)
            {
                if (m.cus_id == null)
                {
                    return "请填写客户!";
                }
                //检查必填项
                string result = dal.CheckMustInput(id);
                if (!result.Equals("success"))
                {
                    return result;
                }
            }
            return "success";
        }
        catch (Exception err)
        {
            return err.Message;
        }
    }
    
    /// <summary>
    /// 审核或弃审
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string Verify(string ids, int action_type)
    {
        SqlUtil su = new SqlUtil();
        try
        {
            SalesOrderDAL dal = new SalesOrderDAL();
            string sql = "select distinct so_id from Sale_SalesOrder where so_id in (" + ids + ")";
            if (action_type == 1)
            {
                sql += " and isnull(verify_user,'')=''";
            }
            else
            {
                sql += " and isnull(verify_user,'')!=''";
            }
            using (SqlDataReader reader = new SqlUtil().GetDataReader(sql, null))
            {
                while (reader.Read())
                {
                    int id = reader.GetInt32(0);
                    SalesOrder m = dal.Get(id);
                    if (new CloseMonthDAL().CheckIsCloseMonth(Convert.ToDateTime(m.new_date)))
                    {
                        return "操作月份已业务结账,不允许修改!";
                    }
                    LoginInfo li = new LoginInfo();
                    if (action_type == 1)
                    {
                        if (m.verify_uid != null)
                        {
                            return "不允许重复审核!";
                        }
                        if (new SalesOrdersDAL().GetOneOrder_TotalNumbers(id) == 0)
                        {
                            return "表体为空不允许审核!";
                        }
                        //审核前检查
                        string result = Check(id, action_type);
                        if (!result.Equals("success"))
                        {
                            return result;
                        }
                        m.verify_uid = li.uid;
                        m.verify_user = li.nickname;
                    }
                    else
                    {
                        if (m.verify_uid == null)
                        {
                            return "不允许重复弃审!";
                        }
                        m.verify_uid = null;
                        m.verify_user = null;
                        if (dal.CheckHasFaHuo(Convert.ToInt32(id)))
                        {
                            return "本订单已发货，不允许弃审!";
                        }
                    }
                    //启用事务
                    using (TransactionScope scope = new TransactionScope())
                    {
                        if (action_type == 1)
                        {
                            new UserLogDAL().AddUserLog("销售订单", "审核单据", m.so_id, m.order_number);
                        }
                        else
                        {
                            new UserLogDAL().AddUserLog("销售订单", "弃审单据", m.so_id, m.order_number);
                        }
                        //更新表头状态
                        dal.Update(m);
                        ModuleScriptDAL ms_dal = new ModuleScriptDAL();
                        if (action_type == 1)
                        {
                            //销售订单审核SQL脚本
                            string sql_verify = ms_dal.GetByCode("SalesOrder_Verify").script;
                            sql_verify = sql_verify.Replace("@so_id", id.ToString());
                            su.ExecuteNonQuery(sql_verify, null);
                        }
                        else
                        {
                        }
                        //提交事务
                        scope.Complete();
                    }
                }//end of while
            }//end of using
            return "success";
        }catch(Exception e){
            return e.Message;
        }
        
    }
    
    /// <summary>
    /// 上张或下张
    /// </summary>
    /// <param name="id">主表id</param>
    /// <param name="type">操作类型</param>
    /// <returns></returns>
    [WebMethod(EnableSession = true)]
    public string GetPrevNextID(int id, string type)
    {
        SalesOrderDAL dal = new SalesOrderDAL();
        return dal.GetPrevNextID(id, type).ToString();
    }
}