﻿<%@ Page Language="C#" AutoEventWireup="true" CodeFile="SalesOrder_Document.aspx.cs" Inherits="Sale_SalesOrder_SalesOrder_Document" %>
<%@ Register Src="~/Scripts/AWGridRuntime/UserControl/DocumentHeader.ascx" TagPrefix="uc1" TagName="ListHeader" %>
<!DOCTYPE html>

<html>
<head>
    <title></title>
    <uc1:ListHeader runat="server" ID="ListHeader" />
    <script type="text/javascript">
        var id = "<%=id%>";
        var action = "<%=action%>";
        //搜索
        function search_grid() {
            var fg = document.getElementById("frame_grid");
            var url = "SalesOrder_Document_Grid.aspx?id=" + id + "&action=" + action;
            fg.src = url;
        }
        //新增单据
        function add_doc() {
            window.location = "SalesOrder_Document.aspx?action=Add";
        }
        //保存单据
        function save_doc() {
            <%=xview["Script_GetInput"] %>
            ShowLoadingMask(); //显示遮罩
            $.ajax({
                type: "POST",
                contentType: "application/json",
                url: 'SalesOrder_Service.asmx/Save',
                data: "{action:'" + action + "',<%=xview["Script_SaveJSON"]%>}",
                dataType: 'json',
                success: function (result) {
                    HideLoadingMask(); //关闭遮罩
                    var arr = result.d.split("|");
                    if (arr[0] == "success") {
                        AlertOK('保存成功!');
                        if(action == "Add"){
                            action = "Update";
                            id = arr[1];
                            window.location = 'SalesOrder_Document.aspx?action=Update&id=' + id;
                        }
                        CloseDivWin(); //关闭窗口
                    } else {
                        AlertNO(arr[0]);
                    }
                }
            });
        }
        //删除单据
        function delete_doc(){
            asyncbox.confirm('确定要删除本单据吗?', '警告', function (buttonResult) {
                if (buttonResult == "ok") {
                    ShowLoadingMask(); //显示遮罩
                    $.ajax({
                        type: "POST",
                        contentType: "application/json",
                        url: 'SalesOrder_Service.asmx/Delete',
                        data: "{ids:'" + id + "'}",
                        dataType: 'json',
                        success: function (result) {
                            HideLoadingMask(); //关闭遮罩
                            var arr = result.d.split('|');
                            if(arr[0] == "success"){
                                AlertOK("删除成功！");
                                if(arr[1] != "0"){
                                    window.location = 'SalesOrder_Document.aspx?action=Update&id=' + arr[1];
                                }else{
                                    add_doc();
                                }
                            }else{
                                AlertNO(result.d);
                            }
                        }
                    });
                }
            });
        }

        //审核
        function verify_doc(action_type){
            var title = '审核';
            if(action_type==-1)
                title = '弃审';
            asyncbox.confirm('确定要' + title + '本单据吗?', '警告', function (buttonResult) {
                if (buttonResult == "ok") {
                    ShowLoadingMask(); //显示遮罩
                    $.ajax({
                        type: "POST",
                        contentType: "application/json",
                        url: 'SalesOrder_Service.asmx/Verify',
                        data: "{ids:'" + id + "',action_type:'" + action_type + "'}",
                        dataType: 'json',
                        success: function (result) {
                            HideLoadingMask(); //关闭遮罩
                            if(result.d == "success"){
                                asyncbox.success(title + '成功！', '操作成功！', function (buttonResult) {
                                    window.location.reload();
                                });
                           }else{
                                AlertNO(result.d);
                            }
                        }
                    });
                }
            });
        }
        //检查单据
        function check_doc() {
            ShowLoadingMask(); //显示遮罩
            $.ajax({
                type: "POST",
                contentType: "application/json",
                url: 'SalesOrder_Service.asmx/Check',
                data: "{id:'" + id + "',action_type:'1'}",
                dataType: 'json',
                success: function (result) {
                    HideLoadingMask(); //关闭遮罩
                    if (result.d == "success") {
                        AlertOK("检查没问题！");
                    } else {
                        AlertNO(result.d);
                    }
                }
            });
        }
        //新增行
        function add_row() {
            if(action == "Add")return;
            if(action == "Add"){
                AlertNO("请先保存表头后才进行表体数据添加！");
                return;
            }
            asyncbox.open({
                id: 'win_modify',
                url: 'SalesOrders_Edit.aspx?action=Add&id='+id,
                modal: true,
                title: '新增'
            });
            
        }
        //修改行
        function edit_row() {
            if(action == "Add")return;
            var fg = document.getElementById("frame_grid"); //得到grid控件所在iframe
            var cw = fg.contentWindow;
            var did = cw.aw_GetSelectRows(cw._sos_id); //返回一维数组
            if (did == "")
                return;
            if (did.length == 0) {
                AlertNO('请选择要查看的记录!');
                return;
            }
            if (did.length > 1) {
                AlertNO('一次只可以查看一条记录!');
                return;
            }
            asyncbox.open({
                id: 'win_modify',
                url: 'SalesOrders_Edit.aspx?action=Update&id=' + id + '&did=' + did,
                modal: true,
                title: '修改'
            });
        }
        //删除行
        function del_row(){
            if(action == "Add")return;
            var fg = document.getElementById("frame_grid"); //得到grid控件所在iframe
            var cw = fg.contentWindow;
            var ids = cw.aw_GetSelectRows(cw._sos_id); //返回一维数组
            if (ids.length == 0) {
                AlertNO('请选择要删除的记录!');
                return;
            }
            asyncbox.confirm('确定要删除该行吗?', '警告', function (buttonResult) {
                if (buttonResult == "ok") {
                    ShowLoadingMask(); //显示遮罩
                    $.ajax({
                        type: "POST",
                        contentType: "application/json",
                        url: 'SalesOrders_Service.asmx/Delete',
                        data: "{ids:'" + ids + "'}",
                        dataType: 'json',
                        success: function (result) {
                            HideLoadingMask(); //关闭遮罩
                            if(result.d != "success"){
                                AlertNO(result.d);
                                return;
                            }
                            AlertOK("删除成功!");
                            fg.src=fg.src;
                        }
                    });
                }
            });
        }
        //上张下张
        function prev_next_doc(type){
            ShowLoadingMask(); //显示遮罩
            $.ajax({
                type: "POST",
                contentType: "application/json",
                url: 'SalesOrder_Service.asmx/GetPrevNextID',
                data: "{id:'" + id + "',type:'" + type + "'}",
                dataType: 'json',
                success: function (result) {
                    HideLoadingMask(); //关闭遮罩
                    if(result.d==0){
                        AlertNO("不能再翻了！");
                        return;
                    }
                    window.location = 'SalesOrder_Document.aspx?action=Update&id=' + result.d;
                }
            });
        }

        //禁用按钮
        function disable_button(){
            if(action == "Add"){
                $('#btn_delete_doc').linkbutton('disable');
                $('#btn_save_doc').linkbutton('enable');
                $('#btn_check_doc').linkbutton('disable');
                $('#btn_verify_doc').linkbutton('disable');
                $('#btn_add_row').linkbutton('disable');
                $('#btn_del_row').linkbutton('disable');
                $('#btn_prev_doc').linkbutton('enable');
                $('#btn_next_doc').linkbutton('enable');
                $('#btn_print').linkbutton('disable');
                $('#m_trace').menubutton('disable');
                
            }else{
                $('#btn_delete_doc').linkbutton('enable');
                $('#btn_save_doc').linkbutton('enable');
                $('#btn_verify_doc').linkbutton('enable');
                $('#btn_add_row').linkbutton('enable');
                $('#btn_del_row').linkbutton('enable');
                $('#btn_prev_doc').linkbutton('enable');
                $('#btn_next_doc').linkbutton('enable');
                $('#btn_print').linkbutton('enable');
                $('#m_trace').menubutton('enable');
                if(b_verify){
                    //禁止所有文本框进行输入
                    disable_all_input();
                    $('#btn_add_row').linkbutton('disable');
                    $('#btn_del_row').linkbutton('disable');
                    $('#btn_delete_doc').linkbutton('disable');
                    $('#btn_save_doc').linkbutton('disable');
                }
            }
            
        }
        //找单
        function find_doc(){
            var url = '../../Sale/Report/SalesOrder_Details.aspx';
            var tab_id = 'Sale_Report_SalesOrder_Details';
            top.OpenWindow('Activate', tab_id, '销售订单明细表', url);
        }
        //打印表头用的SQL
        var sql_print_main_session_id = "<%=xview["sql_print_main_session_id"]%>";
        //选择打印模板
        function grf_print(){
            var fg = document.getElementById("frame_grid"); //得到grid控件所在iframe
            var cw = fg.contentWindow;
            choice_print_template('<%=xview["auth_code"]%>',sql_print_main_session_id,cw.sql_print_detail_session_id);
        }
        //联查-发货单
        function trace_delivery_order(){
            var url = '../../Sale/Report/DeliveryOrder_Details.aspx?so_id=' + id;
            top.OpenWindow('Activate', 'Sale_Report_DeliveryOrder_Details' + id, '联查-发货单', url);
        }
    </script>
</head>
<body onload="search_grid();">
    <!--工具栏-->
    <div style="height:30px;" class="list_menu_bar" id="list_menu_bar">
        <a plain="true" class="easyui-linkbutton" onClick="add_doc()" id="btn_add_doc" style='<%=auth.AuthView("Sale_SalesOrder_Edit")%>'>新增</a>
        <a plain="true" class="easyui-linkbutton" onClick="delete_doc()" id="btn_delete_doc" style='<%=auth.AuthView("Sale_SalesOrder_Delete")%>'>删单</a>
        <a plain="true" class="easyui-linkbutton" onClick="save_doc()" id="btn_save_doc" style='color:Green;<%=auth.AuthView("Sale_SalesOrder_Edit")%>'>保存</a>
        <a plain="true" class="easyui-linkbutton" onClick="check_doc()" id="btn_check_doc">检查</a>
        <a plain="true" class="easyui-linkbutton" onClick="verify_doc(1)" id="btn_verify_doc" style='<%=auth.AuthView("Sale_SalesOrder_Verify")%>'>审核</a>
        <a plain="true" class="easyui-linkbutton" onClick="verify_doc(-1)" id="btn_unverify_doc" style='<%=auth.AuthView("Sale_SalesOrder_CancelVerify")%>'>弃审</a>
        <a plain="true" class="easyui-linkbutton" onClick="add_row()" id="btn_add_row" style='color:Green;<%=auth.AuthView("Sale_SalesOrder_Edit")%>'>增行</a>
        <a plain="true" class="easyui-linkbutton" onClick="del_row()" id="btn_del_row" style='<%=auth.AuthView("Sale_SalesOrder_Edit")%>'>删行</a>
        <a plain="true" class="easyui-linkbutton" onClick="search_grid()" id="btn_reflesh">刷新</a>
        <a plain="true" class="easyui-linkbutton" onClick="find_doc()" id="btn_find_doc">找单</a>
        <a plain="true" class="easyui-linkbutton" id="btn_prev_doc" onclick='prev_next_doc(1)'>上张</a>
        <a plain="true" class="easyui-linkbutton" id="btn_next_doc" onclick='prev_next_doc(2)'>下张</a>
        <a plain="true" class="easyui-linkbutton" id="btn_print" onclick='grf_print()' style='<%=auth.AuthView("Sale_SalesOrder_Print")%>'>打印</a>
        <a plain="true" id="m_trace" class="easyui-menubutton" menu="#menu_trace">联查</a>
        <a plain="true" id="m_format" class="easyui-menubutton" menu="#menu_format" style='<%=auth.FormatView()%>'>格式</a>
    </div>
    <!--表头-->
    <div id="doc_head">
        <div id="doc_caption">销售订单</div>
        <%=xview["input_ui"]%>
    </div>
    <!--表体-->
    <%=xview["grid_frame"]%>
    <!--页脚-->
    <div id="doc_footer">
    </div>

    <!--格式定义下拉菜单-->
    <div id="menu_format" style="width:150px;">
        <div onclick="DesignModuleFormat('Sale_SalesOrder_Header')">表头</div>
        <div onclick="DesignModuleFormat('Sale_SalesOrders_Input')">明细</div>
	</div>
    <!--联查菜单-->
    <div id="menu_trace" style="width:150px;">
        <div onclick="trace_delivery_order()">发货单</div>
	</div>
    <script type="text/javascript">
        var b_verify = false;//是否审核
        //初始化页面
        function init_page() {
            FastSearch_Customer(); //查询客户
            FastSearch_Currency(); //查询币种
            FastSearch_Department(); //查询部门
            FastSearch_SaleType(); //销售类型
            FastSearch_ShipWay(); //运输方式
            FastSearch_Employee(); //业务员
            //选择自定义项档案
            <%for(int i=1;i<=5;i++){ %>
                $F("trigger_sdefine<%=i%>").onclick = function () {
                    AdvancedSearch_DefineItem($("#sdefine<%=i%>").val(),'SalesOrder_sdefine<%=i%>','sdefine<%=i%>');
                };
            <%}
              for(int i=1;i<=5;i++){ %>
                $F("trigger_ndefine<%=i%>").onclick = function () {
                    AdvancedSearch_DefineItem($("#ndefine<%=i%>").val(),'SalesOrder_ndefine<%=i%>','ndefine<%=i%>');
                };
            <%} %>
            <%if(action.Equals("Update")){ %>
                $F("dep_name").value = '<%=m.department==null?"":m.department.dep_name%>';
                $F("cus_name").value = '<%=m.customer==null?"":m.customer.cus_name%>';
                $F("crc_name").value = '<%=m.currency==null?"":m.currency.crc_name%>';
                $F("st_name").value = '<%=m.saletype==null?"":m.saletype.st_name%>';
                $F("ele_name").value = '<%=m.employee==null?"":m.employee.ele_name%>';
                $F("sw_name").value = '<%=m.ship_way==null?"":m.ship_way.sw_name%>';
                <%if(m.customer != null){%>
                    $F("cus_sdefine1").value = '<%=m.customer.sdefine1%>';//客户字符自定义项1
                    $F("cus_sdefine2").value = '<%=m.customer.sdefine2%>';//客户字符自定义项2
                    $F("cus_sdefine3").value = '<%=m.customer.sdefine3%>';//客户字符自定义项3
                    $F("cus_sdefine4").value = '<%=m.customer.sdefine4%>';//客户字符自定义项4
                    $F("cus_sdefine5").value = '<%=m.customer.sdefine5%>';//客户字符自定义项5

                    $F("cus_ndefine1").value = '<%=m.customer.ndefine1%>';//客户数值自定义项1
                    $F("cus_ndefine2").value = '<%=m.customer.ndefine2%>';//客户数值自定义项2
                    $F("cus_ndefine3").value = '<%=m.customer.ndefine3%>';//客户数值自定义项3
                    $F("cus_ndefine4").value = '<%=m.customer.ndefine4%>';//客户数值自定义项4
                    $F("cus_ndefine5").value = '<%=m.customer.ndefine5%>';//客户数值自定义项5
                <%}%>
                var verify_uid = '<%=m.verify_uid%>';
                if(verify_uid != ''){
                    b_verify = true;
                    $F("btn_verify_doc").style.display = 'none';
                }else{
                    $F("btn_unverify_doc").style.display = 'none';
                }
            <%}else{ %>
                $F("new_date").value = '<%=xview["login_date"]%>';
                $F("crc_id").value = '<%=currency==null?0:currency.crc_id%>';
                $F("crc_name").value = '<%=currency==null?"":currency.crc_name%>';
                $F("exchange_rate").value = '<%=currency==null?"":xview["exchange_rate"]%>'; 
                $F("st_id").value = '<%=saletype==null?0:saletype.st_id%>';
                $F("st_name").value = '<%=saletype==null?"":saletype.st_name%>';
                $F("sw_id").value = '<%=ship_way==null?0:ship_way.sw_id%>';
                $F("sw_name").value = '<%=ship_way==null?"":ship_way.sw_name%>';
                $F("btn_unverify_doc").style.display = 'none';
                
            <%} %>
            disable_button();
        }
        //页面JS脚本
        <%=xview["SalesOrder_Main_JavaScript"]%>

        //页面加载完毕事件
        $(document).ready(function () {
            init_page();
        });

        //通过主键_获取客户
        function SearchService_Customer(cus_id) {
            $.ajax({
                type: "POST",
                contentType: "application/json",
                url: '../../Base/Customer/Customer_Service.asmx/Get',
                data: "{cus_id:'" + cus_id + "'}",
                dataType: 'json',
                success: function (result) {
                    $("#cus_id").val(result.d.cus_id);
                    $("#cus_name").val(result.d.cus_name);
                    $("#phone").val(result.d.phone);
                    $("#contact").val(result.d.contact);
                    $("#ship_address").val(result.d.ship_address);
                    if (result.d.employee != null) {
                        $("#ele_id").val(result.d.ele_id);
                        $("#ele_name").val(result.d.employee.ele_name);
                        $("#dep_id").val(result.d.employee.dep_id);
                        $("#dep_name").val(result.d.employee.department.dep_name);
                    }
                }
            });
        }
        //通过主键_获取员工
        function SearchService_Employee(ele_id) {
            $.ajax({
                type: "POST",
                contentType: "application/json",
                url: '../../Base/Employee/Employee_Service.asmx/Get',
                data: "{ele_id:'" + ele_id + "'}",
                dataType: 'json',
                success: function (result) {
                    $("#ele_id").val(result.d.ele_id);
                    $("#ele_name").val(result.d.ele_name);
                    $("#dep_id").val(result.d.dep_id);
                    $("#dep_name").val(result.d.department.dep_name);
                }
            });
        }
    </script>
</body>
</html>
