﻿<%@ WebService Language="C#" Class="GoodsCombos_Service" %>

using System;
using System.Web;
using System.Web.Services;
using System.Web.Services.Protocols;
using SysCore;
//using SysCore.Model;
//using SysCore.DAL;

[WebService(Namespace = "http://tempuri.org/")]
[WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1)]
// 若要允许使用 ASP.NET AJAX 从脚本中调用此 Web 服务，请取消注释以下行。 
[System.Web.Script.Services.ScriptService]
public class GoodsCombos_Service  : System.Web.Services.WebService {
    
    /// <summary>
    /// 删除
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string Delete(string ids)
    {
        GoodsCombosDAL dal = new GoodsCombosDAL();
        foreach (string id in ids.Split(','))
        {
            if(id.Equals(""))
                continue;
            try
            {
                dal.Delete(Convert.ToInt32(id));
            }
            catch (Exception e)
            {
                return "删除失败，套餐可能已被使用！";
                //return e.Message;
            }
        }
        return "success";
    }

    /// <summary>
    /// 修改
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string Save(string action, string gc_id, string gcs_id, 
        string i_id, string free1, string free2, string i_code, string i_name,
        string standard,string munit,string aunit,string tax_unit_price,
        string quantity,string num,string convert_rate,string tax_total_price,
        string is_main, string d_remark)
    {
        if (string.IsNullOrWhiteSpace(i_id) || i_id.Equals("0"))
        {
            return "请输入存货！";
        }
        if (string.IsNullOrWhiteSpace(quantity) || quantity.Equals("0"))
        {
            return "数量不可为空或零！";
        }
        try
        {
            GoodsCombosDAL dal = new GoodsCombosDAL();

            GoodsCombos m = new GoodsCombos();
            if (action.Equals("Update"))
            {
                m = dal.Get(Convert.ToInt32(gcs_id));
            }
            m.gc_id = Convert.ToInt32(gc_id);
            m.is_main = XTools.ObjectNullToInt(is_main);
            m.i_id = Convert.ToInt32(i_id);
            free1 = free1.Trim(); 
            free2 = free2.Trim();
            Inventory inv = new InventoryDAL().Get(Convert.ToInt32(i_id));
            if (!free1.Equals("") && inv.on_free1 == 0)
                return "存货不允许输入自由项1！";
            if (!free2.Equals("") && inv.on_free2 == 0)
                return "存货不允许输入自由项2！";
            if (free1.Equals("") && inv.on_free1 == 1)
                return "存货必须输入自由项1！";
            if (free2.Equals("") && inv.on_free2 == 1)
                return "存货必须输入自由项2！";
            m.free1 = free1;
            m.free2 = free2;
            if (inv.aunit.Equals("") && !num.Equals(""))
                return "未启用辅计量单位，启不要输入件数！";
            if (!inv.aunit.Equals(""))
            {
                if (num.Equals("") || num.Equals("0"))
                {
                    return "存货启用了辅计量单位，必须输入件数！";
                }
                if (convert_rate.Equals("") || convert_rate.Equals("0"))
                {
                    return "存货启用了辅计量单位，必须输入换算率！";
                }
            }
            m.tax_unit_price = XTools.ObjectNullToDecimal(tax_unit_price);
            m.quantity = XTools.ObjectNullToDecimal(quantity);
            m.num = XTools.ObjectNullToDecimal(num);
            m.convert_rate = XTools.ObjectNullToDecimal(convert_rate);
            m.tax_total_price = XTools.ObjectNullToDecimal(tax_total_price);
            m.d_remark = d_remark;
            if (action.Equals("Update"))
            {
                dal.Update(m);
                if (m.is_main == 1)
                {
                    dal.UpdateIsMainOnlyOne(m.gc_id, m.gcs_id);//更新其它记录为非主商品
                }
            }
            else
            {
                //如果首次新增表体，让第一条记录为主商品
                if(dal.GetOneOrder_TotalNumbers(m.gc_id)==0)
                {
                    m.is_main = 1;
                }
                //新增保存
                dal.Add(m);
                if (m.is_main == 1)
                {
                    m.gcs_id = dal.GetMaxID(m.gc_id);//得到新增后的最大子表id
                    dal.UpdateIsMainOnlyOne(m.gc_id, m.gcs_id);//更新其它记录为非主商品
                }
            }

        }
        catch (Exception e)
        {
            return e.Message;
        }
        return "success";
    }
    /// <summary>
    /// 获取
    /// </summary>
    [WebMethod(EnableSession = true)]
    public GoodsCombos Get(string gcs_id)
    {
        GoodsCombosDAL dal = new GoodsCombosDAL();
        return dal.Get(Convert.ToInt32(gcs_id));
    }
}