﻿<%@ WebService Language="C#" Class="GoodsCombo_Service" %>

using System;
using System.Web;
using System.Web.Services;
using System.Web.Services.Protocols;
using System.Collections;
using System.Transactions;
using System.Data;
using System.Data.SqlClient;
using SysCore;
using SysCore.DAL;
using SysCore.Model;

[WebService(Namespace = "http://tempuri.org/")]
[WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1)]
// 若要允许使用 ASP.NET AJAX 从脚本中调用此 Web 服务，请取消注释以下行。 
[System.Web.Script.Services.ScriptService]
public class GoodsCombo_Service  : System.Web.Services.WebService {
    /// <summary>
    /// 保存单据
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string Save(string action, string gc_id, string order_number, string gc_name,
        string begin_date, string end_date, string wh_id, string wh_name, string is_stop, string remark)
    {
        if (wh_name.Equals("")) wh_id = "";

        if (string.IsNullOrWhiteSpace(begin_date))
        {
            return "开始日期不可为空！";
        }
        if (string.IsNullOrWhiteSpace(end_date))
        {
            return "结束日期不可为空！";
        }
        try
        {
            GoodsComboDAL dal = new GoodsComboDAL();
            GoodsCombo m = new GoodsCombo();
            LoginInfo li = new LoginInfo();
            if (action.Equals("Update"))
            {
                m = dal.Get(Convert.ToInt32(gc_id));
                if (m.verify_uid != null)
                {
                    return "已审核不允许改单";
                }
                if (string.IsNullOrWhiteSpace(order_number))
                {
                    return "套餐编号不可为空！";
                }
                if (!m.order_number.Equals(order_number))
                {
                    if (dal.CheckExist(order_number))
                    {
                        return "您修改了套餐编号，然而套餐编号：" + order_number + "已存在，请尝试别的号码！";
                    }
                }
            }
            try
            {
                m.begin_date = Convert.ToDateTime(begin_date);
                m.end_date = Convert.ToDateTime(end_date);
                m.order_number = order_number;
                m.gc_name = gc_name;
                m.is_stop = XTools.ObjectNullToInt(is_stop);
                m.wh_id = XTools.ObjectNullToInt(wh_id); 
                m.remark = remark.ToString();
            }
            catch (Exception err)
            {
                return err.Message;
            }
            if (action.Equals("Update"))
            {
                //启用事务
                using (TransactionScope scope = new TransactionScope())
                {
                    //更新表头
                    dal.Update(m);
                    new UserLogDAL().AddUserLog("促销套餐", "修改表头", m.gc_id, m.order_number);
                    //提交事务
                    scope.Complete();
                }
            }
            else
            {
                //如果新增时单据号不为空说明是手工输入单号
                if (!order_number.Equals(""))
                {
                    if (dal.CheckExist(order_number))
                    {
                        return "套餐编号：" + order_number + "已存在！";
                    }
                }
               
                //启用事务
                using (TransactionScope scope = new TransactionScope())
                {
                    try
                    {
                        //新增表头
                        dal.Add(m);
                    }
                    catch (Exception err)
                    {
                        return err.Message;
                    } 
                    //return "f";
                    //得到新增保存后的最大ID号
                    int MaxID = dal.GetMaxID();
                    gc_id = MaxID.ToString();
                    m = dal.Get(MaxID);
                    //如果流水号为空代表是系统自动流水
                    if (order_number.Equals(""))
                    {
                        //更新实体
                        try
                        {
                            //根据规则生成流水号
                            Hashtable ht_num = new Hashtable();
                            string running_number = new RunningNumberRuleDAL().GetModuleRunningNumber("Sale_GoodsCombo", ht_num);
                            if(running_number.LastIndexOf("[") > -1)
                                return "自动生成流水号出错,请检查必填项目!";
                            m.order_number = running_number;
                            //更新实体
                            dal.Update(m);
                            new UserLogDAL().AddUserLog("促销套餐", "新增单据", m.gc_id, m.order_number);
                        }
                        catch
                        {
                            return "自动生成流水号出错!";
                        }
                    }
                    //提交事务
                    scope.Complete();
                }
            }
        }
        catch (Exception e)
        {
            return e.Message;
        }
        return "success|" + gc_id;
    }

    /// <summary>
    /// 删单
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string Delete(string ids)
    {
        string prev_id = "";
        try
        {
            GoodsComboDAL dal = new GoodsComboDAL();
            string sql = "select distinct gc_id from Sale_GoodsCombo where gc_id in (" + ids + ")";
            using(SqlDataReader reader = new SqlUtil().GetDataReader(sql, null))
            {
                while (reader.Read())
                {
                    int id = reader.GetInt32(0);
                    GoodsCombo m = dal.Get(id);
                    if (m.verify_uid != null)
                    {
                        return "单据:" + m.order_number + "已审核不允许删单!";
                    }
                    prev_id = GetPrevNextID(id, "1");//得到上一张单据ID
                    string msg = "";
                    //启用事务
                    using (TransactionScope scope = new TransactionScope())
                    {
                        new UserLogDAL().AddUserLog("发货单", "删除单据", m.gc_id, m.order_number);
                        msg = dal.Delete(id);
                        if (!msg.Equals("success"))
                        {
                            return msg;
                        }
                        //提交事务
                        scope.Complete();
                    }
                }//end of reader
            }//end of using
            return "success|" + prev_id;
        }
        catch (Exception err)
        {
            return "删除失败，套餐可能已被使用，您可以对套餐进行停用！";
            //return err.Message;
        }
        
    }

    /// <summary>
    /// 检查
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string Check(int id, int action_type)
    {
        try
        {
            GoodsComboDAL dal = new GoodsComboDAL();
            GoodsCombo m = dal.Get(id);
            //检查必填项
            string result = dal.CheckMustInput(id);
            if (!result.Equals("success"))
            {
                return result;
            }
            if (dal.CheckOrderHasIsMain(id) == false)
            {
                return "餐套必须要设置一个主商品！";
            }

            return "success";
        }
        catch (Exception err)
        {
            return err.Message;
        }
    }
    /// <summary>
    /// 审核或弃审
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string Verify(string ids, int action_type)
    {
        SqlUtil su = new SqlUtil();
        try
        {
            GoodsComboDAL dal = new GoodsComboDAL();
            string sql = "select distinct gc_id from Sale_GoodsCombo where gc_id in (" + ids + ")";
            if (action_type == 1)
            {
                sql += " and isnull(verify_user,'')=''";
            }
            else
            {
                sql += " and isnull(verify_user,'')!=''";
            }
            //值为1代表发货单审核自动生成出库单
            string sale_fahuo_verify_salesout = new ConfigReader().GetConfig("sale_fahuo_verify_salesout");
            using(SqlDataReader reader = new SqlUtil().GetDataReader(sql, null))
            {
                while (reader.Read())
                {
                    int id = reader.GetInt32(0);
                    GoodsCombo m = dal.Get(id);
                    LoginInfo li = new LoginInfo();
                    if (action_type == 1)
                    {
                        if (m.verify_uid != null)
                        {
                            return "不允许重复审核";
                        }
                        if (new GoodsCombosDAL().GetOneOrder_TotalNumbers(id) == 0)
                        {
                            return "表体为空不允许审核!";
                        }
                        m.verify_uid = li.uid;
                        m.verify_user = li.nickname;
                        //审核前检查
                        string result = Check(id, action_type);
                        if (!result.Equals("success"))
                        {
                            return result;
                        }
                    }
                    else
                    {
                        if (m.verify_uid == null)
                        {
                            return "不允许重复弃审";
                        }
                        m.verify_uid = null;
                        m.verify_user = null;
                    }
                    //启用事务
                    using (TransactionScope scope = new TransactionScope())
                    {
                        //更新实体
                        dal.Update(m);
                        //更新表头套餐描述
                        dal.UpdateInfo(m.gc_id);
                        if (action_type == 1)
                        {
                            new UserLogDAL().AddUserLog("促销套餐", "审核单据", m.gc_id, m.order_number);
                        }
                        else
                        {
                            new UserLogDAL().AddUserLog("促销套餐", "弃审单据", m.gc_id, m.order_number);
                        }
                        //提交事务
                        scope.Complete();
                    }//end of trans
                }//end of while
            }//end of reader
            return "success";
        }//end of try
        catch (Exception e)
        {
            return e.Message;
        }
    }
    
    /// <summary>
    /// 上张或下张
    /// </summary>
    /// <param name="id">主表id</param>
    /// <param name="type">操作类型</param>
    /// <returns></returns>
    [WebMethod(EnableSession = true)]
    public string GetPrevNextID(int id, string type)
    {
        GoodsComboDAL dal = new GoodsComboDAL();
        return dal.GetPrevNextID(id, type).ToString();
    }
}