﻿<%@ WebService Language="C#" Class="DeliveryOrders_Service" %>

using System;
using System.Web;
using System.Web.Services;
using System.Web.Services.Protocols;
using SysCore;
//using SysCore.Model;
//using SysCore.DAL;

[WebService(Namespace = "http://tempuri.org/")]
[WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1)]
// 若要允许使用 ASP.NET AJAX 从脚本中调用此 Web 服务，请取消注释以下行。 
[System.Web.Script.Services.ScriptService]
public class DeliveryOrders_Service  : System.Web.Services.WebService {
    
    /// <summary>
    /// 删除
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string Delete(string ids)
    {
        DeliveryOrdersDAL dal = new DeliveryOrdersDAL();
        foreach (string id in ids.Split(','))
        {
            try
            {
                if (id.Equals(""))
                    continue;
                dal.Delete(Convert.ToInt32(id));
            }
            catch (Exception e)
            {
                return e.Message;
            }
        }
        return "success";
    }

    /// <summary>
    /// 修改
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string Save(string action, string do_id, string dos_id, string sos_id, 
        string d_wh_id, string d_wh_name, string i_id, string free1, string free2, string batch, string i_code, string i_name,
        string standard,string munit,string aunit,string unit_price,string tax_unit_price,
        string quantity,string num,string convert_rate,string total_price,string tax_total_price,string tax,
        string nat_unit_price, string nat_total_price,string nat_tax_unit_price, string nat_tax_total_price, string nat_tax,
        string d_tax_rate, string delivery_date, string d_remark,
        string quoted_price, string kl, string zk, 
        string d_sdefine1, string d_sdefine2, string d_sdefine3, string d_sdefine4, string d_sdefine5,
        string d_ndefine1, string d_ndefine2, string d_ndefine3, string d_ndefine4, string d_ndefine5)
    {
        if (string.IsNullOrWhiteSpace(i_id) || i_id.Equals("0"))
        {
            return "请输入存货！";
        }
        if (string.IsNullOrWhiteSpace(quantity) || quantity.Equals("0"))
        {
            return "数量不可为空或零！";
        }
        try
        {
            DeliveryOrdersDAL dal = new DeliveryOrdersDAL();

            DeliveryOrders m = new DeliveryOrders();
            if (action.Equals("Update"))
            {
                m = dal.Get(Convert.ToInt32(dos_id));
            }
            m.sos_id = XTools.ObjectNullToInt(sos_id);
            m.do_id = Convert.ToInt32(do_id);
            m.d_wh_id = XTools.ObjectNullToInt(d_wh_id);
            m.i_id = Convert.ToInt32(i_id);
            free1 = free1.Trim(); 
            free2 = free2.Trim();
            Inventory inv = new InventoryDAL().Get(Convert.ToInt32(i_id));
            //劳务费用不需要填仓库
            if (inv.is_service == 0)
            {
                if (d_wh_id.Equals("") || d_wh_id.Equals("0"))
                {
                    return "仓库不能为空！";
                }
            }
            if (!free1.Equals("") && inv.on_free1 == 0)
                return "存货不允许输入自由项1！";
            if (!free2.Equals("") && inv.on_free2 == 0)
                return "存货不允许输入自由项2！";
            if (free1.Equals("") && inv.on_free1 == 1)
                return "存货必须输入自由项1！";
            if (free2.Equals("") && inv.on_free2 == 1)
                return "存货必须输入自由项2！";
            m.free1 = free1;
            m.free2 = free2;
            if (!batch.Equals("") && inv.on_batch == 0)
                return "存货不允许输入批次！";
            if (batch.Equals("") && inv.on_batch == 1)
                return "存货必须输入批次！";
            if (inv.aunit.Equals("") && !num.Equals(""))
                return "未启用辅计量单位，启不要输入件数！";
            if (!inv.aunit.Equals(""))
            {
                if (num.Equals("") || num.Equals("0"))
                {
                    return "存货启用了辅计量单位，必须输入件数！";
                }
                if (convert_rate.Equals("") || convert_rate.Equals("0"))
                {
                    return "存货启用了辅计量单位，必须输入换算率！";
                }
            }
            m.batch = batch;
            m.unit_price = XTools.ObjectNullToDecimal(unit_price);
            m.tax_unit_price = XTools.ObjectNullToDecimal(tax_unit_price);
            m.quantity = XTools.ObjectNullToDecimal(quantity);
            m.num = XTools.ObjectNullToDecimal(num);
            m.convert_rate = XTools.ObjectNullToDecimal(convert_rate);
            m.total_price = XTools.ObjectNullToDecimal(total_price);
            m.tax_total_price = XTools.ObjectNullToDecimal(tax_total_price);
            m.tax = XTools.ObjectNullToDecimal(tax);
            m.nat_unit_price = XTools.ObjectNullToDecimal(nat_unit_price);
            m.nat_total_price = XTools.ObjectNullToDecimal(nat_total_price);
            m.nat_tax_unit_price = XTools.ObjectNullToDecimal(nat_tax_unit_price);
            m.nat_tax_total_price = XTools.ObjectNullToDecimal(nat_tax_total_price);
            m.nat_tax = XTools.ObjectNullToDecimal(nat_tax);
            m.d_tax_rate = XTools.ObjectNullToDecimal(d_tax_rate);
            m.quoted_price = XTools.ObjectNullToDecimal(quoted_price);
            m.kl = XTools.ObjectNullToDecimal(kl);
            m.zk = XTools.ObjectNullToDecimal(zk);
            m.delivery_date = XTools.ObjectNullToDateTime(delivery_date);
            m.d_remark = d_remark;
            m.d_sdefine1 = d_sdefine1;
            m.d_sdefine2 = d_sdefine2;
            m.d_sdefine3 = d_sdefine3;
            m.d_sdefine4 = d_sdefine4;
            m.d_sdefine5 = d_sdefine5;
            m.d_ndefine1 = XTools.ObjectNullToDecimal(d_ndefine1);
            m.d_ndefine2 = XTools.ObjectNullToDecimal(d_ndefine2);
            m.d_ndefine3 = XTools.ObjectNullToDecimal(d_ndefine3);
            m.d_ndefine4 = XTools.ObjectNullToDecimal(d_ndefine4);
            m.d_ndefine5 = XTools.ObjectNullToDecimal(d_ndefine5);
            if (action.Equals("Update"))
            {
                dal.Update(m);
            }
            else
            {
                dal.Add(m);
            }
        }
        catch (Exception e)
        {
            return e.Message;
        }
        return "success";
    }
 
    /// <summary>
    /// 订单多选
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string MultiSelect(string do_id, string ids)
    {
        try
        {
            DeliveryOrderDAL tdal = new DeliveryOrderDAL();
            DeliveryOrder t = tdal.Get(Convert.ToInt32(do_id));
            string[] arr = ids.Split(',');
            SalesOrdersDAL sdal = new SalesOrdersDAL();
            DeliveryOrdersDAL dos_dal = new DeliveryOrdersDAL();
            int total_numbers = dos_dal.GetOneOrder_TotalNumbers(Convert.ToInt32(do_id));
            bool has_get_from = false;//是否有从订单取数到表头
            for (int i = 0; i < arr.Length; i++)
            {
                int sos_id = Convert.ToInt32(arr[i]);
                SalesOrders sos = sdal.Get(sos_id);
                DeliveryOrders m = new DeliveryOrders();
                m.do_id = Convert.ToInt32(do_id);
                m.d_wh_id = t.wh_id;
                m.sos_id = sos.sos_id;
                m.i_id = sos.i_id;
                m.free1 = sos.free1;
                m.free2 = sos.free2;
                m.batch = null;
                m.unit_price = sos.nat_unit_price;
                m.tax_unit_price = sos.nat_tax_unit_price;
                m.d_tax_rate = sos.d_tax_rate;
                decimal? wait_fh_quan = sos.quantity - XTools.DecimalNullToZero(sos.acc_fh_quantity);
                decimal? wait_fh_num = XTools.DecimalNullToZero(sos.num) - XTools.DecimalNullToZero(sos.acc_fh_num);

                m.quantity = wait_fh_quan;
                if (!sos.inventory.aunit.Equals(""))
                {
                    m.num = wait_fh_num;
                    m.convert_rate = sos.convert_rate;
                }
                m.total_price = Math.Round((decimal)(XTools.DecimalNullToZero(m.unit_price) * wait_fh_quan), 2);
                m.tax_total_price = Math.Round((decimal)(XTools.DecimalNullToZero(m.tax_unit_price) * wait_fh_quan), 2);
                m.tax = XTools.DecimalNullToZero(m.tax_total_price) - XTools.DecimalNullToZero(m.total_price);

                m.nat_unit_price = sos.nat_unit_price;
                m.nat_tax_unit_price = sos.nat_tax_unit_price;

                m.nat_total_price = Math.Round((decimal)(XTools.DecimalNullToZero(m.total_price) * t.exchange_rate), 2);
                m.nat_tax_total_price = Math.Round((decimal)(XTools.DecimalNullToZero(m.tax_total_price) * t.exchange_rate), 2);
                m.nat_tax = XTools.DecimalNullToZero(m.nat_tax_total_price) - XTools.DecimalNullToZero(m.nat_total_price);
                
                m.d_sdefine1 = sos.d_sdefine1;
                m.d_sdefine2 = sos.d_sdefine2;
                m.d_sdefine3 = sos.d_sdefine3;
                m.d_sdefine4 = sos.d_sdefine4;
                m.d_sdefine5 = sos.d_sdefine5;
                m.d_ndefine1 = sos.d_ndefine1;
                m.d_ndefine2 = sos.d_ndefine2;
                m.d_ndefine3 = sos.d_ndefine3;
                m.d_ndefine4 = sos.d_ndefine4;
                m.d_ndefine5 = sos.d_ndefine5;
                dos_dal.Add(m);
                //如果还没从订单取数到表头
                if (!has_get_from)
                {
                    //如果表体为零行，代表新增第一条记录，则默认从订单带出相关表头项
                    if (total_numbers == 0)
                    {
                        SalesOrderDAL dal = new SalesOrderDAL();
                        SalesOrder so = dal.Get(sos.so_id);
                        t.cus_id = so.cus_id;
                        t.dep_id = so.dep_id;
                        t.st_id = so.st_id;
                        t.ele_id = so.ele_id;
                        t.sw_id = so.sw_id;
                        t.tax_rate = so.tax_rate;
                        t.exchange_rate = so.exchange_rate;
                        t.crc_id = so.crc_id;
                        t.contact = so.contact;
                        t.ship_address = so.ship_address;
                        t.phone = so.phone;
                        t.remark = so.remark;
                        t.sdefine1 = so.sdefine1;
                        t.sdefine2 = so.sdefine2;
                        t.sdefine3 = so.sdefine3;
                        t.sdefine4 = so.sdefine4;
                        t.sdefine5 = so.sdefine5;
                        t.ndefine1 = so.ndefine1;
                        t.ndefine2 = so.ndefine2;
                        t.ndefine3 = so.ndefine3;
                        t.ndefine4 = so.ndefine4;
                        t.ndefine5 = so.ndefine5;
                        tdal.Update(t);
                    }
                    has_get_from = true;
                }
                
            }
        }
        catch (Exception err)
        {
            return err.Message;
        }
        return "success";
    }

    /// <summary>
    /// 获取
    /// </summary>
    [WebMethod(EnableSession = true)]
    public DeliveryOrders Get(string dos_id)
    {
        DeliveryOrdersDAL dal = new DeliveryOrdersDAL();
        return dal.Get(Convert.ToInt32(dos_id));
    }
}