﻿<%@ WebService Language="C#" Class="DeliveryOrder_Service" %>

using System;
using System.Web;
using System.Web.Services;
using System.Web.Services.Protocols;
using System.Collections;
using System.Transactions;
using System.Data;
using System.Data.SqlClient;
using SysCore;
using SysCore.DAL;
using SysCore.Model;

[WebService(Namespace = "http://tempuri.org/")]
[WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1)]
// 若要允许使用 ASP.NET AJAX 从脚本中调用此 Web 服务，请取消注释以下行。 
[System.Web.Script.Services.ScriptService]
public class DeliveryOrder_Service  : System.Web.Services.WebService {
    /// <summary>
    /// 保存单据
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string Save(string action, string do_id, string order_number, string new_date,
        string cus_id, string cus_name, string st_id, string st_name, string iot_id, string iot_name,
        string wh_id,string wh_name, string dep_id,string dep_name,
        string ele_id, string ele_name, string crc_id, string crc_name, string exchange_rate,
        string tax_rate, string zdkl, string sw_id, string sw_name, string ship_address, 
        string contact, string phone, string remark,
        string sdefine1, string sdefine2, string sdefine3, string sdefine4, string sdefine5,
        string ndefine1, string ndefine2, string ndefine3, string ndefine4, string ndefine5)
    {
        if (cus_name.Equals("")) cus_id = "";
        if (ele_name.Equals("")) ele_id = "";
        if (wh_name.Equals("")) wh_id = "";
        if (dep_name.Equals("")) dep_id = "";
        if (st_name.Equals("")) st_id = "";
        if (crc_name.Equals("")) crc_id = "";
        if (sw_name.Equals("")) sw_id = "";

        if (string.IsNullOrWhiteSpace(new_date))
        {
            return "发货单日期不可为空！";
        }
        if (string.IsNullOrWhiteSpace(cus_id))
        {
            return "客户不可为空！";
        }
        if (string.IsNullOrWhiteSpace(st_id))
        {
            //return "销售类型不可为空！";
        }
        //值为1代表启用仓库权限控制
        string system_wh_auth = new ConfigReader().GetConfig("system_wh_auth");
        if (system_wh_auth.Equals("1"))
        {
            if (string.IsNullOrWhiteSpace(wh_id))
            {
                return "仓库不可为空！";
            }
        }
        if (string.IsNullOrWhiteSpace(dep_id))
        {
            //return "销售部门不可为空！";
        }
        if (string.IsNullOrWhiteSpace(crc_id))
        {
            return "币种不可为空！";
        }
        if (string.IsNullOrWhiteSpace(ele_id))
        {
            //return "业务员不可为空！";
        }
        //值为1代表发货单审核自动生成出库单
        string sale_fahuo_verify_salesout = new ConfigReader().GetConfig("sale_fahuo_verify_salesout");
        if (sale_fahuo_verify_salesout.Equals("1"))
        {
            //仓库进出时收发类型是否必须填写 1,必填;0,可选
            string stock_input_iotype = new ConfigReader().GetConfig("stock_input_iotype");
            if (stock_input_iotype.Equals("1"))
            {
                //因为销售出库单需要收发类型，因此自动生成出库单时要求发货单必填收发类型
                if (string.IsNullOrWhiteSpace(iot_id))
                {
                    return "收发类型不可为空！";
                }
            }
        }
        //汇率为空或0时让等于1
        if (exchange_rate.Trim().Equals("") || exchange_rate.Trim().Equals("0"))
        {
            exchange_rate = "1";
        }
        //税率为空时让等于0
        if (tax_rate.Trim().Equals(""))
        {
            tax_rate = "0";
        }
        try
        {
            if (new CloseMonthDAL().CheckIsCloseMonth(Convert.ToDateTime(new_date)))
            {
                return "操作月份已业务结账,不允许修改!";
            }
            DeliveryOrderDAL dal = new DeliveryOrderDAL();
            DeliveryOrder m = new DeliveryOrder();
            LoginInfo li = new LoginInfo();
            if (action.Equals("Update"))
            {
                m = dal.Get(Convert.ToInt32(do_id));
                m.update_uid = li.uid;
                m.update_user = li.nickname;//修改人名称
                m.update_date = DateTime.Now;//修改日期
                if (m.verify_uid != null)
                {
                    return "已审核不允许改单";
                }
                if (string.IsNullOrWhiteSpace(order_number))
                {
                    return "单据号不可为空！";
                }
                if (!m.order_number.Equals(order_number))
                {
                    if (dal.CheckExist(order_number))
                    {
                        return "您修改了单号，然而单号：" + order_number + "已存在，请尝试别的号码！";
                    }
                }
            }
            else
            {
                m.new_uid = li.uid;
                m.new_user = li.nickname;//新增人名称
            }
            try
            {
                m.new_date = Convert.ToDateTime(new_date);
                m.order_number = order_number;
                m.cus_id = XTools.ObjectNullToInt(cus_id);
                m.st_id = XTools.ObjectNullToInt(st_id);
                m.iot_id = XTools.ObjectNullToInt(iot_id);
                m.wh_id = XTools.ObjectNullToInt(wh_id); 
                m.dep_id = XTools.ObjectNullToInt(dep_id);
                m.ele_id = XTools.ObjectNullToInt(ele_id);
                m.crc_id = XTools.ObjectNullToInt(crc_id);
                m.exchange_rate = XTools.ObjectNullToDecimal(exchange_rate);
                m.tax_rate = XTools.ObjectNullToDecimal(tax_rate);
                m.zdkl = XTools.ObjectNullToDecimal(zdkl);
                m.sw_id = XTools.ObjectNullToInt(sw_id);
                m.ship_address = ship_address.ToString();
                m.contact = contact.ToString();
                m.phone = phone.ToString();
                m.remark = remark.ToString();
                m.sdefine1 = sdefine1.ToString();
                m.sdefine2 = sdefine2.ToString();
                m.sdefine3 = sdefine3.ToString();
                m.sdefine4 = sdefine4.ToString();
                m.sdefine5 = sdefine5.ToString();
                m.ndefine1 = XTools.ObjectNullToDecimal(ndefine1);
                m.ndefine2 = XTools.ObjectNullToDecimal(ndefine2);
                m.ndefine3 = XTools.ObjectNullToDecimal(ndefine3);
                m.ndefine4 = XTools.ObjectNullToDecimal(ndefine4);
                m.ndefine5 = XTools.ObjectNullToDecimal(ndefine5);
            }
            catch (Exception err)
            {
                return err.Message;
            }
            if (action.Equals("Update"))
            {
                //启用事务
                using (TransactionScope scope = new TransactionScope())
                {
                    //更新表头
                    dal.Update(m);
                    new UserLogDAL().AddUserLog("发货单", "修改表头", m.do_id, m.order_number);
                    //提交事务
                    scope.Complete();
                }
            }
            else
            {
                //如果新增时单据号不为空说明是手工输入单号
                if (!order_number.Equals(""))
                {
                    if (dal.CheckExist(order_number))
                    {
                        return "单据号：" + order_number + "已存在！";
                    }
                }
               
                //启用事务
                using (TransactionScope scope = new TransactionScope())
                {
                    try
                    {
                        //新增表头
                        dal.Add(m);
                    }
                    catch (Exception err)
                    {
                        return err.Message;
                    } 
                    //return "f";
                    //得到新增保存后的最大ID号
                    int MaxID = dal.GetMaxID();
                    do_id = MaxID.ToString();
                    m = dal.Get(MaxID);
                    //如果流水号为空代表是系统自动流水
                    if (order_number.Equals(""))
                    {
                        //更新实体
                        try
                        {
                            //根据规则生成流水号
                            Hashtable ht_num = new Hashtable();
                            if (m.customer != null)
                                ht_num.Add("[cus_code]", m.customer.cus_code);
                            if(m.department != null)
                                ht_num.Add("[dep_code]", m.department.dep_code);
                            if (m.saletype != null)
                                ht_num.Add("[st_code]", m.saletype.st_code);
                            if(m.employee != null)
                                ht_num.Add("[ele_code]", m.employee.ele_code);
                            string running_number = new RunningNumberRuleDAL().GetModuleRunningNumber("Sale_DeliveryOrder", ht_num);
                            if(running_number.LastIndexOf("[") > -1)
                                return "自动生成流水号出错,请检查必填项目!";
                            m.order_number = running_number;
                            //更新实体
                            dal.Update(m);
                            new UserLogDAL().AddUserLog("发货单", "新增单据", m.do_id, m.order_number);
                        }
                        catch
                        {
                            return "自动生成流水号出错!";
                        }
                    }
                    //提交事务
                    scope.Complete();
                }
            }
        }
        catch (Exception e)
        {
            return e.Message;
        }
        return "success|" + do_id;
    }

    /// <summary>
    /// 删单
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string Delete(string ids)
    {
        string prev_id = "";
        try
        {
            DeliveryOrderDAL dal = new DeliveryOrderDAL();
            string sql = "select distinct do_id from Sale_DeliveryOrder where do_id in (" + ids + ")";
            using(SqlDataReader reader = new SqlUtil().GetDataReader(sql, null))
            {
                while (reader.Read())
                {
                    int id = reader.GetInt32(0);
                    DeliveryOrder m = dal.Get(id);
                    if (m.verify_uid != null)
                    {
                        return "单据:" + m.order_number + "已审核不允许删单!";
                    }
                    if (new CloseMonthDAL().CheckIsCloseMonth(Convert.ToDateTime(m.new_date)))
                    {
                        return "操作月份已业务结账,不允许修改!";
                    }
                    prev_id = GetPrevNextID(id, "1");//得到上一张单据ID
                    string msg = "";
                    //启用事务
                    using (TransactionScope scope = new TransactionScope())
                    {
                        new UserLogDAL().AddUserLog("发货单", "删除单据", m.do_id, m.order_number);
                        msg = dal.Delete(id);
                        if (!msg.Equals("success"))
                        {
                            return msg;
                        }
                        //提交事务
                        scope.Complete();
                    }
                }//end of reader
            }//end of using
            return "success|" + prev_id;
        }
        catch (Exception err)
        {
            return err.Message;
        }
        
    }

    /// <summary>
    /// 检查
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string Check(int id, int action_type)
    {
        try
        {
            DeliveryOrderDAL dal = new DeliveryOrderDAL();
            DeliveryOrder m = dal.Get(id);
            if (m.cus_id == null)
            {
                return "请填写客户!";
            }
            //检查必填项
            string result = dal.CheckMustInput(id);
            if (!result.Equals("success"))
            {
                return result;
            }
            
            //检查是否超现存量
            result = dal.CheckOverStock(id, action_type);
            if (!result.Equals("success"))
            {
                return result;
            }
            //值为0代表不允许超销售订单发货
            string over_order_quantity_sale = new ConfigReader().GetConfig("over_order_quantity_sale");
            if (over_order_quantity_sale.Equals("0"))
            {
                //检查是否超订单数量
                result = dal.CheckFaHuoOverOrder(id);
                if (!result.Equals("success"))
                {
                    return result;
                }
            }
            return "success";
        }
        catch (Exception err)
        {
            return err.Message;
        }
    }
    /// <summary>
    /// 审核或弃审
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string Verify(string ids, int action_type)
    {
        SqlUtil su = new SqlUtil();
        try
        {
            DeliveryOrderDAL dal = new DeliveryOrderDAL();
            string sql = "select distinct do_id from Sale_DeliveryOrder where do_id in (" + ids + ")";
            if (action_type == 1)
            {
                sql += " and isnull(verify_user,'')=''";
            }
            else
            {
                sql += " and isnull(verify_user,'')!=''";
            }
            //值为1代表发货单审核自动生成出库单
            string sale_fahuo_verify_salesout = new ConfigReader().GetConfig("sale_fahuo_verify_salesout");
            using(SqlDataReader reader = new SqlUtil().GetDataReader(sql, null))
            {
                while (reader.Read())
                {
                    int id = reader.GetInt32(0);
                    DeliveryOrder m = dal.Get(id);
                    if (new CloseMonthDAL().CheckIsCloseMonth(Convert.ToDateTime(m.new_date)))
                    {
                        return "操作月份已业务结账,不允许修改!";
                    }
                    LoginInfo li = new LoginInfo();
                    if (action_type == 1)
                    {
                        if (m.verify_uid != null)
                        {
                            return "不允许重复审核";
                        }
                        if (new DeliveryOrdersDAL().GetOneOrder_TotalNumbers(id) == 0)
                        {
                            return "表体为空不允许审核!";
                        }
                        m.verify_uid = li.uid;
                        m.verify_user = li.nickname;
                        //审核前检查
                        string result = Check(id, action_type);
                        if (!result.Equals("success"))
                        {
                            return result;
                        }
                    }
                    else
                    {
                        if (m.verify_uid == null)
                        {
                            return "不允许重复弃审";
                        }
                        m.verify_uid = null;
                        m.verify_user = null;
                    }
                    //启用事务
                    using (TransactionScope scope = new TransactionScope())
                    {
                        //更新实体
                        dal.Update(m);
                        //更新累计发货数
                        dal.UpdateFaHuoQuantityByOrder(m.do_id, action_type);
                        if (action_type == 1)
                        {
                            new UserLogDAL().AddUserLog("发货单", "审核单据", m.do_id, m.order_number);
                        }
                        else
                        {
                            new UserLogDAL().AddUserLog("发货单", "弃审单据", m.do_id, m.order_number);
                        }

                        if (sale_fahuo_verify_salesout.Equals("1"))
                        {
                            InOut io = new InOut();
                            InOutDAL io_dal = new InOutDAL();
                            InOutsDAL ios_dal = new InOutsDAL();
                            DeliveryOrdersDAL dos_dal = new DeliveryOrdersDAL();
                            if (action_type == 1)
                            {
                                //生成销售出库单
                                string msg = dal.DeliveryOrderToSalesOut(id, action_type);
                                if (!msg.Equals("success"))
                                {
                                    return msg;
                                }
                            }
                            else
                            {
                                try
                                {
                                    //删除发货单所生成的销售出库单
                                    string msg = dal.DeleteSalesOutFromDeliveryOrder(id, action_type);
                                    if (!msg.Equals("success"))
                                    {
                                        return msg;
                                    }
                                }
                                catch (Exception err)
                                {
                                    return err.Message;
                                }
                            }
                        }
                        else
                        {
                            if (action_type == -1)
                            {
                                //如果非自动生成出库单模式，则生成出库单后不允许弃审发货单
                                if (dal.CheckHasChuKu(Convert.ToInt32(id)))
                                {
                                    return "本发货单已销售出库，不允许弃审!";
                                }
                            }
                        }
                        ModuleScriptDAL ms_dal = new ModuleScriptDAL();
                        if (action_type == 1)
                        {
                            //发单审核SQL脚本
                            string sql_verify = ms_dal.GetByCode("DeliveryOrder_Verify").script;
                            sql_verify = sql_verify.Replace("@do_id", id.ToString());
                            su.ExecuteNonQuery(sql_verify, null);
                        }
                        else
                        {
                        }
                        //提交事务
                        scope.Complete();
                    }//end of trans
                }//end of while
            }//end of reader
            return "success";
        }//end of try
        catch (Exception e)
        {
            return e.Message;
        }
    }
    
    /// <summary>
    /// 上张或下张
    /// </summary>
    /// <param name="id">主表id</param>
    /// <param name="type">操作类型</param>
    /// <returns></returns>
    [WebMethod(EnableSession = true)]
    public string GetPrevNextID(int id, string type)
    {
        DeliveryOrderDAL dal = new DeliveryOrderDAL();
        return dal.GetPrevNextID(id, type).ToString();
    }
    /// <summary>
    /// 批量设置表体仓库
    /// </summary>
    /// <param name="id">主表id</param>
    /// <param name="wh_id">仓库id</param>
    /// <returns></returns>
    [WebMethod(EnableSession = true)]
    public string BatchSetWarehouse(int id, int wh_id)
    {
        DeliveryOrderDAL dal = new DeliveryOrderDAL();
        try
        {
            if (dal.Get(id).verify_uid != null)
            {
                return "已审核不允许改单";
            }
            dal.BatchSetWarehouse(id, wh_id);
        }
        catch (Exception err)
        {
            return err.Message;
        }
        return "success";
    }
    /// <summary>
    /// 获取套餐
    /// </summary>
    /// <param name="do_id">发货单主表ID</param>
    /// <param name="gc_id">套餐ID</param>
    /// <returns></returns>
    [WebMethod(EnableSession = true)]
    public string GetGoodsCombo(int do_id, int gc_id, decimal qty)
    {
        try
        {
            Config cf = new Config();
            ConfigDAL cf_dal = new ConfigDAL();
            int dig_qty = Convert.ToInt32(cf_dal.GetByCode("digit_quantity").cf_value);
            int dgt_num = Convert.ToInt32(cf_dal.GetByCode("digit_number").cf_value);
            int dgt_exch = Convert.ToInt32(cf_dal.GetByCode("digit_exch").cf_value);
            int dgt_pri = Convert.ToInt32(cf_dal.GetByCode("digit_unit_price").cf_value);
            
            GoodsCombosDAL gcs_dal = new GoodsCombosDAL();
            DeliveryOrderDAL t_dal = new DeliveryOrderDAL();
            DeliveryOrder t = t_dal.Get(do_id);
            DeliveryOrdersDAL dal = new DeliveryOrdersDAL();
            DataTable dt = gcs_dal.GetDetails(gc_id);
            InventoryDAL i_dal = new InventoryDAL();
            foreach (DataRow dr in dt.Rows)
            {
                GoodsCombos gcs = gcs_dal.Get(Convert.ToInt32(dr["gcs_id"]));
                DeliveryOrders m = new DeliveryOrders();
                m.gcs_id = gcs.gcs_id;//套餐子表id
                m.d_wh_id = t.wh_id;//仓库
                m.do_id = do_id;//发货单id
                m.i_id = gcs.i_id;//存货
                m.inventory = i_dal.Get(m.i_id);
                m.free1 = gcs.free1;//自由项1
                m.free2 = gcs.free2;//自由项2
                //表体税率=表头税率
                m.d_tax_rate = t.tax_rate;
                //含税单价=套餐含税单价
                m.tax_unit_price = gcs.tax_unit_price;
                //无税单价=含税单价/（1+税率)
                m.unit_price = Math.Round((decimal)(m.tax_unit_price / (1 + m.d_tax_rate / 100)), dgt_pri);
                //发货数量=套餐数量*数量
                m.quantity = Math.Round((decimal)(gcs.quantity * qty), dig_qty);
                //含税金额=套餐含税金额*数量
                m.tax_total_price = Math.Round((decimal)(gcs.tax_total_price * qty), 2);
                //无税金额=含税金额/（1+税率)
                m.total_price = Math.Round((decimal)(m.tax_total_price / (1 + m.d_tax_rate / 100)), 2);
                //税金=含税金额-无税金额
                m.tax = m.tax_total_price - m.total_price;
                /************** 本币部分 **************/
                //本币无税单价=单价*汇率
                m.nat_unit_price = Math.Round((decimal)(m.unit_price * t.exchange_rate), dgt_pri); 
                //本币无税金额=金额*汇率
                m.nat_total_price = Math.Round((decimal)(m.total_price * t.exchange_rate), 2); 
                //本币税额=税额*汇率
                m.nat_tax = Math.Round((decimal)(m.tax * t.exchange_rate), 2); 
                //本币无税金额=金额*汇率
                m.nat_total_price = Math.Round((decimal)(m.total_price * t.exchange_rate), 2); 
                //本币价税合计=含税金额*汇率
                m.nat_tax_total_price = Math.Round((decimal)(m.tax_total_price * t.exchange_rate), 2); 
                //本币无税金额=金额*汇率
                m.nat_total_price = Math.Round((decimal)(m.total_price * t.exchange_rate), 2); 
                //本币含税单价=本币含税金额/数量
                m.nat_tax_unit_price = Math.Round((decimal)(m.nat_tax_total_price/m.quantity), dgt_pri);
                m.d_remark = gcs.d_remark;//产品备注
                m.quoted_price = m.inventory.new_tax_unit_price;//报价

                m.zk = Math.Round((decimal)(m.quoted_price * m.quantity - m.tax_total_price), 2);//折扣金额
                if (m.quoted_price * m.quantity != 0)
                {
                    m.kl = Math.Round((decimal)(m.tax_total_price / (m.quoted_price * m.quantity)) * 100, 2);//扣率
                }
                dal.Add(m);
            }
        }
        catch (Exception err)
        {
            return err.Message;
        }
        return "success";
    }
}