﻿<%@ Page Language="C#" AutoEventWireup="true" CodeFile="Account_List.aspx.cs" Inherits="Root_Account_List" %>

<%@ Register src="../UserControl/Header.ascx" tagname="Header" tagprefix="uc1" %>
<!DOCTYPE html>

<html>
<head runat="server">
    <title></title>
    <meta name="viewport" content="width=device-width,inital-scale=1.0,maximum-scale=1.0,user-scalable=no;" />
    <link type="text/css" href="../Styles/root_table.css" rel="Stylesheet" />
    <script type="text/javascript">
        function update_db(db_name) {
            if (!confirm("确定要升级账套吗?\n如果不了解此功能请不要进行操作。")) return;
            window.location = "InstallSQL_Frame.aspx?db_name=" + db_name + "&create_db=0";
        }
    </script>
</head>
<body>
    <uc1:Header runat="server" ID="uc1" />
    <form id="form1" runat="server">
    <div style='text-align:left;width:800px;border:solid 0px red;margin:auto;'>
    <asp:Button runat="server" Text="新建账套" CssClass="metro_btn" ID="create_db" onclick="CreateDB_Click"/>
    <asp:Button runat="server" Text="刷新" CssClass="metro_btn" ID="refresh" onclick="Refresh_Click"/>
    <br /><br />
    <asp:ListView ID="list_view" runat="server" ItemPlaceholderID="placeHolder">
        <LayoutTemplate>
            <table id="lvTable" class="root_table" style='width:800px;background-color:#green;margin:auto'>
                <thead>
                <tr>
                    <th nowrap>账套数据库</th>
                    <th nowrap>创建日期</th>
                    <th nowrap>数据库版本</th>
                    <th nowrap>文件路径</th>
                    <th nowrap>操作</th>
                </tr>
                </thead>
                <tbody>
                    <tr id="placeHolder" runat="server"></tr>
                </tbody>
            </table>
        </LayoutTemplate>
        <ItemTemplate>
            <tr>
                <td><%# Eval("db_name")%></td>
                <td><%# Eval("crdate")%></td>
                <td><%# Eval("version")%></td>
                <td><%# Eval("filename")%></td>
                <td><a class="btn btn-red" href='javascript:update_db("<%# Eval("db_name")%>");'>升级</a></td>
            </tr>
        </ItemTemplate>
        <EmptyDataTemplate>
            <center>当前没有账套,请创建</center>
        </EmptyDataTemplate>
    </asp:ListView>
    <div style='margin-top:100px;'>
        出于安全考虑，本后台不支持在线删除账套，有需要请手工到SQL Server进行操作<br />
        同样的，可以使用SQL Server进行账套的备份与恢复
    </div>

    </div>
    </form>
</body>
</html>
