﻿<%@ WebService Language="C#" Class="PurchaseOrders_Service" %>

using System;
using System.Web;
using System.Web.Services;
using System.Web.Services.Protocols;
using SysCore;
//using SysCore.Model;
//using SysCore.DAL;

[WebService(Namespace = "http://tempuri.org/")]
[WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1)]
// 若要允许使用 ASP.NET AJAX 从脚本中调用此 Web 服务，请取消注释以下行。 
[System.Web.Script.Services.ScriptService]
public class PurchaseOrders_Service  : System.Web.Services.WebService {
    
    /// <summary>
    /// 删除
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string Delete(string ids)
    {
        PurchaseOrdersDAL dal = new PurchaseOrdersDAL();
        foreach (string id in ids.Split(','))
        {
            try
            {
                dal.Delete(Convert.ToInt32(id));
            }
            catch (Exception e)
            {
                return e.Message;
            }
        }
        return "success";
    }

    /// <summary>
    /// 修改
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string Save(string action, string po_id, string pos_id, 
        string i_id, string free1, string free2, string i_code, string i_name,
        string standard,string munit,string aunit,string unit_price,string tax_unit_price,
        string quantity,string num,string convert_rate,string total_price,string tax_total_price,
        string tax,string nat_unit_price, string nat_total_price,
        string nat_tax_unit_price, string nat_tax_total_price, string nat_tax,
        string d_tax_rate, string arrive_date, string d_remark, 
        string d_sdefine1, string d_sdefine2, string d_sdefine3, string d_sdefine4, string d_sdefine5,
        string d_ndefine1, string d_ndefine2, string d_ndefine3, string d_ndefine4, string d_ndefine5)
    {
        if (string.IsNullOrWhiteSpace(i_id) || i_id.Equals("0"))
        {
            return "请输入存货！";
        }
        if (string.IsNullOrWhiteSpace(quantity) || quantity.Equals("0"))
        {
            return "数量不可为空或零！";
        }
        if (Convert.ToDecimal(quantity) < 0)
        {
            return "数量必须大于零！";
        }
        try
        {
            PurchaseOrdersDAL dal = new PurchaseOrdersDAL();
            PurchaseOrders m = new PurchaseOrders();
            if (action.Equals("Update"))
            {
                m = dal.Get(Convert.ToInt32(pos_id));
            }
            m.po_id = Convert.ToInt32(po_id);
            m.i_id = Convert.ToInt32(i_id);
            free1 = free1.Trim(); 
            free2 = free2.Trim();
            Inventory inv = new InventoryDAL().Get(Convert.ToInt32(i_id));
            if (!free1.Equals("") && inv.on_free1 == 0)
                return "存货不允许输入自由项1！";
            if (!free2.Equals("") && inv.on_free2 == 0)
                return "存货不允许输入自由项2！";
            if (free1.Equals("") && inv.on_free1 == 1)
                return "存货必须输入自由项1！";
            if (free2.Equals("") && inv.on_free2 == 1)
                return "存货必须输入自由项2！";
            if (inv.aunit.Equals("") && !num.Equals(""))
                return "未启用辅计量单位，启不要输入件数！";
            if (!inv.aunit.Equals(""))
            {
                if (num.Equals("") || num.Equals("0"))
                {
                    return "存货启用了辅计量单位，必须输入件数！";
                }
                if (convert_rate.Equals("") || convert_rate.Equals("0"))
                {
                    return "存货启用了辅计量单位，必须输入换算率！";
                }
            }
            m.free1 = free1;
            m.free2 = free2;
            m.unit_price = XTools.ObjectNullToDecimal(unit_price);
            m.tax_unit_price = XTools.ObjectNullToDecimal(tax_unit_price);
            m.quantity = XTools.ObjectNullToDecimal(quantity);
            m.num = XTools.ObjectNullToDecimal(num);
            m.convert_rate = XTools.ObjectNullToDecimal(convert_rate);
            m.total_price = XTools.ObjectNullToDecimal(total_price);
            m.tax_total_price = XTools.ObjectNullToDecimal(tax_total_price);
            m.tax = XTools.ObjectNullToDecimal(tax);
            m.nat_unit_price = XTools.ObjectNullToDecimal(nat_unit_price);
            m.nat_total_price = XTools.ObjectNullToDecimal(nat_total_price);
            m.nat_tax_unit_price = XTools.ObjectNullToDecimal(nat_tax_unit_price);
            m.nat_tax_total_price = XTools.ObjectNullToDecimal(nat_tax_total_price);
            m.nat_tax = XTools.ObjectNullToDecimal(nat_tax);
            m.d_tax_rate = XTools.ObjectNullToDecimal(d_tax_rate);
            m.arrive_date = XTools.ObjectNullToDateTime(arrive_date);
            m.d_remark = d_remark;
            m.d_sdefine1 = d_sdefine1;
            m.d_sdefine2 = d_sdefine2;
            m.d_sdefine3 = d_sdefine3;
            m.d_sdefine4 = d_sdefine4;
            m.d_sdefine5 = d_sdefine5;
            m.d_ndefine1 = XTools.ObjectNullToDecimal(d_ndefine1);
            m.d_ndefine2 = XTools.ObjectNullToDecimal(d_ndefine2);
            m.d_ndefine3 = XTools.ObjectNullToDecimal(d_ndefine3);
            m.d_ndefine4 = XTools.ObjectNullToDecimal(d_ndefine4);
            m.d_ndefine5 = XTools.ObjectNullToDecimal(d_ndefine5);
            if (action.Equals("Update"))
            {
                dal.Update(m);
            }
            else
            {
                dal.Add(m);
            }
        }
        catch (Exception e)
        {
            return e.Message;
        }
        return "success";
    }

    /// <summary>
    /// 获取
    /// </summary>
    [WebMethod(EnableSession = true)]
    public PurchaseOrders Get(string pos_id)
    {
        PurchaseOrdersDAL dal = new PurchaseOrdersDAL();
        return dal.Get(Convert.ToInt32(pos_id));
    }
}