﻿<%@ WebService Language="C#" Class="PurchaseOrder_Service" %>

using System;
using System.Web;
using System.Web.Services;
using System.Web.Services.Protocols;
using System.Collections;
using System.Transactions;
using System.Data;
using System.Data.SqlClient;
using SysCore;
using SysCore.DAL;
using SysCore.Model;

[WebService(Namespace = "http://tempuri.org/")]
[WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1)]
// 若要允许使用 ASP.NET AJAX 从脚本中调用此 Web 服务，请取消注释以下行。 
[System.Web.Script.Services.ScriptService]
public class PurchaseOrder_Service  : System.Web.Services.WebService {
    /// <summary>
    /// 保存单据
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string Save(string action, string po_id, string order_number, string new_date,
        string vd_id, string vd_name, string pt_id, string pt_name, string dep_id, string dep_name,
        string ele_id, string ele_name, string crc_id, string crc_name, string exchange_rate, string remark,
        string tax_rate, string sw_id, string sw_name, string ship_address, string contact, string phone, 
        string sdefine1, string sdefine2, string sdefine3, string sdefine4, string sdefine5,
        string ndefine1, string ndefine2, string ndefine3, string ndefine4, string ndefine5)
    {
        if (vd_name.Equals("")) vd_id = "";
        if (ele_name.Equals("")) ele_id = "";
        if (dep_name.Equals("")) dep_id = "";
        if (pt_name.Equals("")) pt_id = "";
        if (crc_name.Equals("")) crc_id = "";
        if (sw_name.Equals("")) sw_id = "";
        
        if (string.IsNullOrWhiteSpace(new_date))
        {
            return "订单日期不可为空！";
        }
        if (string.IsNullOrWhiteSpace(vd_id))
        {
            return "供应商不可为空！";
        }
        if (string.IsNullOrWhiteSpace(ele_id))
        {
            //return "业务员不可为空！";
        }
        if (string.IsNullOrWhiteSpace(pt_id))
        {
            //return "采购类型不可为空！";
        }
        if (string.IsNullOrWhiteSpace(dep_id))
        {
            //return "采购部门不可为空！";
        }
        if (string.IsNullOrWhiteSpace(crc_id))
        {
            return "币种不可为空！";
        }
        if (exchange_rate.Trim().Equals("") || exchange_rate.Trim().Equals("0"))
            exchange_rate = "1";
        //税率为空时让等于0
        if (tax_rate.Trim().Equals(""))
        {
            tax_rate = "0";
        }
        try
        {
            if (new CloseMonthDAL().CheckIsCloseMonth(Convert.ToDateTime(new_date)))
            {
                return "操作月份已业务结账,不允许修改!";
            }
            PurchaseOrderDAL dal = new PurchaseOrderDAL();
            PurchaseOrder m = new PurchaseOrder();
            if (action.Equals("Update"))
            {
                if (string.IsNullOrWhiteSpace(order_number))
                {
                    return "单据号不可为空！";
                }
                m = dal.Get(Convert.ToInt32(po_id));
                if (!m.order_number.Equals(order_number))
                {
                    if (dal.CheckExist(order_number))
                    {
                        return "您修改了单号，然而单号：" + order_number + "已存在，请尝试别的号码！";
                    }
                }
            }
            m.new_date = Convert.ToDateTime(new_date);
            m.order_number = order_number;
            m.vd_id = XTools.ObjectNullToInt(vd_id);
            m.pt_id = XTools.ObjectNullToInt(pt_id);
            m.dep_id = XTools.ObjectNullToInt(dep_id);
            m.ele_id = XTools.ObjectNullToInt(ele_id);
            m.crc_id = XTools.ObjectNullToInt(crc_id);
            m.exchange_rate = XTools.ObjectNullToDecimal(exchange_rate);
            m.tax_rate = XTools.ObjectNullToDecimal(tax_rate);
            m.sw_id = XTools.ObjectNullToInt(sw_id);
            m.ship_address = ship_address.ToString();
            m.contact = contact.ToString();
            m.phone = phone.ToString();
            m.remark = remark.ToString();
            m.sdefine1 = sdefine1.ToString();
            m.sdefine2 = sdefine2.ToString();
            m.sdefine3 = sdefine3.ToString();
            m.sdefine4 = sdefine4.ToString();
            m.sdefine5 = sdefine5.ToString();
            m.ndefine1 = XTools.ObjectNullToDecimal(ndefine1);
            m.ndefine2 = XTools.ObjectNullToDecimal(ndefine2);
            m.ndefine3 = XTools.ObjectNullToDecimal(ndefine3);
            m.ndefine4 = XTools.ObjectNullToDecimal(ndefine4);
            m.ndefine5 = XTools.ObjectNullToDecimal(ndefine5);
            LoginInfo li = new LoginInfo();
            //启用事务
            using (TransactionScope scope = new TransactionScope())
            {
                if (action.Equals("Update"))
                {
                    m.update_uid = li.uid;
                    m.update_user = li.nickname;//修改人名称
                    m.update_date = DateTime.Now;//修改日期
                    dal.Update(m);
                    new UserLogDAL().AddUserLog("采购订单", "修改单据", m.po_id, m.order_number);
                }
                else
                {
                    m.new_uid = li.uid;
                    m.new_user = li.nickname;//新增人名称
                    //如果新增时单据号不为空说明是手工输入单号
                    if (!order_number.Equals(""))
                    {
                        if (dal.CheckExist(order_number))
                        {
                            return "单据号：" + order_number + "已存在！";
                        }
                    }
                    //新增实体
                    dal.Add(m);
                    //得到新增保存后的最大ID号
                    int MaxID = dal.GetMaxID();
                    po_id = MaxID.ToString();
                    m = dal.Get(MaxID);
                    //如果流水号为空代表是系统自动流水
                    if (order_number.Equals(""))
                    {
                        //更新实体
                        try
                        {
                            //根据规则生成流水号
                            Hashtable ht_num = new Hashtable();
                            ht_num.Add("[dep_code]", m.department.dep_code);
                            ht_num.Add("[pt_code]", m.purchasetype.pt_code);
                            string running_number = new RunningNumberRuleDAL().GetModuleRunningNumber("Purchase_PurchaseOrder", ht_num);
                            m.order_number = running_number;
                            //更新实体
                            dal.Update(m);
                        }
                        catch
                        {
                            return "自动生成流水号出错,请检查必填项目!";
                        }
                    }
                    new UserLogDAL().AddUserLog("采购订单", "新增单据", m.po_id, m.order_number);
                }
                //提交事务
                scope.Complete();
            }//end of Trans
        }
        catch (Exception e)
        {
            return e.Message+e.StackTrace;
        }
        return "success|" + po_id;
    }
    /// <summary>
    /// 删单
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string Delete(string ids)
    {
        string prev_id = "";
        PurchaseOrderDAL dal = new PurchaseOrderDAL();
        string sql = "select distinct po_id from Purchase_PurchaseOrder where po_id in (" + ids + ")";
        using (SqlDataReader reader = new SqlUtil().GetDataReader(sql, null))
        {
            while (reader.Read())
            {
                int id = reader.GetInt32(0);
                PurchaseOrder po = dal.Get(id);
                if (po.verify_uid != null)
                {
                    return "单据:" + po.order_number + "已审核不允许删单!";
                }
                if (new CloseMonthDAL().CheckIsCloseMonth(Convert.ToDateTime(po.new_date)))
                {
                    return "操作月份已业务结账,不允许修改!";
                }
                PurchaseOrdersDAL sdal = new PurchaseOrdersDAL();
                prev_id = GetPrevNextID(id, "1");//得到上一张单据ID
                string msg = "";
                //启用事务
                using (TransactionScope scope = new TransactionScope())
                {
                    new UserLogDAL().AddUserLog("采购订单", "删除单据", po.po_id, po.order_number);
                    msg = dal.Delete(id);
                    if (!msg.Equals("success"))
                    {
                        return msg;
                    }
                    //提交事务
                    scope.Complete();
                }
            }//end of while
        }//end of using
        return "success|" + prev_id;
    }

    /// <summary>
    /// 检查
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string Check(int id, int action_type)
    {
        try
        {
            PurchaseOrderDAL dal = new PurchaseOrderDAL();
            PurchaseOrder m = dal.Get(id);
            if (action_type == 1)
            {
                if (m.vd_id == null)
                {
                    return "供填写供应商!";
                }
                //检查必填项
                string result = dal.CheckMustInput(id);
                if (!result.Equals("success"))
                {
                    return result;
                }
            }
            return "success";
        }
        catch (Exception err)
        {
            return err.Message;
        }
    }
    
    [WebMethod(EnableSession = true)]
    public string Verify(string ids, int action_type)
    {
        SqlUtil su = new SqlUtil();
        try
        {
            PurchaseOrderDAL dal = new PurchaseOrderDAL();
            string sql = "select distinct po_id from Purchase_PurchaseOrder where po_id in (" + ids + ")";
            if (action_type == 1)
            {
                sql += " and isnull(verify_user,'')=''";
            }
            else
            {
                sql += " and isnull(verify_user,'')!=''";
            }
            using (SqlDataReader reader = new SqlUtil().GetDataReader(sql, null))
            {
                while (reader.Read())
                {
                    int id = reader.GetInt32(0);
                    PurchaseOrder m = dal.Get(id);
                    LoginInfo li = new LoginInfo();
                    if (action_type == 1)
                    {
                        if (m.verify_uid != null)
                        {
                            return "不允许重复审核!";
                        }
                        if (new PurchaseOrdersDAL().GetOneOrder_TotalNumbers(id) == 0)
                        {
                            return "表体为空不允许审核!";
                        }
                        m.verify_uid = li.uid;
                        m.verify_user = li.nickname;
                        //审核前检查
                        string result = Check(id, action_type);
                        if (!result.Equals("success"))
                        {
                            return result;
                        }
                    }
                    else
                    {
                        if (m.verify_uid == null)
                        {
                            return "不允许重复弃审!";
                        }
                        m.verify_uid = null;
                        m.verify_user = null;
                        if (dal.CheckHasRuKu(id))
                        {
                            return "本订单已入库，不允许弃审!";
                        }
                    }
                    //启用事务
                    using (TransactionScope scope = new TransactionScope())
                    {
                        if (action_type == 1)
                        {
                            new UserLogDAL().AddUserLog("采购订单", "审核单据", m.po_id, m.order_number);
                        }
                        else
                        {
                            new UserLogDAL().AddUserLog("采购订单", "弃审单据", m.po_id, m.order_number);
                        }
                        dal.Update(m);//更新审核状态
                        ModuleScriptDAL ms_dal = new ModuleScriptDAL();
                        if (action_type == 1)
                        {
                            //采购订单审核SQL脚本
                            string sql_verify = ms_dal.GetByCode("PurchaseOrder_Verify").script;
                            sql_verify = sql_verify.Replace("@po_id", id.ToString());
                            su.ExecuteNonQuery(sql_verify, null);
                        }
                        else
                        {
                        }
                        //提交事务
                        scope.Complete();
                    }
                }//end of while
            }//end of using
            return "success";
        }catch(Exception e){
            return e.Message;
        }
        
    }
    
    /// <summary>
    /// 上张或下张
    /// </summary>
    /// <param name="id">主表id</param>
    /// <param name="type">操作类型</param>
    /// <returns></returns>
    [WebMethod(EnableSession = true)]
    public string GetPrevNextID(int id, string type)
    {
        PurchaseOrderDAL dal = new PurchaseOrderDAL();
        return dal.GetPrevNextID(id, type).ToString();
    }
}