﻿<%@ Page Language="C#" AutoEventWireup="true" CodeFile="PMC_List.aspx.cs" Inherits="Plan_PMC_PMC_List" %>
<%@ Register Src="~/Scripts/AWGridRuntime/UserControl/ListHeader.ascx" TagPrefix="uc1" TagName="ListHeader" %>
<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title></title>
    <uc1:ListHeader runat="server" ID="ListHeader" />
    <script type="text/javascript">
        //搜索
        function search_grid() {
            var fg = document.getElementById("frame_grid");
            var keyword = $("#keyword").val();
            var begin_date = $("#begin_date").val();
            var end_date = $("#end_date").val();
            var ic_id = $("#ic_id").val();
            var i_code = $("#i_code").val();
            var i_name = $("#i_name").val();
            var standard = $("#standard").val();
            var is_verify = $("#is_verify").val();

            if ($("#ic_name").val() == "") ic_id = "";
            if ($("#i_code").val() == "") i_id = "";

            var url = "PMC_List_Grid.aspx?keyword=" + keyword + "&is_verify=" + is_verify
                    + "&begin_date=" + begin_date + "&end_date=" + end_date + "&ic_id=" + ic_id
                    + "&i_id=" + i_id + "&i_code=" + i_code + "&i_name=" + i_name + "&standard=" + standard;
            fg.src = url;
        }
        //新增
        function add_doc() {
            var url = '../../Plan/PMC/PMC_Document.aspx?action=Add';
            top.OpenWindow('Activate', 'Plan_PMC_Add', '新增PMC', url);
        }
        //删除
        function delete_doc() {
            var url = '../../Plan/PMC/PMC_Document.aspx?action=Add';
            top.OpenWindow('Activate', 'Plan_PMC_Add', '新增PMC', url);
        }
        //联查
        function modify() {
            var fg = document.getElementById("frame_grid"); //得到grid控件所在iframe
            var cw = fg.contentWindow;
            var id = cw.aw_GetSelectRows(cw._pmc_id); //返回一维数组
            var p_i_code = cw.aw_GetSelectRows(cw._p_i_code); //返回一维数组
            if (id.length == 0) {
                AlertNO('请选择要查看的记录!');
                return;
            }
            if (id.length > 1) {
                AlertNO('一次只可以查看一条记录!');
                return;
            }
            if (id == "") 
                return;
            var url = '../../Plan/PMC/PMC_Document.aspx?action=Update&id=' + id;
            top.OpenWindow('Activate', 'Plan_PMC_' + p_i_code, 'PMC-' + p_i_code, url);
        }
        //删除单据
        function delete_doc() {
            var fg = document.getElementById("frame_grid"); //得到grid控件所在iframe
            var cw = fg.contentWindow;
            var id = cw.aw_GetSelectRows(cw._pmc_id); //返回一维数组
            if (id.length == 0) {
                AlertNO('请选择要删除的记录!');
                return;
            }
            asyncbox.confirm('确定要删除本单据吗?', '警告', function (buttonResult) {
                if (buttonResult == "ok") {
                    ShowLoadingMask(); //显示遮罩
                    $.ajax({
                        type: "POST",
                        contentType: "application/json",
                        url: 'PMC_Service.asmx/Delete',
                        data: "{ids:'" + id + "'}",
                        dataType: 'json',
                        success: function (result) {
                            HideLoadingMask(); //关闭遮罩
                            var arr = result.d.split('|');
                            if (arr[0] == "success") {
                                AlertOK("删除成功！");
                                search_grid();
                            } else {
                                AlertNO(result.d);
                            }
                        }
                    });
                }
            });
        }
        //审核单据
        function verify_doc(action_type) {
            var fg = document.getElementById("frame_grid"); //得到grid控件所在iframe
            var cw = fg.contentWindow;
            var id = cw.aw_GetSelectRows(cw._pmc_id); //返回一维数组
            if (id.length == 0) {
                AlertNO('请选择要审核的记录!');
                return;
            }

            ShowLoadingMask(); //显示遮罩
            $.ajax({
                type: "POST",
                contentType: "application/json",
                url: 'PMC_Service.asmx/Verify',
                data: "{id:'" + id + "',action_type:'" + action_type + "'}",
                dataType: 'json',
                success: function (result) {
                    HideLoadingMask(); //关闭遮罩
                    if (result.d == "success") {
                        var title = '审核';
                        if (action_type == 0)
                            title = '弃审';
                            AlertOK(title + '成功！');
                            search_grid();
                    } else {
                        AlertNO(result.d);
                    }
                }
            });
        }
        //选择打印模板
        function grf_print() {
            var fg = document.getElementById("frame_grid"); //得到grid控件所在iframe
            var cw = fg.contentWindow;
            choice_print_template('<%=xview["auth_code"]%>', "", cw.sql_print_detail_session_id);
        }
    </script>
</head>
<body>
    <!--工具栏-->
    <div style="height:30px;" class="list_menu_bar">
        <input type="text" class="keyword_box" id="keyword"/>
        <a plain="true" class="easyui-linkbutton" onclick="search_grid()">搜索</a>
        <a plain="true" class="easyui-linkbutton" onclick="$('#search_win').window('open')" iconcls="icon-search">高级搜索</a>
        <a plain="true" class="easyui-linkbutton" onclick="add_doc()" style='<%=auth.AuthView("Plan_PMC_Edit")%>'>新增</a>
        <a plain="true" class="easyui-linkbutton" onclick="modify()">查看</a>
        <a plain="true" class="easyui-linkbutton" onclick="delete_doc()" style='<%=auth.AuthView("Plan_PMC_Delete")%>'>删除</a>
        <a plain="true" id="m_more_fun" class="easyui-menubutton" menu="#menu_more_fun">更多功能</a>
        <a plain="true" class="easyui-linkbutton" id="btn_print" onclick='grf_print()' style='<%=auth.AuthView("Plan_PMC_Print")%>'>打印</a>
        <a plain="true" class="easyui-linkbutton" onclick="DesignModuleFormat('Plan_PMC_List')" style='<%=auth.AdminView()%>'>格式</a>
    </div>
    <!--其它功能下拉菜单-->
    <div id="menu_more_fun" style="width:150px;">
        <div onclick="verify_doc(1)" style='<%=auth.AuthView("Plan_PMC_Verify")%>'>审核</div>
        <div onclick="verify_doc(0)" style='<%=auth.AuthView("Plan_PMC_CancelVerify")%>'>弃审</div>
	</div>
    <!--Grid控件所在的iframe-->
    <%=xview["grid_frame"]%>
    <!--搜索窗口-->  
	<div id="search_win" class="easyui-dialog" title="搜索"
        data-options="modal:true,closed:false,closable: false,iconCls:'icon-search'"
        style="width:500px;height:400px;padding:10px;">
		<table style="margin:auto;">
            <tr>
                <td style="text-align:right">起始日期:</td>
                <td>
                    <input type="text" class="edit_text_box" id="begin_date" style='width:120px' onclick='ShowDateControl()' value='<%=xview["begin_date"]%>'/></td>
            </tr>
            <tr>
                <td style="text-align:right">截止日期:</td>
                <td>
                    <input type="text" class="edit_text_box" id="end_date" style='width:120px' onclick='ShowDateControl()'/></td>
            </tr>
            <tr>
                <td style="text-align:right">是否审核:</td>
                <td>
                    <select id='is_verify' style='margin-left:4px'>
                        <option value=''></option>
                        <option value='0'>未审核</option>
                        <option value='1'>已审核</option>
                    </select></td>
            </tr>
            <tr>
                <td style="text-align:right">存货编码:</td>
                <td>
                    <input type="hidden" class="edit_text_box" id="i_id"/>
                    <input type="text" class="edit_text_box" id="i_code" style='width:98px'/></td>
            </tr>
            <tr>
                <td style="text-align:right">存货名称:</td>
                <td><input type="text" class="edit_text_box" id="i_name"/></td>
            </tr>
            <tr>
                <td style="text-align:right">规格型号:</td>
                <td><input type="text" class="edit_text_box" id="standard"/></td>
            </tr>
            <tr>
                <td style="text-align:right">存货分类:</td>
                <td>
                    <input type="hidden" class="edit_text_box" id="ic_id"/>
                    <input type="text" class="edit_text_box" id="ic_name" style='width:103px'/>
                    <div class='combobox_trigger'><a href='#' id='trigger_ic_name'></a></div></td>
            </tr>
		</table>
        <div style="margin-top:20px;text-align:center">
            <a href="javascript:search_grid()" class="easyui-linkbutton" onclick="javascript:$('#search_win').dialog('close')">搜索</a>
        </div>
	</div>
    <!--end of 搜索窗口--> 
    <script type="text/javascript">
        $(document).ready(function () {
            FastSearch_Inventory(); //查询存货
            $F("trigger_ic_name").onclick = function () {
                AdvancedSearch_InventoryClass($("#ic_name").val());
            };
            $F("keyword").focus();
            $F("keyword").onkeypress = function (evt) {
                evt = evt ? evt : (window.event ? window.event : null);
                if (evt.keyCode == "13") {
                    search_grid();
                }
            }
        });
    </script>
</body>
</html>
