﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Data.SqlClient;
using SysCore;
using SysCore.Control;

public partial class M_Verify_SalesOrderVerify_OrderInfo : System.Web.UI.Page
{
    public Hashtable xview = new Hashtable();
    public AuthUI auth = new AuthUI();
    protected void Page_Load(object sender, EventArgs e)
    {
        int id = Convert.ToInt32(Request["id"]);
        new LoginState().CheckLoginM();
        SalesOrderDAL tdal = new SalesOrderDAL();
        SalesOrder tm = tdal.Get(id);
        if (tm.verify_uid != null)
        {
            xview["hide_btn_verify_doc"] = "display:none;";
        }
        else
        {
            xview["hide_btn_unverify_doc"] = "display:none;";
        }
        //销售订单信息
        xview.Add("order_number", tm.order_number);
        xview.Add("new_date", XTools.DateTimeToStandard(Convert.ToDateTime(tm.new_date)).ToString());
        if (tm.saletype != null)
        {
            xview.Add("st_name", tm.saletype.st_name);
        }
        if (tm.currency != null)
        {
            xview.Add("crc_name", tm.currency.crc_name);
        }
        xview.Add("new_user", tm.new_user);
        xview.Add("verify_user", tm.verify_user);
        xview.Add("remark", tm.remark);
        xview.Add("sum_price", tdal.GetTotalPrice(id));
        //客户信息
        if (tm.customer != null)
        {
            xview.Add("cus_code", tm.customer.cus_code);
            xview.Add("cus_name", tm.customer.cus_name);
            xview.Add("contact", tm.customer.contact);
            xview.Add("cus_cellphone", tm.customer.cellphone);
            xview.Add("cus_phone", tm.customer.phone);
            xview.Add("address", tm.customer.address);
        }
        if (tm.employee != null)
        {
            //业务员信息
            xview.Add("ele_name", tm.employee.ele_name);
            xview.Add("ele_cellphone", tm.employee.cellphone);
            xview.Add("ele_office_phone", tm.employee.office_phone);
        }
        //商品信息
        SalesOrdersDAL ddal = new SalesOrdersDAL();
        string sqld = @"select i.i_code,i.i_name,i.standard,i.munit,
                        d.tax_unit_price,d.quantity,d.tax_total_price,d.acc_fh_quantity,
                        convert(char(10),d.delivery_date,23) as delivery_date
                        from Sale_SalesOrders d
                        left join Base_Inventory i on d.i_id=i.i_id
                        where d.so_id=@so_id";
        sqld = sqld.Replace("@so_id", id.ToString());
        DataTable dt = new SqlUtil().GetDataTable(sqld, null);
        string details = "";
        foreach (DataRow dr in dt.Rows)
        {
            string html = @"
                        <li>
                        <span class='blue'>@i_name</span><br />
                        存货编码：@i_code<br/>
                        单位：@munit
                        &nbsp;
                        规格型号：@standard<br />
                        订单数量：@quantity 已发货数量：@acc_fh_quantity
                        <br/>
                        单价：@tax_unit_price<br />
                        金额：@tax_total_price<br/>
                        预发日期：@delivery_date<br/></li>";
            html = html.Replace("@i_code", dr["i_code"].ToString())
                        .Replace("@i_name", dr["i_name"].ToString())
                        .Replace("@standard", dr["standard"].ToString())
                        .Replace("@munit", dr["munit"].ToString())
                        .Replace("@tax_unit_price", dr["tax_unit_price"].ToString())
                        .Replace("@quantity", dr["quantity"].ToString())
                        .Replace("@acc_fh_quantity", dr["acc_fh_quantity"].ToString())
                        .Replace("@tax_total_price", dr["tax_total_price"].ToString())
                        .Replace("@delivery_date", dr["delivery_date"].ToString());
            details += html;
        }
        xview.Add("details", details);
    }
}