﻿<%@ Page Language="C#" AutoEventWireup="true" CodeFile="PurchaseOrderVerify_OrderInfo.aspx.cs" Inherits="M_Verify_PurchaseOrderVerify_OrderInfo" %>

<%@ Register Src="~/M/Include/MScript.ascx" TagPrefix="uc1" TagName="MScript" %>
<%@ Register Src="~/M/Include/MHeader.ascx" TagPrefix="uc1" TagName="MHeader" %>
<%@ Register Src="~/M/Include/MFooter.ascx" TagPrefix="uc1" TagName="MFooter" %>

<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title>采购入库单</title>
    <uc1:MScript runat="server" ID="MScript" />
</head>
<body>
    <uc1:MHeader runat="server" ID="MHeader" />
    <div id="div_filter" style="display:none;height:200px">
    </div>
    <!-- start page -->
    <div id="main_content" class="page">
            <div id="info_bar">
                <input type="button" id="btn_verify_doc" value="审核" class="submit-button" onclick="verify_doc(1)" style='<%=xview["hide_btn_verify_doc"] %>;<%=auth.AuthView("Phone_Approve_PurchaseInVerify")%>'/>
                <input type="button" id="btn_unverify_doc" value="弃审" class="submit-button" onclick="verify_doc(-1)" style='<%=xview["hide_btn_unverify_doc"] %>;<%=auth.AuthView("Phone_Approve_PurchaseInCancelVerify")%>'/>
            </div>
            <div class="simplebox">
            	<h1 class="titleh">采购订单信息</h1>
                <div class="content">
                    <ul class="statistics">
                        单据编号：<%=xview["order_number"]%><br />
                        单据日期：<%=xview["new_date"]%><br />
                        业务类型：<%=xview["pt_name"]%><br />
                        币种：<%=xview["crc_name"]%><br />
                        单据金额：<%=xview["sum_price"]%><br />
                        制单人：<%=xview["new_user"]%><br />
                        审核人：<%=xview["verify_user"]%><br />
                    </ul>
                </div>
             </div>
            <div class="simplebox">
            	<h1 class="titleh">供应商信息</h1>
                <div class="content">
                    <ul class="statistics">
                        供应商编号：<%=xview["vd_code"]%><br />
                        供应商名称：<%=xview["vd_name"]%><br />
                        联系人：<%=xview["contact"]%><br />
                        手机：<%=xview["vd_cellphone"]%><br />
                        电话：<%=xview["vd_phone"]%><br />
                        地址：<%=xview["address"]%><br />
                    </ul>
                </div>
             </div>
            <div class="simplebox">
            	<h1 class="titleh">业务员信息</h1>
                <div class="content">
                    <ul class="statistics">
                        业务员：<%=xview["ele_name"]%><br />
                        手机：<%=xview["ele_cellphone"]%><br />
                        办公电话：<%=xview["ele_office_phone"]%><br />
                    </ul>
                </div>
             </div>
            <div class="simplebox">
            	<h1 class="titleh">商品明细</h1>
                <div class="content">
                    <ul class="statistics"><%=xview["details"]%></ul>
                </div>
             </div>
        <uc1:MFooter runat="server" ID="MFooter" />
    </div>
    <!-- end page -->
    <script type="text/javascript">
        var id = '<%=Request["id"]%>';
        //审核
        function verify_doc(action_type) {
            var title = '审核';
            if (action_type == -1)
                title = '弃审';
            if (confirm('确定要' + title + '本单据吗?')) {
                $.ajax({
                    type: "POST",
                    contentType: "application/json",
                    url: '../../Purchase/PurchaseIn/PurchaseIn_Service.asmx/Verify',
                    data: "{ids:'" + id + "',action_type:'" + action_type + "'}",
                    dataType: 'json',
                    success: function (result) {
                        if (result.d == "success") {
                            alert(title + '成功！');
                            if (action_type == 1) {
                                $("#btn_verify_doc").css("display", "none");
                                $("#btn_unverify_doc").css("display", "");
                            } else {
                                $("#btn_unverify_doc").css("display", "none");
                                $("#btn_verify_doc").css("display", "");
                            }
                        } else {
                            alert(result.d);
                        }
                    }
                });
            }
        }
    </script>
</body>
</html>


