﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Data.SqlClient;
using SysCore;
using SysCore.Control;

public partial class M_Verify_PurchaseInVerify_OrderInfo : System.Web.UI.Page
{
    public Hashtable xview = new Hashtable();
    public AuthUI auth = new AuthUI();
    protected void Page_Load(object sender, EventArgs e)
    {
        int id = Convert.ToInt32(Request["id"]);
        new LoginState().CheckLoginM();
        InOutDAL tdal = new InOutDAL();
        InOut tm = tdal.Get(id);
        if (tm.verify_uid != null)
        {
            xview["hide_btn_verify_doc"] = "display:none;";
        }
        else
        {
            xview["hide_btn_unverify_doc"] = "display:none;";
        }
        //销售订单信息
        xview.Add("order_number", tm.order_number);
        xview.Add("new_date", XTools.DateTimeToStandard(Convert.ToDateTime(tm.new_date)).ToString());
        xview.Add("pt_name", tm.purchasetype.pt_name);
        xview.Add("new_user", tm.new_user);
        xview.Add("verify_user", tm.verify_user);
        xview.Add("sum_price", tdal.GetTotalPrice(id));
        //客户信息
        xview.Add("vd_code", tm.vendor.vd_code);
        xview.Add("vd_name", tm.vendor.vd_name);
        xview.Add("contact", tm.vendor.contact);
        xview.Add("vd_cellphone", tm.vendor.cellphone);
        xview.Add("vd_phone", tm.vendor.phone);
        xview.Add("address", tm.vendor.address);
        //业务员信息
        if (tm.employee != null)
        {
            xview.Add("ele_name", tm.employee.ele_name);
            xview.Add("ele_cellphone", tm.employee.cellphone);
            xview.Add("ele_office_phone", tm.employee.office_phone);
        }
        //商品信息
        InOutsDAL ddal = new InOutsDAL();
        string sqld = @"select i.i_code,i.i_name,i.standard,i.munit,
                        d.tax_unit_price,d.quantity,d.tax_total_price
                        from Stock_InOuts d
                        left join Stock_InOut t on t.io_id=d.io_id
                        left join Base_Inventory i on d.i_id=i.i_id
                        where d.io_id=@io_id";
        sqld = sqld.Replace("@io_id", id.ToString());
        DataTable dt = new SqlUtil().GetDataTable(sqld, null);
        string details = "";
        foreach (DataRow dr in dt.Rows)
        {
            string html = @"
                        <li>
                        <span class='blue'>@i_name</span><br />
                        存货编码：@i_code<br/>
                        单位：@munit
                        &nbsp;
                        规格型号：@standard<br />
                        入库数量：@quantity
                        <br/>
                        单价：@tax_unit_price<br />
                        金额：@tax_total_price<br/>
                        </li>";
            html = html.Replace("@i_code", dr["i_code"].ToString())
                        .Replace("@i_name", dr["i_name"].ToString())
                        .Replace("@standard", dr["standard"].ToString())
                        .Replace("@munit", dr["munit"].ToString())
                        .Replace("@tax_unit_price", dr["tax_unit_price"].ToString())
                        .Replace("@quantity", dr["quantity"].ToString())
                        .Replace("@tax_total_price", dr["tax_total_price"].ToString());
            details += html;
        }
        xview.Add("details", details);
    }
}