﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Data.SqlClient;
using SysCore;
using SysCore.Control;

public partial class M_Verify_PurchaseInVerify_Load : System.Web.UI.Page
{
    public Hashtable xview = new Hashtable();
    SqlUtil su = new SqlUtil();
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!Page.IsPostBack)
        {
            new LoginState().CheckLogin();
            CreateGrid();
        }
    }
    string sql_list = "";
    /// <summary>
    /// 绑定控件数据源
    /// </summary>
    public void CreateGrid()
    {
        //列表查询用的sql
        sql_list = @"
            select t.io_id,t.new_date,vd.vd_name,t.order_number,d.sum_price,
            t.new_user,t.verify_user,ele.ele_name
            from Stock_InOut t
            left join Base_Vendor vd on t.vd_id=vd.vd_id
            left join Base_Employee ele on t.ele_id=ele.ele_id
            left join
            (
	            select io_id,SUM(tax_total_price) as sum_price
	            from Stock_InOuts group by io_id
            ) d on t.io_id=d.io_id
            where t.order_type=3 ";



        int page = 1;//当前页
        if (Request["page"] != null)
            page = Convert.ToInt32(Request["page"]);
        int page_size = new PhoneConfig().default_page_size;//每页显示条数

        Hashtable ht = new Hashtable();
        //排序
        string order_field = "order by io_id desc";
        ht.Add("order_field", order_field);
        ht.Add("page", page);
        ht.Add("page_size", page_size);
        //查询条件
        string sql_end = "";
        if (!Request["keyword"].Equals(""))
        {
            //要搜索关键字
            string keyword = Request["keyword"].ToString();
            //要搜索的字段
            string search_fields = "order_number,vd_name,new_user,ele_name,verify_user";
            sql_end = FastSearh.MakeSearchSqlForWhere(keyword, search_fields);
        }
        string begin_date = Request["begin_date"];
        string end_date = Request["end_date"];
        if (!begin_date.Equals(""))
        {
            sql_list += " and new_date >= '" + begin_date + "'";
        }
        if (!end_date.Equals(""))
        {
            sql_list += " and new_date <= '" + end_date + "'";
        }
        string is_verify = Request["is_verify"];
        if (is_verify.Equals("0"))
        {
            sql_list += " and isnull(verify_user,'')=''";
        }
        if (is_verify.Equals("1"))
        {
            sql_list += " and isnull(verify_user,'')<>''";
        }
        ht.Add("sql_end", sql_end);
        //查询后返回DataTable
        DataTable dt = GetList(ht);
        string append = "";
        foreach (DataRow dr in dt.Rows)
        {
            string html = @"
                        <li onclick='window.location=@url'>
                        <span class='blue'>@vd_name</span><br />
                        订单号：@order_number<br />
                        下单日期：@new_date<br />
                        制单人：@new_user
                        &nbsp;&nbsp;
                        审核人：@verify_user<br />
                        销售金额：@sum_price<br />
                        </li>";
            html = html.Replace("@url", "\"PurchaseInVerify_OrderInfo.aspx?id=@io_id\"")
                        .Replace("@io_id", dr["io_id"].ToString())
                        .Replace("@vd_name", dr["vd_name"].ToString())
                        .Replace("@new_user", dr["new_user"].ToString())
                        .Replace("@ele_name", dr["ele_name"].ToString())
                        .Replace("@verify_user", dr["verify_user"].ToString())
                        .Replace("@new_date", XTools.DateTimeToStandard(Convert.ToDateTime(dr["new_date"].ToString())))
                        .Replace("@sum_price", dr["sum_price"].ToString())
                        .Replace("@order_number", dr["order_number"].ToString());
            append += html;

        }
        Response.Write(append);
    }

    /// <summary>
    /// 得到列表
    /// </summary>
    /// <param name="sql_select_field">格式定义指定显示列</param>
    /// <returns>DataTable</returns>
    public DataTable GetList(Hashtable pg)
    {
        string order_field = pg["order_field"].ToString();
        string sql = @"select top 1000000000 ROW_NUMBER() OVER(@order_field) AS row_num,* 
                from(@sql_list)t where 1=1 ";
        sql = sql.Replace("@sql_list", sql_list)
                 .Replace("@order_field", order_field);
        //分页处理与查询条件
        PageHelper ph = new PageHelper();
        sql = ph.GetPageSQL(sql, pg, true);//得到分页后的SQL
        //Response.Write(sql);
        //Response.End();
        DataTable dt = new SqlUtil().GetDataTable(sql, null);
        return dt;
    }
}