﻿<%@ Page Language="C#" AutoEventWireup="true" CodeFile="PurchaseInVerify_List.aspx.cs" Inherits="M_Verify_PurchaseInVerify_List" %>

<%@ Register Src="~/M/Include/MScript.ascx" TagPrefix="uc1" TagName="MScript" %>
<%@ Register Src="~/M/Include/MHeader.ascx" TagPrefix="uc1" TagName="MHeader" %>
<%@ Register Src="~/M/Include/MFooter.ascx" TagPrefix="uc1" TagName="MFooter" %>
<%@ Register Src="~/M/Include/MDate.ascx" TagPrefix="uc1" TagName="MDate" %>

<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title>采购入库单列表</title>
    <uc1:MScript runat="server" ID="MScript" />
    <uc1:MDate runat="server" ID="MDate" />
</head>
<body>
    <uc1:MHeader runat="server" ID="MHeader" />
    <div id="div_filter" style="display:none;height:200px">
        <table class="filter_table">
            <tr>
                <td class="filter_td_1">是否审批：</td>
                <td class="filter_td_2">
                    <select id="is_verify">
                        <option value="" selected="selected">全部</option>
                        <option value="0">未审</option>
                        <option value="1">已审</option>
                    </select></td>
            </tr>
            <tr>
                <td class="filter_td_1">开始日期：</td>
                <td class="filter_td_2"><input id='begin_date' value='' /></td>
            </tr>
            <tr>
                <td class="filter_td_1">截止日期：</td>
                <td class="filter_td_2"><input id='end_date' value='' /></td>
            </tr>
        </table>
        <a href='javascript:search_list()' class="filter_button">确定</a>
        <a href='javascript:hide_filter()' class="filter_button" style="margin-left:20px">取消</a>
    </div>
    <!-- start page -->
    <div id="main_content" class="page">
            <div class="simplebox">
                <div class="content">
                    <ul class="statistics" id="data_list"></ul>
                    <div id="load_more">正在加载..</div>
                </div>
             </div>
        <uc1:MFooter runat="server" ID="MFooter" />
    </div>
    <!-- end page -->
    <script type="text/javascript">
        var title = "采购入库单列表";
        $("#header-title").html(title);//设置标题
        $("#btn_search").css("display", "");//显示搜索按钮
        load_by_scroll = true;//允许上翻加载更多数据
        //搜索
        function search_list() {
            page = 1;//搜索后定位到第1页
            $("#data_list").html("");//清空列表数据
            hide_filter();//隐藏过滤框
            show_hide_search_bar();//显示/隐藏搜索条
            load_page();
        }
        //加载数据
        function load_page() {
            var par = "";
            par += "&keyword=" + $("#txt_search").val()
                + "&is_verify=" + $("#is_verify").val()
                + "&begin_date=" + $("#begin_date").val()
                + "&end_date=" + $("#end_date").val();
            load_data("PurchaseInVerify_Load.aspx", par);
        }
        //设置文本框为日历控件
        set_date_control("begin_date");
        set_date_control("end_date");
        //打开页面后立即加载数据
        window.onload = function () {
            load_page();
        }
    </script>
</body>
</html>


