﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Data.SqlClient;
using SysCore;
using SysCore.Control;

public partial class M_Verify_DeliveryOrderVerify_Load : System.Web.UI.Page
{
    public Hashtable xview = new Hashtable();
    SqlUtil su = new SqlUtil();
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!Page.IsPostBack)
        {
            new LoginState().CheckLogin();
            CreateGrid();
        }
    }
    string sql_list = "";
    /// <summary>
    /// 绑定控件数据源
    /// </summary>
    public void CreateGrid()
    {
        //列表查询用的sql
        sql_list = @"
            select t.do_id,t.new_date,cus.cus_name,t.order_number,d.sum_price,
            t.new_user,t.verify_user,ele.ele_name
            from Sale_DeliveryOrder t
            left join Base_Customer cus on t.cus_id=cus.cus_id
            left join Base_Employee ele on t.ele_id=ele.ele_id
            left join
            (
	            select do_id,SUM(tax_total_price) as sum_price
	            from Sale_DeliveryOrders group by do_id
            ) d on t.do_id=d.do_id
            where 1=1 ";



        int page = 1;//当前页
        if (Request["page"] != null)
            page = Convert.ToInt32(Request["page"]);
        int page_size = new PhoneConfig().default_page_size;//每页显示条数

        Hashtable ht = new Hashtable();
        //排序
        string order_field = "order by do_id desc";
        ht.Add("order_field", order_field);
        ht.Add("page", page);
        ht.Add("page_size", page_size);
        //查询条件
        string sql_end = "";
        if (!Request["keyword"].Equals(""))
        {
            //要搜索关键字
            string keyword = Request["keyword"].ToString();
            //要搜索的字段
            string search_fields = "order_number,cus_name,new_user,ele_name,verify_user";
            sql_end = FastSearh.MakeSearchSqlForWhere(keyword, search_fields);
        }
        string begin_date = Request["begin_date"];
        string end_date = Request["end_date"];
        if (!begin_date.Equals(""))
        {
            sql_list += " and new_date >= '" + begin_date + "'";
        }
        if (!end_date.Equals(""))
        {
            sql_list += " and new_date <= '" + end_date + "'";
        }
        string is_verify = Request["is_verify"];
        if (is_verify.Equals("0"))
        {
            sql_list += " and isnull(verify_user,'')=''";
        }
        if (is_verify.Equals("1"))
        {
            sql_list += " and isnull(verify_user,'')<>''";
        }
        ht.Add("sql_end", sql_end);
        //查询后返回DataTable
        DataTable dt = GetList(ht);
        string append = "";
        foreach (DataRow dr in dt.Rows)
        {
            string html = @"
                        <li onclick='window.location=@url'>
                        <span class='blue'>@cus_name</span><br />
                        发货单号：@order_number<br />
                        下单日期：@new_date<br />
                        制单人：@new_user
                        &nbsp;&nbsp;
                        审核人：@verify_user<br />
                        发货金额：@sum_price<br />
                        </li>";
            html = html.Replace("@url", "\"DeliveryOrderVerify_OrderInfo.aspx?id=@do_id\"")
                        .Replace("@do_id", dr["do_id"].ToString())
                        .Replace("@cus_name", dr["cus_name"].ToString())
                        .Replace("@ele_name", dr["ele_name"].ToString())
                        .Replace("@new_user", dr["new_user"].ToString())
                        .Replace("@verify_user", dr["verify_user"].ToString())
                        .Replace("@new_date", XTools.DateTimeToStandard(Convert.ToDateTime(dr["new_date"].ToString())))
                        .Replace("@sum_price", dr["sum_price"].ToString())
                        .Replace("@order_number", dr["order_number"].ToString());
            append += html;

        }
        Response.Write(append);
    }

    /// <summary>
    /// 得到列表
    /// </summary>
    /// <param name="sql_select_field">格式定义指定显示列</param>
    /// <returns>DataTable</returns>
    public DataTable GetList(Hashtable pg)
    {
        string order_field = pg["order_field"].ToString();
        string sql = @"select top 1000000000 ROW_NUMBER() OVER(@order_field) AS row_num,* 
                from(@sql_list)t where 1=1 ";
        sql = sql.Replace("@sql_list", sql_list)
                 .Replace("@order_field", order_field);
        //分页处理与查询条件
        PageHelper ph = new PageHelper();
        sql = ph.GetPageSQL(sql, pg, true);//得到分页后的SQL
        //Response.Write(sql);
        //Response.End();
        DataTable dt = new SqlUtil().GetDataTable(sql, null);
        return dt;
    }
}