﻿<%@ Page Language="C#" AutoEventWireup="true" CodeFile="Inventory_List.aspx.cs" Inherits="M_Stock_Inventory_List" %>

<%@ Register Src="~/M/Include/MScript.ascx" TagPrefix="uc1" TagName="MScript" %>
<%@ Register Src="~/M/Include/MHeader.ascx" TagPrefix="uc1" TagName="MHeader" %>
<%@ Register Src="~/M/Include/MFooter.ascx" TagPrefix="uc1" TagName="MFooter" %>
<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title>商品查询</title>
    <uc1:MScript runat="server" ID="MScript" />
    <style type="text/css">
    </style>
</head>
<body>
    <uc1:MHeader runat="server" ID="MHeader" />
    <div id="div_filter" style="display:none;height:160px">
        <table class="filter_table">
            <tr>
                <td class="filter_td_1">存货分类：</td>
                <td class="filter_td_2"><%=xview["inv_class"]%></td>
            </tr>
            <tr>
                <td class="filter_td_1">只显示销售件：</td>
                <td class="filter_td_2">
                    <select id="is_sale" style='width:80%'>
                        <option value="1">是</option>
                        <option value="" selected="selected">否</option>
                    </select></td>
            </tr>
        </table>
        <br />
        <a href='javascript:search_list()' class="filter_button">确定</a>
        <a href='javascript:hide_filter()' class="filter_button" style="margin-left:20px">取消</a>
    </div>
    <!-- start page -->
    <div id="main_content" class="page">
        <div class="simplebox">
            <div class="content">
                <ul class="statistics" id="data_list"></ul>
                <div id="load_more">正在加载..</div>
            </div>
        </div>
        <uc1:MFooter runat="server" ID="MFooter" />
    </div>
    <!-- end page -->
    <div id="div_preview" class="win_preview" style="display: none;">
        <div class="win_preview_header">
            <a href="javascript:hide_preview()" class="button back" style="padding-top:9px;margin-top:7px;">
                <img src="../img/back-button.png"/></a>
        </div>
        <img id="img_preview" src="" />
    </div>
    <script type="text/javascript">
        var title = "商品查询";
        $("#header-title").html(title);//设置标题
        $("#btn_search").css("display", "");//显示搜索按钮
        load_by_scroll = true;//允许上翻加载更多数据
        //搜索
        function search_list() {
            page = 1;//搜索后定位到第1页
            $("#data_list").html("");//清空列表数据
            hide_filter();//隐藏过滤框
            show_hide_search_bar();//显示/隐藏搜索条
            load_page();
        }
        //加载数据
        function load_page() {
            var par = "";
            par += "&keyword=" + $("#txt_search").val()
                 + "&ic_code=" + $("#ic_code").val()
                 + "&is_sale=" + $("#is_sale").val();
            load_data("Inventory_List_Load.aspx", par);
        }
        //页面全部加载后
        window.onload = function () {
            load_page();
        }
        //预览图片
        function view_pic(url) {
            $("#div_preview").css("display", "");
            $F("img_preview").src = url;
        }
        //隐藏预览窗口
        function hide_preview() {
            $("#div_preview").css("display", "none");
        }
    </script>
</body>
</html>


