﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Data.SqlClient;
using SysCore;
using SysCore.Control;

public partial class M_Sale_Customer_List_Load : System.Web.UI.Page
{
    public Hashtable xview = new Hashtable();

    protected void Page_Load(object sender, EventArgs e)
    {
        if (!Page.IsPostBack)
        {
            new LoginState().CheckLogin();
            CreateGrid();
        }
    }
    string sql_list = "";
    /// <summary>
    /// 绑定控件数据源
    /// </summary>
    public void CreateGrid()
    {
        //列表查询用的sql
        sql_list = @"
            select cus.cus_id,cus.cus_code,cus.cus_name,cc.cc_code,cc.cc_name,
            cus.contact,cus.phone,cus.cellphone,
            t2.ying_shou-isnull(t3.shou_kuan,0) as balance
            from Base_Customer cus 
            left join Base_CustomerClass cc on cc.cc_id=cus.cc_id 
            left join
            (
                select cus_id,sum(nat_tax_total_price) as ying_shou
                from ARAP_APDetail
                where rp_flag='AR'
                group by cus_id
            ) t2 on cus.cus_id=t2.cus_id
            left join
            (
                select cus_id,sum(nat_amount) as shou_kuan
                from ARAP_SFKuan
                where rp_flag='AR' and isnull(verify_user,'')<>''
                group by cus_id
            ) t3 on cus.cus_id=t3.cus_id";

        int page = 1;//当前页
        if (Request["page"] != null)
            page = Convert.ToInt32(Request["page"]);
        int page_size = new PhoneConfig().default_page_size;//每页显示条数

        Hashtable ht = new Hashtable();
        //排序
        string order_field = "order by cus_code asc";
        ht.Add("order_field", order_field);
        ht.Add("page", page);
        ht.Add("page_size", page_size);
        //查询条件
        string sql_end = "";
        if (!Request["keyword"].Equals(""))
        {
            //要搜索关键字
            string keyword = Request["keyword"].ToString();
            //要搜索的字段
            string search_fields = "cus_code,cus_name";
            sql_end = FastSearh.MakeSearchSqlForWhere(keyword, search_fields);
        }
        //存货分类
        if (!Request["cc_code"].Equals(""))
        {
            sql_end += " and cc_code like '%" + Request["cc_code"] + "'";
        }

        ht.Add("sql_end", sql_end);
        //查询后返回DataTable
        DataTable dt = GetList(ht);
        string append = "";
        foreach (DataRow dr in dt.Rows)
        {
            string html = @"
                        <li>
                        <span class='blue'><b>@cus_name</b></span><br />
                        客户编码：@cus_code<br/>
                        分类：@cc_name<br />
                        联系：@contact @phone @cellphone<br />
                        应收：@balance<br />
                        <br/></li>";
            html = html.Replace("@cus_code", dr["cus_code"].ToString())
                        .Replace("@cc_name", dr["cc_name"].ToString())
                        .Replace("@cus_name", dr["cus_name"].ToString())
                        .Replace("@contact", dr["contact"].ToString())
                        .Replace("@cellphone", dr["cellphone"].ToString())
                        .Replace("@phone", dr["phone"].ToString())
                        .Replace("@balance", dr["balance"].ToString());
            append += html;

        }
        Response.Write(append);
    }

    /// <summary>
    /// 得到列表
    /// </summary>
    /// <param name="sql_select_field">格式定义指定显示列</param>
    /// <returns>DataTable</returns>
    public DataTable GetList(Hashtable pg)
    {
        string order_field = pg["order_field"].ToString();
        string sql = @"select top 1000000000 ROW_NUMBER() OVER(@order_field) AS row_num,* 
                from(@sql_list)t where 1=1 ";
        sql = sql.Replace("@sql_list", sql_list)
                 .Replace("@order_field", order_field);
        //分页处理与查询条件
        PageHelper ph = new PageHelper();
        sql = ph.GetPageSQL(sql, pg, true);//得到分页后的SQL
        //Response.Write(sql);
        //Response.End();
        DataTable dt = new SqlUtil().GetDataTable(sql, null);
        return dt;
    }
}