﻿<%@ Page Language="C#" AutoEventWireup="true" CodeFile="Customer_List.aspx.cs" Inherits="M_Sale_Customer_List" %>

<%@ Register Src="~/M/Include/MScript.ascx" TagPrefix="uc1" TagName="MScript" %>
<%@ Register Src="~/M/Include/MHeader.ascx" TagPrefix="uc1" TagName="MHeader" %>
<%@ Register Src="~/M/Include/MFooter.ascx" TagPrefix="uc1" TagName="MFooter" %>
<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title>客户查询</title>
    <uc1:MScript runat="server" ID="MScript" />
</head>
<body>
    <uc1:MHeader runat="server" ID="MHeader" />
    <div id="div_filter" style="display:none;height:160px">
        <table class="filter_table">
            <tr>
                <td class="filter_td_1">客户分类：</td>
                <td class="filter_td_2"><%=xview["cus_class"]%></td>
            </tr>
        </table>
        <br />
        <a href='javascript:search_list()' class="filter_button">确定</a>
        <a href='javascript:hide_filter()' class="filter_button" style="margin-left:20px">取消</a>
    </div>
    <!-- start page -->
    <div id="main_content" class="page">
            <div class="simplebox">
                <div class="content">
                    <ul class="statistics" id="data_list"></ul>
                    <div id="load_more">正在加载..</div>
                </div>
             </div>
        <uc1:MFooter runat="server" ID="MFooter" />
    </div>
    <!-- end page -->
    <script type="text/javascript">
        var title = "客户查询";
        $("#header-title").html(title);//设置标题
        $("#btn_search").css("display", "");//显示搜索按钮
        load_by_scroll = true;//允许上翻加载更多数据
        //搜索
        function search_list() {
            page = 1;//搜索后定位到第1页
            $("#data_list").html("");//清空列表数据
            hide_filter();//隐藏过滤框
            show_hide_search_bar();//显示/隐藏搜索条
            load_page();
        }
        //加载数据
        function load_page() {
            var par = "";
            par += "&keyword=" + $("#txt_search").val()
                 + "&cc_code=" + $("#cc_code").val();
            load_data("Customer_List_Load.aspx", par);
        }
        //页面全部加载后
        window.onload = function () {
            load_page();
        }
    </script>
</body>
</html>


