﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Data.SqlClient;
using SysCore;
using SysCore.Control;

public partial class M_Report_SaleTrend_Load : System.Web.UI.Page
{
    public Hashtable xview = new Hashtable();

    protected void Page_Load(object sender, EventArgs e)
    {
        if (!Page.IsPostBack)
        {
            new LoginState().CheckLogin();
            DrawReport();
        }
    }
    
    /// <summary>
    /// 绑定控件数据源
    /// </summary>
    public void DrawReport()
    {
        //查询用的sql
        string sql_list = @"
                select month(do.new_date) as name,
                SUM(dos.nat_tax_total_price) as value
                from Sale_DeliveryOrders dos
                left join Sale_DeliveryOrder do on dos.do_id=do.do_id
                where isnull(do.verify_user,'')!='' 
                and year(do.new_date)=@years
                group by month(new_date)
                order by month(new_date)";
        string year = DateTime.Parse(new LoginInfo().login_date).Year.ToString();
        sql_list = sql_list.Replace("@years", Request["years"]);
        /*
        //存货分类
        if (!Request["cc_code"].Equals(""))
        {
            sql_end += " and cc_code like '%" + Request["cc_code"] + "'";
        }*/
        //变换颜色
        string[] arr_color = new string[6] { "#4572a7", "#aa4643", "#89a54e", "#80699b", "#3d96ae","#cbab4f" };
        //查询后返回DataTable
        DataTable dt = new SqlUtil().GetDataTable(sql_list, null);
        string names = "";
        string values = ""; 
        int iter = 0;

        foreach (DataRow dr in dt.Rows)
        {
            string name = dr["name"].ToString();
            string value = dr["value"].ToString();
            names += "\"" + name + "月\",";
            values += value + ",";
            iter++;
        }
        if (values.Length > 0)
        {
            names = names.Substring(0, names.Length - 1);
            values = values.Substring(0, values.Length - 1);
        }

        names = "[" + names + "]";
        values = "[" + values + "]";
        Response.Write(names + "[split_line]" + values);
    }

}