﻿<%@ Page Language="C#" AutoEventWireup="true" CodeFile="SaleTrend.aspx.cs" Inherits="M_Report_SaleTrend" %>
<%@ Register Src="~/M/Include/MScript.ascx" TagPrefix="uc1" TagName="MScript" %>
<%@ Register Src="~/M/Include/MHeader.ascx" TagPrefix="uc1" TagName="MHeader" %>
<%@ Register Src="~/M/Include/MFooter.ascx" TagPrefix="uc1" TagName="MFooter" %>
<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title>销售趋势</title>
    <uc1:MScript runat="server" ID="MScript" />
	<script type="text/javascript" src="../JS/iChartJS/ichart.1.2.min.js"></script>
	<link rel="stylesheet" href="../JS/iChartJS/demo.css" type="text/css"/>
	<style type="text/css">
	</style>
</head>
<body>
    <uc1:MHeader runat="server" ID="MHeader" />
    <div id="div_filter" style="display:none;height:160px">
        <table class="filter_table">
            <tr>
                <td class="filter_td_1">年份：</td>
                <td class="filter_td_2"><%=xview["years"]%>
                </td>
            </tr>
        </table>
        <br />
        <a href='javascript:search_list()' class="filter_button">确定</a>
        <a href='javascript:hide_filter()' class="filter_button" style="margin-left:20px">取消</a>
    </div>
    <!-- start page -->
   <div id="main_content" class="page_top">
        <div id='canvasDiv'></div>
    </div>
    <!-- end page -->
    <script type="text/javascript">
        $("#btn_filter").css("display", "");//显示过滤按钮
        load_by_scroll = false;
        var report_labels = "";
        var report_data = "";
        //绘制图表
        function load_data() {
            var title = $("#years").val()+'年销售趋势';
            var data = [

			        	{

			        	    name: '北京',

			        	    value: report_data,//[-9, 1, 12, 20, 26, 30, 32, 29, 22, 12, 0, -6],

			        	    color: '#1f7e92',

			        	    line_width: 3

			        	}

            ];

            var chart = new iChart.LineBasic2D({

                render: 'canvasDiv',

                data: data,

                title: title,

                width: window.innerWidth,
                height: window.innerHeight - 48,
                animation: true,//开启过渡动画
                animation_duration: 800,//8秒完成动画

                coordinate: { height: '90%', background_color: '#f6f9fa' },

                sub_option: {

                    hollow_inside: false,//设置一个点的亮色在外环的效果

                    point_size: 16

                },
                //["一月", "二月", "三月", "四月", "五月", "六月", "七月", "八月", "九月", "十月", "十一月", "十二月"]
                labels: report_labels

            });

            chart.draw();

        }
        //加载数据
        function search_list() {
            var html = $.ajax({
                type: "POST",
                url: 'SaleTrend_Load.aspx',
                data: "years=" + $("#years").val(),
                async: false
            }).responseText;
            //alert(html); //return;
            hide_filter();//隐藏过滤框
            var arr = html.split("[split_line]");
            var names = arr[0];
            var values = arr[1];

            if (values == "[]") {
                $("#canvasDiv").html("<div class='no_result'>查询范围内未统计出数据<br/><br/>请点右上角图标更改范围</div>");
                return;
            }

            report_labels = eval('(' + names + ')');//转换成JSON
            report_data = eval('(' + values + ')');//转换成JSON
            load_data();
        }
        //页面全部加载后
        window.onload = function () {
            search_list();
        }
    </script>
</body>
</html>


