﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Data.SqlClient;
using SysCore;
using SysCore.Control;

public partial class M_Report_EmployeeSale_Load : System.Web.UI.Page
{
    public Hashtable xview = new Hashtable();

    protected void Page_Load(object sender, EventArgs e)
    {
        if (!Page.IsPostBack)
        {
            new LoginState().CheckLogin();
            DrawReport();
        }
    }
    
    /// <summary>
    /// 绑定控件数据源
    /// </summary>
    public void DrawReport()
    {
        DateTime today = DateTime.Parse(new LoginInfo().login_date);
        string begin_date;
        string end_date;
        Hashtable ht = TimeHelper.GetRang(today, Request["range"]);
        //开始日期
        begin_date = ht["begin_date"].ToString();
        //结束日期
        end_date = ht["end_date"].ToString();
        //查询用的sql
        string sql_list = @"
                select ele.ele_id,ele.ele_name as name,
                SUM(dos.nat_tax_total_price) as value
                from Sale_DeliveryOrders dos
                left join Sale_DeliveryOrder do on dos.do_id=do.do_id
                left join Base_Employee ele on do.ele_id=ele.ele_id
                where isnull(do.verify_user,'')!='' 
                and do.new_date between '@begin_date' and '@end_date'
                group by ele.ele_id,ele.ele_name
                order by SUM(dos.nat_tax_total_price) desc";
        string year = DateTime.Parse(new LoginInfo().login_date).Year.ToString();
        sql_list = sql_list.Replace("@begin_date", begin_date)
                           .Replace("@end_date", end_date);

        //变换颜色
        string[] arr_color = new string[6] { "#4572a7", "#aa4643", "#89a54e", "#80699b", "#3d96ae","#cbab4f" };
        //查询后返回DataTable
        DataTable dt = new SqlUtil().GetDataTable(sql_list, null);
        string append = "";
        int iter = 0; 
        foreach (DataRow dr in dt.Rows)
        {
            //6个颜色交替循环显示
            if (iter == arr_color.Length)
                iter = 0;
            string name = dr["name"].ToString();
            string value = dr["value"].ToString();
            string color = arr_color[iter];
            append += "{ name: '" + name + "', value: " + value + ", color: '" + color + "' },";
            iter++;
        }
        if (append.Length > 0)
        {
            append = append.Substring(0, append.Length - 1);
        }
        append = "[" + append + "]";
        Response.Write(append);
    }

}