﻿<%@ Page Language="C#" AutoEventWireup="true" CodeFile="EmployeeSale.aspx.cs" Inherits="M_Report_EmployeeSale" %>
<%@ Register Src="~/M/Include/MScript.ascx" TagPrefix="uc1" TagName="MScript" %>
<%@ Register Src="~/M/Include/MHeader.ascx" TagPrefix="uc1" TagName="MHeader" %>
<%@ Register Src="~/M/Include/MFooter.ascx" TagPrefix="uc1" TagName="MFooter" %>
<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title>业务员业绩统计</title>
    <uc1:MScript runat="server" ID="MScript" />
	<script type="text/javascript" src="../JS/iChartJS/ichart.1.2.min.js"></script>
	<link rel="stylesheet" href="../JS/iChartJS/demo.css" type="text/css"/>
	<style type="text/css">
	</style>
</head>
<body>
    <uc1:MHeader runat="server" ID="MHeader" />
    <div id="div_filter" style="display:none;height:160px">
        <table class="filter_table">
            <tr>
                <td class="filter_td_1">统计范围：</td>
                <td class="filter_td_2">            
                    <select id="range" onchange="init_page()">
                        <option value="day">本日</option>
                        <option value="week">本周</option>
                        <option value="month" selected>本月</option>
                        <option value="season">本季</option>
                        <option value="year">本年</option>
                    </select></td>
            </tr>
        </table>
        <br />
        <a href='javascript:search_list()' class="filter_button">确定</a>
        <a href='javascript:hide_filter()' class="filter_button" style="margin-left:20px">取消</a>
    </div>
    <!-- start page -->
   <div id="main_content" class="page_top">
        <div id='canvasDiv'></div>
    </div>
    <!-- end page -->
    <script type="text/javascript">
        $("#btn_filter").css("display", "");//显示过滤按钮
        load_by_scroll = false;
        var report_data = "";
        //绘制图表
        function load_data() {
            var title = '业务员业绩统计';
            $(function () {
                new iChart.Bar2D({
                    render: 'canvasDiv',
                    data: report_data,
                    title: title,
                    //showpercent: true,//百分比显示
                    //decimalsnum: 2,//小数位
                    //fit:true,//自适应屏幕
                    width: window.innerWidth,
                    height: window.innerHeight - 48,
                    animation: true,//开启过渡动画
                    animation_duration: 800//8秒完成动画
                }).draw();
            });
        }
        //加载数据
        function search_list() {
            var html = $.ajax({
                type: "POST",
                url: 'EmployeeSale_Load.aspx',
                data: "range=" + $("#range").val(),
                async: false
            }).responseText;
            //alert(html); return;
            hide_filter();//隐藏过滤框
            if (html == "[]") {
                $("#canvasDiv").html("<div class='no_result'>查询范围内未统计出数据<br/><br/>请点右上角图标更改范围</div>");
                return;
            }
            report_data = eval('(' + html + ')');//转换成JSON
            load_data();
        }
        //页面全部加载后
        window.onload = function () {
            search_list();
        }
    </script>
</body>
</html>


