﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Data.SqlClient;
using SysCore;
using SysCore.Control;

public partial class M_Ranking_InventoryRank_List_Load : System.Web.UI.Page
{
    public Hashtable xview = new Hashtable();
    SqlUtil su = new SqlUtil();
    protected void Page_Load(object sender, EventArgs e)
    {
        Response.Write(XiaoLiang(Request["sort"], Request["range"]));
    }
    string XiaoLiang(string sort, string range)
    {
        DateTime today = DateTime.Parse(new LoginInfo().login_date);
        string begin_date;
        string end_date;
        Hashtable ht = TimeHelper.GetRang(today, range);
        //开始日期
        begin_date = ht["begin_date"].ToString();
        //结束日期
        end_date = ht["end_date"].ToString();

        //列表查询用的sql
        string sql_list = @"
                    select top 5 * from
                    (
	                    select i.i_code,i.i_name,i.standard,
	                    sum(dos.quantity) as sum_quan,SUM(dos.nat_tax_total_price) as sum_price
	                    from Sale_DeliveryOrders dos
	                    left join Sale_DeliveryOrder do on do.do_id=dos.do_id
	                    left join Base_Inventory i on dos.i_id=i.i_id
                        where do.new_date between '@begin_date' and '@end_date'
	                    group by i.i_code,i.i_name,i.standard
                    ) t order by @sort desc";
        sql_list = sql_list.Replace("@sort", sort)
                        .Replace("@begin_date", begin_date)
                        .Replace("@end_date", end_date);
        DataTable dt = su.GetDataTable(sql_list, null);
        string append = "";
        int rank = 1;
        foreach (DataRow dr in dt.Rows)
        {
            string html = @"
                        <li>
                        <p><span class='green'><b>第@rank名</b></span></p>
                        <span class='blue'><b>@i_name</b></span><br />
                        @i_code<br />
                        量：@sum_quan<br />
                        额：@sum_price<br /></li>";
            html = html.Replace("@i_code", dr["i_code"].ToString())
                        .Replace("@i_name", dr["i_name"].ToString())
                        .Replace("@sum_quan", dr["sum_quan"].ToString())
                        .Replace("@sum_price", dr["sum_price"].ToString())
                        .Replace("@rank", rank.ToString());
            append += html;
            rank++;
        }
        return append;
    }
}