﻿<%@ Page Language="C#" AutoEventWireup="true" CodeFile="InventoryRank_List.aspx.cs" Inherits="M_Rank_Inventory_List" %>

<%@ Register Src="~/M/Include/MScript.ascx" TagPrefix="uc1" TagName="MScript" %>
<%@ Register Src="~/M/Include/MHeader.ascx" TagPrefix="uc1" TagName="MHeader" %>
<%@ Register Src="~/M/Include/MFooter.ascx" TagPrefix="uc1" TagName="MFooter" %>
<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title>商品销售排行</title>
    <uc1:MScript runat="server" ID="MScript" />
</head>
<body>
    <uc1:MHeader runat="server" ID="MHeader" />
    <div id="div_filter" style="display:none;height:160px">
    </div>
    <!-- start page -->
    <div id="main_content" class="page">
            <select id="range" onchange="init_page()">
                <option value="day">本日</option>
                <option value="week">本周</option>
                <option value="month">本月</option>
                <option value="season">本季</option>
                <option value="year">本年</option>
            </select>
            <div class="simplebox" >
            	<h1 class="titleh">产品销量 Top 5</h1>
                <div class="content">
                    <ul class="statistics" id="top_quantity">
                    </ul>
                </div>
             </div>
            <div class="simplebox">
            	<h1 class="titleh">产品销额 Top 5</h1>
                <div class="content">
                    <ul class="statistics" id="top_price">
                    </ul>
                </div>
             </div>
        <uc1:MFooter runat="server" ID="MFooter" />
    </div>
    <!-- end page -->
    <script type="text/javascript">
        //加载数据
        function init_page() {
            var range = $("#range").val();
            load_info("top_quantity", "sum_quan", range);
            load_info("top_price", "sum_price", range);
        }
        //加载数据
        function load_info(ele_id, sort, range) {
            var html = $.ajax({
                type: "POST",
                url: "InventoryRank_Load.aspx",
                data: "sort=" + sort + "&range=" + range,
                async: false
            }).responseText;
            $("#" + ele_id + "").html("");
            $("#" + ele_id + "").append(html);
        }
        //页面全部加载后
        window.onload = function () {
            init_page();
        }
    </script>
</body>
</html>


