﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Data.SqlClient;
using SysCore;
using SysCore.Control;

public partial class M_Ranking_CustomerRank_List_Load : System.Web.UI.Page
{
    public Hashtable xview = new Hashtable();
    SqlUtil su = new SqlUtil();
    protected void Page_Load(object sender, EventArgs e)
    {
        if (Request["fun"].Equals("XiaoLiang"))
        {
            Response.Write(XiaoLiang(Request["sort"], Request["range"]));
        }
        else if (Request["fun"].Equals("HuiKuan"))
        {
            Response.Write(HuiKuan(Request["range"]));
        }
    }
    /// <summary>
    /// 销售数量/金额
    /// </summary>
    /// <param name="sort">排序方式</param>
    /// <param name="range">范围</param>
    /// <returns></returns>
    string XiaoLiang(string sort, string range)
    {
        DateTime today = DateTime.Parse(new LoginInfo().login_date);
        string begin_date;
        string end_date;
        Hashtable ht = TimeHelper.GetRang(today, range);
        //开始日期
        begin_date = ht["begin_date"].ToString();
        //结束日期
        end_date = ht["end_date"].ToString();

        //列表查询用的sql
        string sql_list = @"
                    select top 5 * from
                    (
	                    select cus.cus_code,cus.cus_name,
	                    sum(dos.quantity) as sum_quan,SUM(dos.nat_tax_total_price) as sum_price
	                    from Sale_DeliveryOrders dos
	                    left join Sale_DeliveryOrder do on do.do_id=dos.do_id
	                    left join Base_Customer cus on do.cus_id=cus.cus_id
                        where do.new_date between '@begin_date' and '@end_date'
                        and isnull(do.verify_user,'')!=''
	                    group by cus.cus_code,cus.cus_name
                    ) t order by @sort desc";
        sql_list = sql_list.Replace("@sort", sort)
                        .Replace("@begin_date", begin_date)
                        .Replace("@end_date", end_date);
        DataTable dt = su.GetDataTable(sql_list, null);
        string append = "";
        int rank = 1;
        foreach (DataRow dr in dt.Rows)
        {
            string html = @"
                        <li>
                        <p><span class='green'><b>第@rank名</b></span></p>
                        <span class='blue'><b>@cus_name</b></span><br />
                        @cus_code<br />
                        销量：@sum_quan<br />
                        销额：@sum_price<br /></li>";
            html = html.Replace("@cus_code", dr["cus_code"].ToString())
                        .Replace("@cus_name", dr["cus_name"].ToString())
                        .Replace("@sum_quan", dr["sum_quan"].ToString())
                        .Replace("@sum_price", dr["sum_price"].ToString())
                        .Replace("@rank", rank.ToString());
            append += html;
            rank++;
        }
        return append;
    }
    /// <summary>
    /// 回款金额
    /// </summary>
    /// <param name="range">范围</param>
    /// <returns></returns>
    string HuiKuan(string range)
    {
        DateTime today = DateTime.Parse(new LoginInfo().login_date);
        string begin_date;
        string end_date;
        Hashtable ht = TimeHelper.GetRang(today, range);
        //月初
        begin_date = ht["begin_date"].ToString();
        //月底
        end_date = ht["end_date"].ToString();

        //列表查询用的sql
        string sql_list = @"
                    select top 5 * from
                    (
	                    select cus.cus_code,cus.cus_name,SUM(apd.nat_tax_total_price) as hui_kuan 
	                    from ARAP_APDetail apd
	                    left join Base_Customer cus on apd.cus_id=cus.cus_id
	                    where apd.rp_flag='AR'
                        and apd.new_date between '@begin_date' and '@end_date'
	                    group by cus.cus_code,cus.cus_name
                    ) t order by hui_kuan desc";
        sql_list = sql_list.Replace("@begin_date", begin_date)
                        .Replace("@end_date", end_date);
        DataTable dt = su.GetDataTable(sql_list, null);
        string append = "";
        int rank = 1;
        foreach (DataRow dr in dt.Rows)
        {
            string html = @"
                        <li>
                        <p><span class='green'><b>第@rank名</b></span></p>
                        <span class='blue'><b>@cus_name</b></span><br />
                        @cus_code<br />
                        回款金额：@hui_kuan<br /></li>";
            html = html.Replace("@cus_code", dr["cus_code"].ToString())
                        .Replace("@cus_name", dr["cus_name"].ToString())
                        .Replace("@hui_kuan", dr["hui_kuan"].ToString())
                        .Replace("@rank", rank.ToString());
            append += html;
            rank++;
        }
        return append;
    }
}