﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Data.SqlClient;
using SysCore;
using SysCore.Control;

public partial class M_Order_Product_List_Load : System.Web.UI.Page
{
    public Hashtable xview = new Hashtable();

    protected void Page_Load(object sender, EventArgs e)
    {
        if (!Page.IsPostBack)
        {
            new LoginState().CheckLoginM();
            CreateGrid();
        }
    }
    string sql_list = "";
    /// <summary>
    /// 绑定控件数据源
    /// </summary>
    public void CreateGrid()
    {
        //列表查询用的sql
        sql_list = @"
            select i.i_id,i.i_code,i.i_name,isnull(i.new_tax_unit_price,0) as new_tax_unit_price,oh.quantity,i.is_sale,
            i.standard,i.munit,i.aunit,ic.ic_id,ic.ic_code,ic.ic_name,
            i.sdefine1,i.sdefine2,i.sdefine3,i.sdefine4,i.sdefine5,
            i.ndefine1,i.ndefine2,i.ndefine3,i.ndefine4,i.ndefine5
            from Base_Inventory i 
            left join 
            (
                select i_id,sum(quantity) quantity from Stock_OnHand group by i_id
            ) as oh on i.i_id=oh.i_id
            left join Base_InventoryClass ic on ic.ic_id=i.ic_id ";

        int page = 1;//当前页
        if (Request["page"] != null)
            page = Convert.ToInt32(Request["page"]);
        int page_size = new PhoneConfig().default_page_size;//每页显示条数

        Hashtable ht = new Hashtable();
        //排序
        string order_field = "order by i_code asc";
        ht.Add("order_field", order_field);
        ht.Add("page", page);
        ht.Add("page_size", page_size);
        //查询条件
        string sql_end = "";
        if (!Request["keyword"].Equals(""))
        {
            //要搜索关键字
            string keyword = Request["keyword"].ToString();
            //要搜索的字段
            string search_fields = "i_code,i_name,standard";
            sql_end = FastSearh.MakeSearchSqlForWhere(keyword, search_fields);
        }
        //存货分类
        if (!Request["ic_code"].Equals(""))
        {
            sql_end += " and ic_code like '" + Request["ic_code"] + "%'";
        }
        //只显示销售件
        if (Request["is_sale"].Equals("1"))
        {
            sql_end += " and is_sale=1";
        }
        ht.Add("sql_end", sql_end);
        //查询后返回DataTable
        DataTable dt = GetList(ht);
        string append = "";
        foreach (DataRow dr in dt.Rows)
        {
            string html = @"
                        <li>
                        <table style='width:100%;'>
                        <tr>
                        <td style='width:80%'>
                        <span class='blue'><b>@i_name</b></span><br />
                        存货编码：@i_code<br/>
                        分类：@ic_name<br />
                        规格型号：@standard<br/>
                        结存数量：@quantity<br/>
                        报价：@new_tax_unit_price<br/><br/>
                        </td>
                        <td style='width:20%;'>
                            <div class='cart_btn' style='cursor:pointer' onclick='AddToCart(@i_id,@new_tax_unit_price,1)'>订购</div>
                        </td></tr></table></li>";
            html = html.Replace("@i_id", dr["i_id"].ToString())
                        .Replace("@i_code", dr["i_code"].ToString())
                        .Replace("@ic_name", dr["ic_name"].ToString())
                        .Replace("@i_name", dr["i_name"].ToString())
                        .Replace("@standard", dr["standard"].ToString())
                        .Replace("@munit", dr["munit"].ToString())
                        .Replace("@quantity", dr["quantity"].ToString())
                        .Replace("@new_tax_unit_price", dr["new_tax_unit_price"].ToString());
            append += html;

        }
        Response.Write(append);
    }

    /// <summary>
    /// 得到列表
    /// </summary>
    /// <param name="sql_select_field">格式定义指定显示列</param>
    /// <returns>DataTable</returns>
    public DataTable GetList(Hashtable pg)
    {
        string order_field = pg["order_field"].ToString();
        string sql = @"select top 1000000000 ROW_NUMBER() OVER(@order_field) AS row_num,* 
                from(@sql_list)t where 1=1 ";
        sql = sql.Replace("@sql_list", sql_list)
                 .Replace("@order_field", order_field);
        //分页处理与查询条件
        PageHelper ph = new PageHelper();
        sql = ph.GetPageSQL(sql, pg, true);//得到分页后的SQL
        //Response.Write(sql);
        //Response.End();
        DataTable dt = new SqlUtil().GetDataTable(sql, null);
        return dt;
    }
}