﻿<%@ Page Language="C#" AutoEventWireup="true" CodeFile="Product_List.aspx.cs" Inherits="M_Order_Product_List" %>

<%@ Register Src="~/M/Include/MScript.ascx" TagPrefix="uc1" TagName="MScript" %>
<%@ Register Src="~/M/Include/MHeader.ascx" TagPrefix="uc1" TagName="MHeader" %>
<%@ Register Src="~/M/Include/MFooter.ascx" TagPrefix="uc1" TagName="MFooter" %>
<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title>商品查询</title>
    <uc1:MScript runat="server" ID="MScript" />
    <script type="text/javascript" src="../JS/cart.js"></script>
    <link href="../Style/cart_confirm.css" rel="stylesheet" />
    <style type="text/css">
        #div_info {
            width:100%;
        }
    </style>
    <script type="text/javascript">
        //隐藏窗口
        function hide_div() {
            $("#div_info").css("display", "none");
        }
        var Cart_i_id = "";
        //打开数量输入窗口
        function AddToCart(i_id, tax_unit_price, quantity) {
            Cart_i_id = i_id;
            $("#quantity").val(quantity);
            $("#tax_unit_price").val(tax_unit_price);
            $("#div_info").css("display", "");
        }
        //添加到购物车
        function Add_Cart() {
            var quantity = $("#quantity").val();
            var tax_unit_price = $("#tax_unit_price").val();
            if (quantity == 0 || quantity < 0 || quantity == "" || isNaN(quantity)) {
                alert('请输入购买数量！'); return;
            }
            if (/*tax_unit_price == 0 ||*/ tax_unit_price < 0 || tax_unit_price == "" || isNaN(tax_unit_price)) {
                alert('请输入购买价格！'); return;
            }
            $.ajax({
                type: "POST",
                contentType: "application/json",
                url: 'Order_Service.asmx/Add_Cart',
                data: "{i_id:'" + Cart_i_id + "',tax_unit_price:'" + tax_unit_price + "',quantity:'" + quantity + "'}",
                dataType: 'json',
                success: function (result) {
                    var r = result.d;
                    if (r == "success") {
                        alert('成功添加到购物车！');
                        load_gwc();//读取购物车数量
                        hide_div();
                    } else {
                        alert(r);
                    }
                }
            });
        }


    </script>
</head>
<body>
    <uc1:MHeader runat="server" ID="MHeader" />
    <div id="div_filter" style="display:none;height:160px">
        <table class="filter_table">
            <tr>
                <td class="filter_td_1">存货分类：</td>
                <td class="filter_td_2"><%=xview["inv_class"]%></td>
            </tr>
            <tr style="display:none">
                <td class="filter_td_1">只显示销售件：</td>
                <td class="filter_td_2">
                    <select id="is_sale" style='width:80%'>
                        <option value="1">是</option>
                        <option value="">否</option>
                    </select></td>
            </tr>
        </table>
        <br />
        <a href='javascript:search_list()' class="filter_button">确定</a>
        <a href='javascript:hide_filter()' class="filter_button" style="margin-left:20px">取消</a>
    </div>
    <!-- start page -->
    <div id="main_content" class="page">
            <div class="simplebox">
                <div class="content">
                    <ul class="statistics" id="data_list"></ul>
                    <div id="load_more">正在加载..</div>
                </div>
             </div>
        <uc1:MFooter runat="server" ID="MFooter" />
    </div>
    <div class="bottom_bar">
        <!--购物车-->
        <div id="div_gwc" class="gwc-main" onclick="GotoGWC()" style="cursor:pointer;">
            <div class="gwc-num">
                <div class="gwc">
                    <div class="icon">
                        <span id="gwc_icon_num" style="">0</span>
                    </div>
                </div>
            </div>
            <div id="img_gwc" class="gwc-bg"><img src="../img/cart.png" style="width:38px;height:30px"/></div>
        </div>
        <!--end of 购物车-->
    </div>
    <!-- end page -->

    <!--数量输入框-->
    <div id="div_info" style="display: none; z-index: 998;position:fixed;top:10px;">
	    <!-- 控件的html代码 start -->
	    <div class="radio-check-after-modal">
		    <div class="modal-header" style="color:red;text-align:left;margin-left:20px" >
		    </div>
		    <div class="modal-body" style="margin:20px;">
                            价格：<br />
                        <input type="text" <%=xview["disable_edit_price"]%> id="tax_unit_price" value="" style="color:red;width:150px;margin-bottom:10px;height:40px;font-size:20pt"/><br />
                            购买数量：<br />
                        <input type="text" id="quantity" value="" style="color:blue;width:150px;margin-bottom:10px;height:40px;font-size:20pt"/><br />
                        <input type="button" value="添加到购物车" onclick="Add_Cart()" style="width:150px;height:40px;margin-top:15px;color:green" />
                        <input type="button" value="取消" onclick="hide_div()" style="width:150px;height:40px;margin-top:15px;color:black"/>
                <br />
		    </div>
	    </div>
	    <!-- 遮罩div -->
	    <div class="full-screen-modal-back"></div>
	    <!-- 控件的html代码 end -->
    </div>
    <!--end of 数量输入框-->

    <script type="text/javascript">
        var title = "商品查询";
        $("#header-title").html(title);//设置标题
        $("#btn_search").css("display", "");//显示搜索按钮
        load_by_scroll = true;//允许上翻加载更多数据
        //搜索
        function search_list() {
            page = 1;//搜索后定位到第1页
            $("#data_list").html("");//清空列表数据
            hide_filter();//隐藏过滤框
            show_hide_search_bar();//显示/隐藏搜索条
            load_page();
        }
        //加载数据
        function load_page() {
            var par = "";
            par += "&keyword=" + $("#txt_search").val()
                 + "&ic_code=" + $("#ic_code").val()
                 + "&is_sale=" + $("#is_sale").val();
            load_data("Product_List_Load.aspx", par);
        }
        //页面全部加载后
        window.onload = function () {
            var ic_code = "<%=Request["ic_code"]%>";
            if (ic_code != "") {
                $("#ic_code").val(ic_code);
            }
            load_gwc();//读取购物车数量
            load_page();
        }
    </script>
</body>
</html>


