﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Data.SqlClient;
using SysCore;
using SysCore.Control;

public partial class M_Order_ProductCategory_List_Load : System.Web.UI.Page
{
    public Hashtable xview = new Hashtable();

    protected void Page_Load(object sender, EventArgs e)
    {
        if (!Page.IsPostBack)
        {
            new LoginState().CheckLogin();
            CreateGrid();
        }
    }
    string sql_list = "";
    /// <summary>
    /// 绑定控件数据源
    /// </summary>
    public void CreateGrid()
    {
        string ic_code = "";
        if (Request["ic_code"] != null)
        {
            ic_code = Request["ic_code"];
        }
        InventoryClassDAL ic_dal = new InventoryClassDAL();
        //列表查询用的sql
        sql_list = @"
            select ic_id,ic_code,ic_name from Base_InventoryClass where 1=1 ";
        if (ic_code.Equals(""))
        {
            sql_list += " and parent_id=0";
        }
        else
        {
            int parent_id = ic_dal.GetIdByCode(ic_code);
            sql_list += " and parent_id=" + parent_id.ToString();
        }
        int page = 1;//当前页
        if (Request["page"] != null)
            page = Convert.ToInt32(Request["page"]);
        int page_size = new PhoneConfig().default_page_size;//每页显示条数

        Hashtable ht = new Hashtable();
        //排序
        string order_field = "order by ic_name asc";
        ht.Add("order_field", order_field);
        ht.Add("page", page);
        ht.Add("page_size", page_size);
        //查询条件
        string sql_end = "";
        if (!Request["keyword"].Equals(""))
        {
            //要搜索关键字
            string keyword = Request["keyword"].ToString();
            //要搜索的字段
            string search_fields = "ic_name";
            sql_end = FastSearh.MakeSearchSqlForWhere(keyword, search_fields);
        }

        ht.Add("sql_end", sql_end);
        //查询后返回DataTable
        DataTable dt = GetList(ht);
        string append = "";
        foreach (DataRow dr in dt.Rows)
        {
            string url = "";
            string this_ic_code = dr["ic_code"].ToString();
            if (ic_dal.CheckHasChild(Convert.ToInt32(dr["ic_id"])))
            {
                url = "ProductCategory_List.aspx?ic_code=@ic_code";
            }
            else
            {
                url = "Product_List.aspx?ic_code=@ic_code";
            }
            string html = "<li onclick='window.location=@url'>@ic_name<br /></li>";
            html = html.Replace("@url", "\"" + url + "\"")
                       .Replace("@ic_code", dr["ic_code"].ToString())
                       .Replace("@ic_name", dr["ic_name"].ToString());
            append += html;

        }
        Response.Write(append);
    }

    /// <summary>
    /// 得到列表
    /// </summary>
    /// <param name="sql_select_field">格式定义指定显示列</param>
    /// <returns>DataTable</returns>
    public DataTable GetList(Hashtable pg)
    {
        string order_field = pg["order_field"].ToString();
        string sql = @"select top 1000000000 ROW_NUMBER() OVER(@order_field) AS row_num,* 
                from(@sql_list)t where 1=1 ";
        sql = sql.Replace("@sql_list", sql_list)
                 .Replace("@order_field", order_field);
        //分页处理与查询条件
        PageHelper ph = new PageHelper();
        sql = ph.GetPageSQL(sql, pg, true);//得到分页后的SQL
        //Response.Write(sql);
        //Response.End();
        DataTable dt = new SqlUtil().GetDataTable(sql, null);
        return dt;
    }
}