﻿<%@ Page Language="C#" AutoEventWireup="true" CodeFile="ProductCategory_List.aspx.cs" Inherits="M_Order_ProductCategory_List" %>

<%@ Register Src="~/M/Include/MScript.ascx" TagPrefix="uc1" TagName="MScript" %>
<%@ Register Src="~/M/Include/MHeader.ascx" TagPrefix="uc1" TagName="MHeader" %>
<%@ Register Src="~/M/Include/MFooter.ascx" TagPrefix="uc1" TagName="MFooter" %>
<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title>商品查询</title>
    <uc1:MScript runat="server" ID="MScript" />
    <script type="text/javascript" src="../JS/cart.js"></script>
    <link href="../Style/cart_confirm.css" rel="stylesheet" />
    <style type="text/css">
        .gwc-main {
	        width: 58px; height: 44px; float: right; position: relative;
        }
        .gwc-bg {
	        top: 6px; position: absolute; z-index: 500;
        }
        .gwc-bg img {
	        width: 26px; height: 24px;
        }
        .gwc-num {
	        top: 2px; right: 24px; position: absolute; z-index: 501;
        }
        .gwc div.icon span {
	        background-position: -30px 50%; border-radius: 60px; width: 20px; height: 20px; text-align: center; color: rgb(255, 255, 255); line-height: 20px; text-indent: 0px; font-size: 0.8em; float: left; display: block; background-color: rgb(255, 144, 0); -moz-transition-duration: .8s;
        }
        .cart_btn{
            font-size:10pt !important;
	        margin-top:20px;
	        background:#ffa000;
	        height:28px;
	        line-height:28px;
	        width:58px;
	        color:#fff;
	        float:right;
	        text-align:center;
        }
    </style>


</head>
<body>
    <uc1:MHeader runat="server" ID="MHeader" />
    <div id="div_filter" style="display:none;height:160px">
        <br />
        <a href='javascript:search_list()' class="filter_button">确定</a>
        <a href='javascript:hide_filter()' class="filter_button" style="margin-left:20px">取消</a>
    </div>
    <!-- start page -->
    <div id="main_content" class="page">
            <div class="simplebox">
                <div class="content">
                    <ul class="statistics" id="data_list"></ul>
                    <div id="load_more">正在加载..</div>
                </div>
             </div>
        <uc1:MFooter runat="server" ID="MFooter" />
    </div>
    <div class="bottom_bar">
        <!--购物车-->
        <div id="div_gwc" class="gwc-main" onclick="GotoGWC()" style="cursor:pointer;">
            <div class="gwc-num">
                <div class="gwc">
                    <div class="icon">
                        <span id="gwc_icon_num" style="">0</span>
                    </div>
                </div>
            </div>
            <div id="img_gwc" class="gwc-bg"><img src="../img/cart.png" style="width:38px;height:30px"/></div>
        </div>
        <!--end of 购物车-->
    </div>
    <!-- end page -->
    <script type="text/javascript">
        var title = "商品分类";
        $("#header-title").html(title);//设置标题
        $("#btn_search").css("display", "");//显示搜索按钮
        load_by_scroll = true;//允许上翻加载更多数据
        //搜索
        function search_list() {
            page = 1;//搜索后定位到第1页
            $("#data_list").html("");//清空列表数据
            hide_filter();//隐藏过滤框
            show_hide_search_bar();//显示/隐藏搜索条
            load_page();
        }
        var ic_code = '<%=Request["ic_code"]%>';
        //加载数据
        function load_page() {
            var par = "";
            par += "&keyword=" + $("#txt_search").val()
                + "&ic_code=" + ic_code;
            load_data("ProductCategory_List_Load.aspx", par);
        }
        //页面全部加载后
        window.onload = function () {
            load_gwc();//读取购物车数量
            load_page();
        }
    </script>
</body>
</html>


