﻿<%@ WebService Language="C#" Class="Order_Service" %>

using System;
using System.Web;
using System.Web.Services;
using System.Web.Services.Protocols;
using SysCore;

[WebService(Namespace = "http://tempuri.org/")]
[WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1)]
// 若要允许使用 ASP.NET AJAX 从脚本中调用此 Web 服务，请取消注释以下行。 
[System.Web.Script.Services.ScriptService]
public class Order_Service  : System.Web.Services.WebService {

    /// <summary>
    /// 添加到购物车
    /// </summary>
    /// <param name="i_id">存货id</param>
    /// <param name="tax_unit_price">单价</param>
    /// <param name="quantity">数量</param>
    /// <returns></returns>
    [WebMethod(EnableSession=true)]
    public string Add_Cart(string i_id, string tax_unit_price, string quantity)
    {
        try
        {
            Cart m = new Cart();
            m.uid = new LoginInfo().uid;
            m.i_id = Convert.ToInt32(i_id);
            m.tax_unit_price = XTools.ObjectNullToDecimal(tax_unit_price);
            m.quantity = XTools.ObjectNullToDecimal(quantity);
            new CartDAL().Add(m);
        }
        catch (Exception err)
        {
            return err.Message;
        }
        return "success";
    }
    /// <summary>
    /// 得到购物车总数量
    /// </summary>
    /// <returns></returns>
    [WebMethod(EnableSession=true)]
    public string GetCartNum()
    {
        try
        {
            return new CartDAL().GetCartNum(new LoginInfo().uid).ToString();
        }
        catch (Exception err)
        {
            return err.Message;
        }
    }
    /// <summary>
    /// 更改购物车总数量
    /// </summary>
    /// <returns></returns>
    [WebMethod(EnableSession = true)]
    public string ChangeCart(string cart_id, string quantity)
    {
        try
        {
            if (quantity.Equals("") || Convert.ToInt32(quantity) == 0)
                return "数量不允许为零！";
            CartDAL dal = new CartDAL();
            Cart m = dal.Get(Convert.ToInt32(cart_id));
            m.quantity = XTools.ObjectNullToDecimal(quantity);
            dal.Update(m);
        }
        catch (Exception err)
        {
            return err.Message;
        }
        return "success";
    }
    /// <summary>
    /// 删除购物某行
    /// </summary>
    /// <returns></returns>
    [WebMethod(EnableSession = true)]
    public string DeleteCart(string cart_id)
    {
        try
        {
            CartDAL dal = new CartDAL();
            dal.Delete(Convert.ToInt32(cart_id));
        }
        catch (Exception err)
        {
            return err.Message;
        }
        return "success";
    }
}