﻿<%@ Page Language="C#" AutoEventWireup="true" CodeFile="CompleteOrder.aspx.cs" Inherits="M_Order_CompleteOrder" %>

<%@ Register Src="~/M/Include/MScript.ascx" TagPrefix="uc1" TagName="MScript" %>
<%@ Register Src="~/M/Include/MHeader.ascx" TagPrefix="uc1" TagName="MHeader" %>
<%@ Register Src="~/M/Include/MFooter.ascx" TagPrefix="uc1" TagName="MFooter" %>
<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title>商品查询</title>
    <uc1:MScript runat="server" ID="MScript" />
    <script type="text/javascript" src="../../Component/SearchService/SearchService.js"></script>
    <script type="text/javascript" src="../MSearch/MSearch.js"></script>
</head>
<body>
    <uc1:MHeader runat="server" ID="MHeader" />
    <div id="div_filter" style="display:none;height:160px">
        <br />
        <input type="button" value="确定" class="filter_button" onclick="search_list()" />
        <input type="button" value="取消" class="filter_button" onclick="hide_filter()"/>
    </div>
    <!-- start page -->
    <div id="main_content" class="page">
            <div class="simplebox">
            	<h1 class="titleh">购物车</h1>
                <div class="content">
                    <div>客户：</div>
                    <div>
                        <input type="text" id="cus_name" value="" readonly="readonly" style="float:left;" class="form_text" />
                        <input type="hidden" id="cus_id" value=""/>
                        <div style="clear:both"></div>
                    </div>
                    <div>业务员：</div>
                    <div>
                        <input type="text" id="ele_name" value="" readonly="readonly" style="float:left" class="form_text" />
                        <input type="hidden" id="ele_id" value=""/>
                        <div style="clear:both"></div>
                    </div>
                    <div>联系人：</div>
                    <div>
                        <input type="text" id="contact" value="" style="float:left" class="form_text" />
                        <div style="clear:both"></div>
                    </div>
                    <div>电话：</div>
                    <div>
                        <input type="text" id="phone" value="" style="float:left" class="form_text" />
                        <div style="clear:both"></div>
                    </div>
                    <div>发货地址：</div>
                    <div>
                        <input type="text" id="ship_address" value="" style="float:left" class="form_text" />
                        <div style="clear:both"></div>
                    </div>
                    <div>备注：</div>
                    <div>
                        <input type="text" id="remark" value="" style="float:left" class="form_text" />
                        <div style="clear:both"></div>
                    </div>
                </div>
             </div>
        <uc1:MFooter runat="server" ID="MFooter" />
    </div>
    <div class="bottom_bar">
        <input type="button" value="提交订单" class="orange_btn" onclick="submit_order()" style="margin-top:6px;float:right"/>
    </div>
    <div id="m_search" style="display:none;">
        <input type="button" class="often_btn" value="返回" onclick="hide_m_search()"/>
        <input type="text" id="m_keyword"/>
        <ul id="m_search_results"></ul>
    </div>
    <!-- end page -->
    <script type="text/javascript">
        $("#btn_search").css("display", "none");//显示搜索按钮
        //搜索
        function search_list() {

        }
        //页面全部加载后
        window.onload = function () {
            MSearch("ele_name", "SearchService_Employee", "MSearch_Employee.aspx");
            MSearch("cus_name", "SearchService_Customer", "MSearch_Customer.aspx");
        }

        //改变购物车数量
        function change_cart(cart_id, quantity) {
            $.ajax({
                type: "POST",
                contentType: "application/json",
                url: 'Order_Service.asmx/ChangeCart',
                data: "{cart_id:'" + cart_id + "', quantity:'" + quantity + "'}",
                dataType: 'json',
                success: function (result) {
                    if (result.d != "success") {
                        alert(result.d);
                    }
                }
            });
        }


        //通过主键_获取客户
        function SearchService_Customer(cus_id) {
            $.ajax({
                type: "POST",
                contentType: "application/json",
                url: '../../Base/Customer/Customer_Service.asmx/Get',
                data: "{cus_id:'" + cus_id + "'}",
                dataType: 'json',
                success: function (result) {
                    $("#cus_id").val(result.d.cus_id);
                    $("#cus_name").val(result.d.cus_name);
                    $("#phone").val(result.d.phone);
                    $("#contact").val(result.d.contact);
                    $("#ship_address").val(result.d.ship_address);
                    if (result.d.employee != null) {
                        $("#ele_id").val(result.d.ele_id);
                        $("#ele_name").val(result.d.employee.ele_name);
                    }
                    hide_m_search();
                }
            });
        }
        //通过主键_获取员工
        function SearchService_Employee(ele_id) {
            $.ajax({
                type: "POST",
                contentType: "application/json",
                url: '../../Base/Employee/Employee_Service.asmx/Get',
                data: "{ele_id:'" + ele_id + "'}",
                dataType: 'json',
                success: function (result) {
                    $("#ele_id").val(result.d.ele_id);
                    $("#ele_name").val(result.d.ele_name);
                    hide_m_search();
                }
            });
        }
        //提交订单
        function submit_order() {
            if ($("#cus_name").val() == "") {
                $("#cus_id").val("");
            }
            if ($("#ele_name").val() == "") {
                $("#ele_id").val("");
            }
            var cus_id = $("#cus_id").val();
            var ele_id = $("#ele_id").val();
            var remark = $("#remark").val();
            $.ajax({
                type: "POST",
                contentType: "application/json",
                url: '../../Interface/SalesOrderIF.asmx/AddOrder',
                data: "{cus_id:'" + cus_id + "', ele_id:'" + ele_id + "',contact:'" + contact + "',phone:'" + phone + "',ship_address:'" + ship_address + "',remark:'" + remark + "'}",
                dataType: 'json',
                success: function (result) {
                    var arr = result.d.split("|");
                    if (arr[0] == "success") {
                        alert("已生成订单！");
                        window.location = "../Verify/Menu.aspx";
                    } else {
                        alert(result.d);
                    }
                }
            });
        }
    </script>
</body>
</html>


