﻿<%@ Page Language="C#" AutoEventWireup="true" CodeFile="Cart_List.aspx.cs" Inherits="M_Order_Cart_List" %>

<%@ Register Src="~/M/Include/MScript.ascx" TagPrefix="uc1" TagName="MScript" %>
<%@ Register Src="~/M/Include/MHeader.ascx" TagPrefix="uc1" TagName="MHeader" %>
<%@ Register Src="~/M/Include/MFooter.ascx" TagPrefix="uc1" TagName="MFooter" %>
<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title>商品查询</title>
    <uc1:MScript runat="server" ID="MScript" />
</head>
<body>
    <uc1:MHeader runat="server" ID="MHeader" />
    <div id="div_filter" style="display:none;height:160px">
        <br />
        <a href='javascript:search_list()' class="filter_button">确定</a>
        <a href='javascript:hide_filter()' class="filter_button" style="margin-left:20px">取消</a>
    </div>
    <!-- start page -->
    <div id="main_content" class="page">
            <div class="simplebox">
                <div class="content">
                    <ul class="statistics" id="data_list"></ul>
                    <div id="load_more">正在加载..</div>
                </div>
             </div>
        <uc1:MFooter runat="server" ID="MFooter" />
    </div>
    <div class="bottom_bar">
        <input type="button" value="完善订单" class="orange_btn" onclick="complete_order()" style="margin-top:6px;float:right"/>
    </div>
    <!-- end page -->
    <script type="text/javascript">
        var title = "购物车";
        $("#header-title").html(title);//设置标题
        $("#btn_search").css("display", "");//显示搜索按钮
        load_by_scroll = true;//允许上翻加载更多数据
        //搜索
        function search_list() {
            page = 1;//搜索后定位到第1页
            $("#data_list").html("");//清空列表数据
            hide_filter();//隐藏过滤框
            show_hide_search_bar();//显示/隐藏搜索条
            load_page();
        }
        //加载数据
        function load_page() {
            var par = "";
            par += "&keyword=" + $("#txt_search").val();
            load_data("Cart_List_Load.aspx", par);
        }
        //页面全部加载后
        window.onload = function () {
            load_page();
        }
        //改变购物车数量
        function change_cart(cart_id, quantity) {
            $.ajax({
                type: "POST",
                contentType: "application/json",
                url: 'Order_Service.asmx/ChangeCart',
                data: "{cart_id:'" + cart_id + "', quantity:'" + quantity + "'}",
                dataType: 'json',
                success: function (result) {
                    if (result.d != "success") {
                        alert(result.d);
                    }
                }
            });
        }
        //删除购物某行
        function delete_cart(cart_id) {
            if (!confirm('确定要删除吗?'))
                return;
            $.ajax({
                type: "POST",
                contentType: "application/json",
                url: 'Order_Service.asmx/DeleteCart',
                data: "{cart_id:'" + cart_id + "'}",
                dataType: 'json',
                success: function (result) {
                    if (result.d != "success") {
                        alert(result.d);
                    } else {
                        page = 1;//搜索后定位到第1页
                        $("#data_list").html("");//清空列表数据
                        load_page();
                        alert("删除成功!");
                     }
                }
            });
        }
        //完善订单
        function complete_order() {
            $.ajax({
                type: "POST",
                contentType: "application/json",
                url: 'Order_Service.asmx/GetCartNum',
                data: "{}",
                dataType: 'json',
                success: function (result) {
                    if (result.d != 0) {
                        window.location = "CompleteOrder.aspx";
                    } else {
                        alert("您还未选购商品!");
                    }
                }
            });
        }
    </script>
</body>
</html>


