﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Data.SqlClient;
using SysCore;
using SysCore.Control;

public partial class M_Daily_ManagementDaily_List_Load : System.Web.UI.Page
{
    public Hashtable xview = new Hashtable();
    SqlUtil su = new SqlUtil();
    protected void Page_Load(object sender, EventArgs e)
    {
        Response.Write(InitPage(Request["range"]));
    }
    string InitPage(string range)
    {
        DateTime today = DateTime.Parse(new LoginInfo().login_date);
        string begin_date;
        string end_date;
        Hashtable ht = TimeHelper.GetRang(today, range);
        //开始日期
        begin_date = ht["begin_date"].ToString();
        //结束日期
        end_date = ht["end_date"].ToString();

        string sql = @"
            select SUM(cas.tax_total_price) as sale_amount
						from ARAP_CheckAccounts cas
						left join ARAP_CheckAccount ca on ca.ca_id=cas.ca_id
            where rp_flag='AR' and isnull(ca.verify_user,'')!=''
            and ca.new_date between '@begin_date' and '@end_date'";
        sql = sql.Replace("@begin_date", begin_date)
                           .Replace("@end_date", end_date);
        DataRow dr = su.GetDataTable(sql, null).Rows[0];
        string sale_amount = dr["sale_amount"].ToString();

        sql = @"
            select SUM(cas.tax_total_price) as purchase_amount
						from ARAP_CheckAccounts cas
						left join ARAP_CheckAccount ca on ca.ca_id=cas.ca_id
            where rp_flag='AP' and isnull(ca.verify_user,'')!=''
            and ca.new_date between '@begin_date' and '@end_date'";

        sql = sql.Replace("@begin_date", begin_date)
                           .Replace("@end_date", end_date);
        dr = su.GetDataTable(sql, null).Rows[0];
        string purchase_amount = dr["purchase_amount"].ToString();

        sql = @"
            select sum(sk_amount) as sk_amount,sum(fk_amount) as fk_amount from
            (
                select case when rp_flag='AR' then nat_amount else 0 end as sk_amount,
                case when rp_flag='AP' then nat_amount else 0 end as fk_amount
                from ARAP_SFKuan
                where isnull(verify_user,'')<>''
                and new_date between '@begin_date' and '@end_date'
            ) t ";
        sql = sql.Replace("@begin_date", begin_date)
                           .Replace("@end_date", end_date);
        dr = su.GetDataTable(sql, null).Rows[0];
        string sk_amount = dr["sk_amount"].ToString();
        string fk_amount = dr["fk_amount"].ToString();




        string append = "";
        string html = @"
                    <li>销售金额：
                    <span class='red'><b>@sale_amount</b></span></li>
                    <li>采购金额：
                    <span class='red'><b>@purchase_amount</b></span></li>
                    <li>收款金额：
                    <span class='red'><b>@sk_amount</b></span></li>
                    <li>付款金额：
                    <span class='red'><b>@fk_amount</b></span></li>";
        html = html.Replace("@sale_amount", sale_amount.ToString())
                   .Replace("@purchase_amount", purchase_amount.ToString())
                   .Replace("@sk_amount", sk_amount.ToString())
                   .Replace("@fk_amount", fk_amount.ToString());
        append += html;

        //Response.Write(sql_list);
        return append;
    }
}