﻿<%@ WebService Language="C#" Class="YingFu_Service" %>

using System;
using System.Web;
using System.Web.Services;
using System.Web.Services.Protocols;
using SysCore;
using SysCore.Model;
using SysCore.DAL;

[WebService(Namespace = "http://tempuri.org/")]
[WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1)]
// 若要允许使用 ASP.NET AJAX 从脚本中调用此 Web 服务，请取消注释以下行。 
[System.Web.Script.Services.ScriptService]
public class YingFu_Service  : System.Web.Services.WebService {
    /// <summary>
    /// 删除
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string Delete(string ids)
    {
        YingFuDAL dal = new YingFuDAL();
        foreach (string id in ids.Split(','))
        {
            try
            {
                if (!id.Equals(""))
                {
                    dal.Delete(Convert.ToInt32(id));
                }
            }
            catch (Exception e)
            {
                return e.Message;
            }
        }
        return "success";
    }
    /// <summary>
    /// 获取
    /// </summary>
    [WebMethod(EnableSession = true)]
    public YingFu Get(string yf_id)
    {
        YingFuDAL dal = new YingFuDAL();
        return dal.Get(Convert.ToInt32(yf_id));
    }
    /// <summary>
    /// 修改
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string Save(string action, string yf_id, string digest, string add_date, 
        string amount,string cus_id, string cus_name, string vd_id, string vd_name,
        string ele_id, string cst_id, string cst_name, string remark)
    {
        add_date = add_date.Trim();
        try
        {
            YingFuDAL dal = new YingFuDAL();
            YingFu m = new YingFu();
            if (action.Equals("Update"))
            {
                m = dal.Get(Convert.ToInt32(yf_id));
            }
            m.digest = digest;
            m.add_date = XTools.ObjectNullToDateTime(add_date);
            m.amount = XTools.ObjectNullToDecimal(amount);
            m.cus_id = XTools.ObjectNullToInt(cus_id);
            m.vd_id = XTools.ObjectNullToInt(vd_id);
            m.ele_id = XTools.ObjectNullToInt(ele_id);
            m.cst_id = XTools.ObjectNullToInt(cst_id);
            m.remark = remark;
            if (action.Equals("Update"))
            {
                dal.Update(m);
            }
            else
            {
                dal.Add(m);
            }
            return "success";
        }
        catch (Exception e)
        {
            return e.Message;
        }
    }
 
}