﻿<%@ WebService Language="C#" Class="DayAccount_Service" %>

using System;
using System.Web;
using System.Web.Services;
using System.Web.Services.Protocols;
using SysCore;
using SysCore.Model;
using SysCore.DAL;

[WebService(Namespace = "http://tempuri.org/")]
[WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1)]
// 若要允许使用 ASP.NET AJAX 从脚本中调用此 Web 服务，请取消注释以下行。 
[System.Web.Script.Services.ScriptService]
public class DayAccount_Service  : System.Web.Services.WebService {
    /// <summary>
    /// 删除
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string Delete(string ids)
    {
        DayAccountDAL dal = new DayAccountDAL();
        foreach (string id in ids.Split(','))
        {
            try
            {
                if (!id.Equals(""))
                {
                    dal.Delete(Convert.ToInt32(id));
                }
            }
            catch (Exception e)
            {
                return e.Message;
            }
        }
        return "success";
    }
    /// <summary>
    /// 获取
    /// </summary>
    [WebMethod(EnableSession = true)]
    public DayAccount Get(string da_id)
    {
        DayAccountDAL dal = new DayAccountDAL();
        return dal.Get(Convert.ToInt32(da_id));
    }
    /// <summary>
    /// 修改
    /// </summary>
    [WebMethod(EnableSession = true)]
    public string Save(string action, string owner, string da_id, string digest, string add_date, 
        string direction,  string amount,
        string cus_id, string cus_name, string vd_id, string vd_name,
        string ele_id, string cst_id, string cst_name, string remark)
    {
        add_date = add_date.Trim();
        try
        {
            DayAccountDAL dal = new DayAccountDAL();
            DayAccount m = new DayAccount();
            if (action.Equals("Update"))
            {
                m = dal.Get(Convert.ToInt32(da_id));
            }
            if (!vd_id.Equals(""))
            {
                if (cus_id.Equals(""))
                {
                    return "有[供应商]必须要有【工地】！";
                }
            }
            if (!ele_id.Equals(""))
            {
                if (cus_id.Equals(""))
                {
                    return "有[员工]必须要有【工地】！";
                }
                if (cst_id.Equals(""))
                {
                    //return "有[员工]必须要有【费用类型】！";
                }
            }
            m.digest = digest;
            m.add_date = XTools.ObjectNullToDateTime(add_date);
            m.direction = direction;
            m.amount = XTools.ObjectNullToDecimal(amount);
            m.cus_id = XTools.ObjectNullToInt(cus_id);
            m.vd_id = XTools.ObjectNullToInt(vd_id);
            m.ele_id = XTools.ObjectNullToInt(ele_id);
            m.cst_id = XTools.ObjectNullToInt(cst_id);
            m.owner = Convert.ToInt32(owner);
            m.remark = remark;
            
            if (action.Equals("Update"))
            {
                dal.Update(m);
            }
            else
            {
                dal.Add(m);
            }
            return "success";
        }
        catch (Exception e)
        {
            return e.Message;
        }
    }
 
}